/*
========================================================================
ferdelance3G_conditions.js
This file is part of the 'Ferdelance 3G' expansion pack.
Author: UK_Eliter
License: 2017 Creative Commons: attribution, non-commercial, sharealike.
========================================================================
*/


/*
====================
JSLINT: set options
====================
*/

/*jshint esversion: 6*/
/*jshint sub:true*/


this.name = "ferdelance3G_conditionsScript";
this.author = "UK_Eliter";
this.description = "ferdelance3G_conditionsScript.js";
this.copyright = "2014 Creative Commons: attribution, non-commercial, sharealike.";
this.licence = "CC-NC-SA 3";


/*
====--------------
DEBUGGING SWITCHES
------------------
*/

var consoleDebugMessages = false; // do NOT comment this out. Rather, to disable, set to false.
//this.logging = true; // THIS SHOULD BE COMMENTED OUT WHEN NOT TESTING
//this.debug = false;


/*
------------------------
JSLINT: start of wrapper
------------------------
*/

(function() {
	"use strict";


	/*
	------------------
	CONDITION ROUTINES
	------------------
	*/

	this.allowAwardEquipment = function(eqKey, ship, context) {
		var chance = 0;
		switch (eqKey) {
			case "EQ_F3G_ANTISWEEP_MISSILE":
				if (player.ship.dockedStation === "Navy SecCom Station") {
					chance = 0.87;
				} else if (system.techLevel > 10) {
					chance = 0.7;
				} else {
					if (system.techLevel > 8) {
						chance = 0.45;
					}
				}
		}
		if (chance === 0) {
			return;
		}
		if (Math.random() < 0.9 && system.scrambledPseudoRandomNumber(6921) < chance) {
			return true;
		}
		if (Math.random() < chance) {
			return true;
		}
		return false;
	};

	this.updateEquipmentPrice = function(eqKey, currentPrice) {
		var myPrice;
		switch (eqKey) {
			case "EQ_F3G_ANTISWEEP_MISSILE":
				if (player.ship.dockedStation === "Navy SecCom Station") {
					myPrice = 1000;
					return (myPrice);
				}
				// Otherwise
				if (system.techLevel > 10) {
					if (Math.random() < 0.95) {
						myPrice = 13000 + ((Math.ceil(system.scrambledPseudoRandomNumber(3420) * 10)) * 1000);
					} else {
						myPrice = 13000 + ((Math.ceil(Math.random() * 10)) * 1000);
					}
					return (myPrice);
				}
				// Otherwise
				if (system.techLevel > 8) {
					if (Math.random() < 0.95) {
						myPrice = 10000 + ((Math.ceil(system.scrambledPseudoRandomNumber(3420) * 18)) * 1000);
					} else {
						myPrice = 10000 + ((Math.ceil(Math.random() * 18)) * 1000);
					}
					return (myPrice);
				}
		}
	};


	/*
	----------------------
	JSLINT: end of wrapper
	----------------------
	*/

}).call(this);


// EOF