/* nexus_missile_bugOff.js */

/*
------------------------
JSHINT: Options
------------------------
*/

/*jshint esversion: 6*/
/*jshint sub:true*/


this.name = "nexus_missile_bugOff";
this.author = "UK_Eliter";
this.description = "Script for Nexus BugOff missile";
this.copyright = "2014 Creative Commons: attribution, non-commercial, sharealike.";
this.licence = "CC-NC-SA 3";


/*
--------------
DEBUG SWTICHES
--------------
*/

// this.logging = true; // THIS SHOULD BE COMMENTED OUT WHEN NOT TESTING
// this.debug = false;


/*
------------------------
JSHINT: start of wrapper
------------------------
*/

(function() {
	"use strict";


	/*
	---------
	MAIN CODE
	---------
	*/

	this.shipSpawned = function() {
		this.MissileEnergyThreshhold = this.ship.maxEnergy * 0.7;
		delete this.shipSpawned;
	};

	this.shipTakingDamage = function(amount) {
		if (amount > 65 || this.ship.energy > this.MissileEnergyThreshhold) {
			return;
		}
		if (Math.random() < 0.9) {
			this.$spawnWarheads();
		}
	};

	this.$spawnWarheads = function() {
		var chanceMalfunction;
		if (this.ship.hasRole("EQ_NEXUS_BUG_R_MISSILE")) {
			chanceMalfunction = 0.1;
		} else {
			chanceMalfunction = 0.025;
		}
		var totalNumberOfWarheadsToBeSpawned;
		if (Math.random() < chanceMalfunction) {
			// Malfunctioning missile
			totalNumberOfWarheadsToBeSpawned = ~~(Math.random() * 5); // = Between - and 4.
			if (totalNumberOfWarheadsToBeSpawned < 3) {
				if (Math.random() < 0.7) {
					totalNumberOfWarheadsToBeSpawned++;
				} else if (totalNumberOfWarheadsToBeSpawned === 0) {
					if (Math.random() < 0.3) {
						this.ship.explode();
					} else {
						this.ship.switchAI("nullAI.plist");
					}
					return;
				}
			}
		} else {
			totalNumberOfWarheadsToBeSpawned = 5;
		}

		var primaryWarhead = this.ship.spawnOne("nexus-bug-warhead-primary");
		// PRIMARY warhead. Its target will be the missile's target

		if (totalNumberOfWarheadsToBeSpawned > 1) {
			var secondaryWarheads;
			if (!primaryWarhead || !primaryWarhead.isValid) {
				secondaryWarheads = this.ship.spawn("nexus-bug-warhead-secondary", totalNumberOfWarheadsToBeSpawned);
				// this will set warheads targets to the missile's target
			} else {
				secondaryWarheads = this.ship.spawn("nexus-bug-warhead-secondary", (totalNumberOfWarheadsToBeSpawned - 1));
				// this will set warheads targets to the missile's target
			}
		}
		// this.ship.switchAI("nullAI.plist");
		this.ship.explode();
	};

	this.$detonate = function() {
		// Called only by AI.
		this.ship.dealEnergyDamage(650, 50, 0.25);
		this.ship.explode();
	};


	/*
	----------------------
	JSHINT: end of wrapper
	----------------------
	*/

}).call(this);


// EOF