/* nexus_conditions.js */

/*
------------------------
JSHINT: Options
------------------------
*/

/*jshint esversion: 6*/
/*jshint sub:true*/


this.name = "nexus_conditionsScript";
this.author = "UK_Eliter";
this.description = "Conditions script for Nexus missile";
this.copyright = "2014 Creative Commons: attribution, non-commercial, sharealike.";
this.licence = "CC-NC-SA 3";


/*
--------------
DEBUG SWITCHES
--------------
*/

//this.logging = true; // THIS SHOULD BE COMMENTED OUT WHEN NOT TESTING
//this.debug = false;



/*
------------------------
JSHINT: start of wrapper
------------------------
*/

(function() {
	"use strict";


	/*
	---------
	MAIN CODE
	---------
	*/

	this.allowAwardEquipment = function(eqKey, ship, context) {
		var chance = 0;
		//
		switch (eqKey) {
			case "EQ_NEXUS_BASIC_MISSILE":
				chance = 0.9;
				break;
			case "EQ_NEXUS_PREMIUM_MISSILE":
				chance = 0.8;
				break;
			case "EQ_NEXUS_ULTIMATE_MISSILE":
				chance = 0.6;
				break;
			case "EQ_NEXUS_BUG_MISSILE":
				if (player.ship.dockedStation === "Navy SecCom Station") {
					chance = 0.9;
				} else {
					chance = 0.4;
				}
				break;
			case "EQ_NEXUS_BUG_R_MISSILE":
				if (player.ship.dockedStation === "Navy SecCom Station") {
					chance = 0.5;
				} else {
					chance = 0.8;
				}
		}
		if (chance === 0) {
			return false;
		}
		if (Math.random() < 0.9) {
			if (system.scrambledPseudoRandomNumber(5922) < chance) {
				return true;
			}
		} else if (Math.random() < chance) {
			return true;
		}
		return false;
	};


	/*
	----------------------
	JSHINT: end of wrapper
	----------------------
	*/

}).call(this);

// EOF