/* nexus_warhead_bugOff.js */

/*
------------------------
JSHINT: Options
------------------------
*/

/*jshint esversion: 6*/
/*jshint sub:true*/


this.name = "nexus_warhead_bugOff";
this.author = "UK_Eliter";
this.description = "Script for Nexus BugOff warhead";
this.copyright = "2014 Creative Commons: attribution, non-commercial, sharealike.";
this.licence = "CC-NC-SA 3";

// Associated AI	nexus_warheadAI.PLIST


/*
--------------
DEBUG SWTICHES
---------------
*/
//this.logging = true; // THIS SHOULD BE COMMENTED OUT WHEN NOT TESTING
//this.debug = false;


/*
------------------------
JSHINT: start of wrapper
------------------------
*/

(function() {
	"use strict";


	/*
	---------
	MAIN CODE
	---------
	*/

	this.$isBug = function(e) {
		return e.isShip && e.isThargoid;
	};


	// Called only by AI.
	this.$detonate = function() {
		this.ship.dealEnergyDamage(140, 30, 0.14);
		// function dealEnergyDamage(damage : Number, idealRange : Number [, velocityBias : Number])
		// The standard Oolite missile uses dealEnergyDamage(170, 32.5, 0.25), has a maximum speed of 0.75LM, and its AI tries to detonate it 25m from its target. [NB: If target within ideal range, takes full damage.]

		// Deal additional damage to anything thargoid.
		var s = system.filteredEntities(this, this.$isBug, this.ship, 150);
		var i = s.length;
		while (i--) {
			s[i].energy -= 65;
		}

		// Remove the warhead.
		this.ship.explode();
	};


	/*
	----------------------
	JSHINT: end of wrapper
	----------------------
	*/

}).call(this);


// EOF