/* nexus_warhead_basicOrPremiumOrUltimate.js */

/*
------------------------
JSHINT: Options
------------------------
*/

/*jshint esversion: 6*/
/*jshint sub:true*/


this.name = "nexus_warhead_basicPremiumOrUltimate";
this.author = "UK_Eliter";
this.description = "Script for Nexus missile warheads";
this.copyright = "2014 Creative Commons: attribution, non-commercial, sharealike.";
this.licence = "CC-NC-SA 3";

// Associated AI: nexus_warheadAI.PLIST


/*
--------------
DEBUG SWTICHES
--------------
*/

//this.logging = true; // THIS SHOULD BE COMMENTED OUT WHEN NOT TESTING
//this.debug = false;


/*
-------
GLOBALS
-------
*/

this.typeOfWarhead = 0; // This gets set to something meaningful below.


/*
------------------------
JSLINT: start of wrapper
------------------------
*/

(function() {
	"use strict";


	/*
	--------------
	EVENT HANDLERS
	--------------
	*/

	this.shipSpawned = function() {
		if (this.ship.primaryRole === "nexus_warhead") {
			this.typeOfWarhead = 1; // 1 = basic
		} else if (this.ship.primaryRole === "nexus-premium-warhead") {
			this.typeOfWarhead = 2; // 2 = premium;
		} else {
			this.typeOfWarhead = 3; // 3 = ultimate;
		}
		this.oldTarget = 0;
		delete this.shipSpawned;
	};

	this.shipTakingDamage = function(amount, whom, type) {
		//if (this.debug) {player.consoleMessage("Warhead AI - taking damage:" + amount, 5);}
		if (amount > 14) {
			return;
		}
		if (Math.random() < 0.2) {
			this.ship.energy = this.ship.energy + amount; // Prevent it from being destroyed - but also so that we can *detonate* it.
			this.$detonate();
		}
	};


	/*
	---------------
	OTHER FUNCTIONS
	---------------
	*/

	this.$detonateOrSeek = function() {
		if (this.ship.target && !this.ship.target.isValid) {
			this.$detonate();
			return;
		}
		this.ship.reactToAIMessage("SCRIPT_SEEK");
	};


	this.$scanForTargets = function() {
		//if (this.debug) {player.consoleMessage("Scanning for targets", 6);}
		function $isHostileToOwnerOrWarhead(e) {
			if (this.ship.ultimateOwner && this.ship.ultimateOwner.isValid) {
				return e.isShip && e.hasHostileTarget && (e.target == this.ship.ultimateOwner || e.target == this.ship);
			} else {
				return e.isShip && e.hasHostileTarget && (e.target == this.ship);
			}
		}
		var targetsArray = system.filteredEntities(this, $isHostileToOwnerOrWarhead, this.ship, this.ship.scannerRange);
		if (targetsArray.length > 0) {
			this.ship.target = targetsArray[0]; // go for nearest
			this.ship.reactToAIMessage("TARGET");
			this.ship.oldTarget = this.ship.target;
		} else if ((this.oldTarget !== 0) && this.oldTarget.isValid) {
			//if (this.debug) {player.consoleMessage("Nexus warhead - located first found target", 4);}
			this.ship.target = this.oldTarget;
			this.ship.reactToAIMessage("TARGET");
			this.oldTarget = 0; // reset it
		} else {
			this.ship.reactToAIMessage("NO_TARGET");
		}
	};

	this.$detonate = function() {
		// function dealEnergyDamage(damage : Number, idealRange : Number [, velocityBias : Number])
		// The standard Oolite missile uses dealEnergyDamage(170, 32.5, 0.25), has a maximum speed of 0.75LM, and its AI tries to detonate it 25m from its target. [NB: If target within ideal range, takes full damage.]
		//
		// 1 = basic; 2 = premium; 3 = ultimate.
		switch (this.typeOfWarhead) {
			case 1:
				this.ship.dealEnergyDamage(110, 27, 0.25);
				break;
			case 2:
				this.ship.dealEnergyDamage(150, 31, 0.22);
				break;
			case 3:
				this.ship.dealEnergyDamage(195, 36, 0.15);
		}
		this.ship.explode();
	};


	/*
	----------------------
	JSHINT: end of wrapper
	----------------------
	*/

}).call(this);

// EOF