/* nexus_missile_basicOrPremiumOrUltimate.js */

/*
------------------------
JSHINT: Options
------------------------
*/

/*jshint esversion: 6*/
/*jshint sub:true*/


this.name = "nexus_missile_basicOrPremiumOrUltimate";
this.author = "UK_Eliter";
this.description = "";
this.copyright = "2014 Creative Commons: attribution, non-commercial, sharealike.";
this.licence = "CC-NC-SA 3";


/*
------------------
DEBUGGING SWTICHES
------------------
*/

//this.logging = true; // THIS SHOULD BE COMMENTED OUT WHEN NOT TESTING


/*
-------
GLOBALS
-------
*/

this.debug = false;

this.typeOfNexusMissile = "undetermined";


/*
------------------------
JSHINT: start of wrapper
------------------------
*/

(function() {
	"use strict";


	/*
	====================
	MAIN CODE
	====================
	*/

	this.shipSpawned = function() {
		this.MissileEnergyThreshhold = this.ship.maxEnergy * 0.8;
		if (this.ship.hasRole("EQ_NEXUS_BASIC_MISSILE")) {
			this.typeOfNexusMissile = "basic";
		} else if (this.ship.hasRole("EQ_NEXUS_PREMIUM_MISSILE")) {
			this.typeOfNexusMissile = "premium";
		} else {
			this.typeOfNexusMissile = "ultimate";
		}
		delete this.shipSpawned;
	};

	this.shipTakingDamage = function(amount, whom, type) {
		if (this.ship.target) {
			if (whom == this.ship.target) {
				if (type === "scrape damage") {
					this.$detonate();
					return;
				}
			}
		}
		if (amount > 60 && Math.random() < 0.9) {
			return;
		}
		if (this.ship.energy > this.MissileEnergyThreshhold || Math.random() > 0.8) {
			return;
		}
		this.$spawnWarheads();
	};

	this.$isHostile = function(e) {
		// if (this.debug) {player.consoleMessage("Hostile scan from MISSILE script", 6);}
		return e.isShip && e.hasHostileTarget && (e.target == this.ship.owner);
	};


	this.$spawnWarheads = function() {
		// SPAWN THE WARHEADS & do related stuff *

		// Note: original missile will be removed by its AI
		if (!this.ship || !this.ship.owner || !this.ship.owner.isValid) {
			return;
		}	

		var numWarheads;
		var submunition;
		switch (this.typeOfNexusMissile) {
			case "basic":
				numWarheads = 3;
				submunition = "nexus_warhead";
				break;
			case "premium":
				numWarheads = 3;
				submunition = "nexus-premium-warhead";
				break;
			case "ultimate":
				numWarheads = 4;
				submunition = "nexus-ultimate-warhead";
		}

		// Actual spawn
		var warheads = this.ship.spawn(submunition, numWarheads); // this will set warheads targets to the missile's target
		var counter;
		// set the owner of the warhead to the original missile's owner. Can't set '.owner' because read-only.
		for (counter = 0; counter < numWarheads; counter++) {
			warheads[counter].ultimateOwner = this.ship.owner;
		}

		// ALLOCATE TARGETS etc TO THE WARHEADS *
		var targets = system.filteredEntities(this, this.$isHostile, this.ship.owner, this.ship.owner.scannerRange);
		var numTargets = targets.length;
		// NN: NOT 'if (numTargets < 2)' - i.e. abort if no target or one target - because could be one hostile AND missile's original target. We will investigate that below.
		if (numTargets < 1) {
			// if (this.debug) {player.consoleMessage("Missile script - No hostiles", 8);}
			this.ship.explode(); // Do need this here!
			return; // need do nothing else, because all the warheads will be set to what is, presently, their only possible target, = the original one. (If that target's been lost, the warhead AI will deal with that.)
		}
		// Create an array of possible targets, and a corresponding array that will record whether a potential target has yet been targeted
		var isTargetTargetted = new Array(numTargets);
		for (counter = 0; counter < numTargets; counter++) {
			isTargetTargetted[counter] = false;
		}
		var startWarheadCounterAt;
		if (this.ship.target && this.ship.target.isValid) {
			// if (this.debug) {player.consoleMessage("Warhead 0 target is"+warheads[0].target, 8);player.consoleMessage("Num targets is "+numTargets, 8);}
			// Now see if the target warheads inherited from the missile is *amongst the array of possible targets.* If it is (may not be, 'cos initial target may not be hostile) mark the ship as targetted. 
			for (counter = 0; counter < numTargets; counter++) {
				if (targets[counter] == warheads[0].target) {
					isTargetTargetted[counter] = true;
					break;
				}
			}
			startWarheadCounterAt = 1; // determine which warhead the targetting procedure should start with
		} else {
			startWarheadCounterAt = 0;
		}
		// Use the array of potential targets (hostiles) to assign targets to rest of the warheads (that 'rest' being either (1) all of them or (2) all but the first one)
		// if (this.debug) {player.consoleMessage("Script targetting starts with (could be 0): "+startWarheadCounterAt, 6);}
		var warheadCounter;
		for (warheadCounter = startWarheadCounterAt; warheadCounter < numWarheads; warheadCounter++) {
			for (counter = 0; counter < numTargets; counter++) {
				if (!isTargetTargetted[counter]) {
					warheads[warheadCounter].target = targets[counter];
					isTargetTargetted[counter] = true;
					// if (this.debug) {player.consoleMessage("Warhead "+ warheadCounter +" target: "+ targets[counter], 6);}
					break; // have given the warhead a target, so should stop trying to do that!
				}
			}
		}
		this.ship.explode();
	};

	this.$detonate = function() {
		// function dealEnergyDamage(damage : Number, idealRange : Number [, velocityBias : Number])
		// The standard Oolite missile uses dealEnergyDamage(170, 32.5, 0.25), has a maximum speed of 0.75LM, and its AI tries to detonate it 25m from its target. [NB: If target within ideal range, takes full damage.]
		switch (this.typeOfNexusMissile) {
			case "basic":
				this.ship.dealEnergyDamage(330, 50, 0.25);
				break;
			case "premium":
				this.ship.dealEnergyDamage(470, 70, 0.25);
				break;
			case "ultimate":
				this.ship.dealEnergyDamage(600, 90, 0.25);
		}
		this.ship.explode();
	};


	/*
	=======================
	JSHINT: end of wrapper
	=======================
	*/

}).call(this);

// EOF