"use strict";
this.name        = "EnhancedPassengerMFD";
this.author      = "phkb";
this.copyright   = "2018 phkb";
this.description = "Controls the output the MFD";
this.licence     = "CC BY-NC-SA 4.0";

this._lineLength = 14;
this._mfdID = -1;
this._offerTimeout = 180;		// number of seconds to wait for response (3 mins, to allow for player research time)
this._offerTimer = null;		// timer for mission offer
this._timeoutCounter = 0;
this._currentMFDText = "";
this._displayPoint = 0;
this._holdData = {};
this._subMessageTimer = null;
this._originalMsg = "";
this._final = false;
this._declineMessageTimer = null;
this._declineType = false;
this._acceptMessageTimer = null;
this._disableReplyOptions = false;

//-------------------------------------------------------------------------------------------------------------
this.shipWillEnterWitchspace = function(cause, destination) {
	if (this._offerTimer && this._offerTimer.isRunning) {
		this.$stopTimers();
		worldScripts.EnhancedPassengerContracts.$declinePendingChange();
		this.$removeBCReplyOptions();
	}
}

//-------------------------------------------------------------------------------------------------------------
this.shipWillDockWithStation = function(station) {
	if (this._simulator === true) return;
	if (this._offerTimer && this._offerTimer.isRunning) {
		// make sure we don't leave any half-accepted change hanging around
		this.$stopTimers();
		worldScripts.EnhancedPassengerContracts.$declinePendingChange();
		epc.$removeBCReplyOptions();
	}
}

//-------------------------------------------------------------------------------------------------------------
this.shipDied = function(whom, why) {
	this.$stopTimers();
}

//-------------------------------------------------------------------------------------------------------------
this.$stopTimers = function $stopTimers() {
	if (this._offerTimer && this._offerTimer.isRunning) {
		this._offerTimer.stop();
		this._offerTimer = null;
	}
	if (this._subMessageTimer && this._subMessageTimer.isRunning) {
		this._subMessageTimer.stop();
		this._subMessageTimer = null;
	}
	if (this._declineMessageTimer && this._declineMessageTimer.isRunning) {
		this._declineMessageTimer.stop();
		this._declineMessageTimer = null;
	}
	if (this._acceptMessageTimer && this._acceptMessageTimer.isRunning) {
		this._acceptMessageTimer.stop();
		this._acceptMessageTimer = null;
	}
	this._declineType = false;
}

//-------------------------------------------------------------------------------------------------------------
// breaks text up into appropriate lengths for an MFD
this.$processText = function $processText(msg) {
	var line = "";
	// the replace here should ensure all newline commands are at the end of a word, and not in the middle of one
	var words = msg.replace(new RegExp("\n", 'g'), "\n ").split(" ");
	var word = "";
	var output = "";

	for (var i = 0; i < words.length; i++) {
		word = words[i].trim();
		// make sure we have a word to add before trying to add it
		if (word !== "") {
			if (defaultFont.measureString(line + " " + word) <= this._lineLength) {
				line += (line === "" ? "" : " ") + word;
				// if the word ended in a newline command, add the line to the output and reset
				if (word.indexOf("\n", word.length - 2) !== -1) {
					output += line;
					line = "";
				}
			} else {
				output += line + "\n";
				line = word;
				// if the word ended in a newline command, add the line to the output and reset
				if (word.indexOf("\n", word.length - 2) !== -1) {
					output += line;
					line = "";
				}
			}
		}
	}
	output += line;
	
	// update MFD so that new text goes on the bottom.
	var lines = this._currentMFDText.split("\n");
	if (this._currentMFDText === "") lines = [];
	var newlines = output.split("\n");
	
	for (var i = 0; i < newlines.length; i++) {
		lines.push(newlines[i]);
	}
	
	var final = "";
	if (lines.length <= 10) {
		final = lines.join("\n");
	} else {
		for (var i = lines.length - 10; i < lines.length; i++) {
			final += (final === "" ? "" : "\n") + lines[i];
		}
	}
	
	this._currentMFDText = final;
	
	return final;
}

//-------------------------------------------------------------------------------------------------------------
// updates the text of the MFD
this.$updateMFD = function $updateMFD(msg) {
	var p = player.ship;

	if (this._originalMsg === "") this._originalMsg = msg;
	
	var msglist = msg.split("\n");
	var currmsg = msglist[this._displayPoint];
	// if this is the final message, just select the last one
	if (this._final === true) {
		currmsg = msglist[msglist.length - 1];
	}
	
	// if the hud is hidden don't try an update - it will get confusing as to which mfd slot is open or not.
	if (p.hudHidden === false) {
        // find the slot currently set for this MFD
        this.$findMFDID();
        // if we haven't got a set slot (this._mfdID === -1) or the set slot we had is now unavailable...
        if (this._mfdID === -1 ||
            (p.multiFunctionDisplayList[this._mfdID] && p.multiFunctionDisplayList[this._mfdID] !== "" && p.multiFunctionDisplayList[this._mfdID] !== this.name)) {
            // find a free slot
            // first, make sure we reset our slot id marker (in the case where the previous one is in use)
            this._mfdID = -1;
            // search for a free slot
            for (var i = 0; i < p.multiFunctionDisplayList.length; i++) {
                if (!p.multiFunctionDisplayList[i] || p.multiFunctionDisplayList[i] === "") {
                    this._mfdID = i;
                    break;
                }
            }
        }
		
		// we have a free slot, so force the mfd to display
		if (this._mfdID !== -1) {
			// set the text in the MFD
			var output = this.$processText(currmsg);
			p.setMultiFunctionText(this.name, output, false);

			p.setMultiFunctionDisplay(this._mfdID, this.name);
		} else {
			if (useComms === true && src && src.isInSpace && player.ship.position.distanceTo(src) < player.ship.scannerRange) {
				// yay! comms is working!
				src.commsMessage(currmsg, p);
			} else {
				// oh well, make it a console message
				player.consoleMessage(currmsg, 20);
			}
		}
	}
	
	if (this._final === false) {
		this._displayPoint += 1;
		if (this._displayPoint < msglist.length) {
			this._holdData.msg = msg;
			this._subMessageTimer = new Timer(this, this.$processNextMessage, 5, 0);
			// return at this point so the accept/reject items only appear when all the messages are displayed.
			return;
		}
	}

	this._holdData = {};
	if (this._disableReplyOptions === false) this.$displayBCReplyOptions();
}

//-------------------------------------------------------------------------------------------------------------
// re-run the update function so the next message in the list can be displayed
this.$processNextMessage = function $processNextMessage() {
	this.$updateMFD(this._holdData.msg);
}

//-------------------------------------------------------------------------------------------------------------
// records the index of the MFD that currently holds the damage report mfd
this.$findMFDID = function $findMFDID() {
	var p = player.ship;
	for (var i = 0; i < p.multiFunctionDisplayList.length; i++) {
		if (p.multiFunctionDisplayList[i] === this.name) this._mfdID = i;
	}
}

//-------------------------------------------------------------------------------------------------------------
// hides all instances of the damage report MFD
this.$autoHideMFD = function $autoHideMFD() {
	var p = player.ship;
	if (p && p.multiFunctionDisplayList) {
		for (var i = 0; i < p.multiFunctionDisplayList.length; i++) {
			if (p.multiFunctionDisplayList[i] === this.name) {
				p.setMultiFunctionDisplay(i, "");
			}
		}
	}
}

//-------------------------------------------------------------------------------------------------------------
// add the secondary mission accept/decline options to broadcast comms
this.$displayBCReplyOptions = function $displayBCReplyOptions() {
	var bc = worldScripts.BroadcastCommsMFD;
	if (bc.$checkMessageExists("epc_accept_change") === true || bc.$checkMessageExists("epc_decline_change") === true) return;
	bc.$createMessage({messageName:"epc_accept_change", callbackFunction:this.$acceptContractChange.bind(this), displayText:"(* Accept Contract Change *)", messageText:"", transmissionType:"broadcast", deleteOnTransmit:true, delayCallback:1});
	bc.$createMessage({messageName:"epc_decline_change", callbackFunction:this.$declineContractChange.bind(this), displayText:"(* Decline Contract Change *)", messageText:"", transmissionType:"broadcast", deleteOnTransmit:true, delayCallback:1});
	// reset the timer counter
	this._timeoutCounter = 0;
	// start a timer to wait for player response
	this._offerTimer = new Timer(this, this.$removeOffer, 1, 1);
}

//-------------------------------------------------------------------------------------------------------------
this.$acceptContractChange = function $acceptContractChange() {
    player.consoleMessage("Contract change accepted");
    if (this._mfdID !== -1) {
        this.$updateMFD(this._originalMsg + "\n>> " + expandDescription("[epc_accept-change]"));
    }
	worldScripts.EnhancedPassengerContracts.$acceptPendingChange();
	this.$removeBCReplyOptions();
	this._acceptMessageTimer = new Timer(this, this.$sendAcceptComms, 5, 0);
}

//-------------------------------------------------------------------------------------------------------------
this.$sendAcceptComms = function $sendAcceptComms() {
    if (this._mfdID !== -1) {
        this._final = true;
        this._disableReplyOptions = true;
        this.$updateMFD(this._originalMsg + "\n" + expandDescription("[epc_accept-response]"));
    }
	// turn off the MFD (if it was used)
	this.$turnOffMFD();
}

//-------------------------------------------------------------------------------------------------------------
this.$declineContractChange = function $declineContractChange(send_message) {
    this._declineType = false;
    if (send_message == null) {
        this._declineType = true;
        player.consoleMessage("Contract change declined");
        if (this._mfdID !== -1) {
            this.$updateMFD(this._originalMsg + "\n>> " + expandDescription("[epc_decline-change]"));
        }
    }
	this.$removeBCReplyOptions();
	this._declineMessageTimer = new Timer(this, this.$sendDeclineComms, 5, 0);
}

//-------------------------------------------------------------------------------------------------------------
this.$sendDeclineComms = function $sendDeclineComms() {
    if (this._declineType === true) {
        if (this._mfdID !== -1) {
            this._final = true;
			this._disableReplyOptions = true;
            this.$updateMFD(this._originalMsg + "\n" + expandDescription("[epc_decline-response]"));
        }
    }
	worldScripts.EnhancedPassengerContracts.$declinePendingChange();
	// turn off the MFD (if it was used)
	this.$turnOffMFD();
}

//-------------------------------------------------------------------------------------------------------------
this.$turnOffMFD = function $turnOffMFD() {
	// turn off the MFD (if it was used)
	this._currentMFDText = "";
	this._originalMsg = "";
	this._final = false;
	this._displayPoint = 0;
	if (this._mfdID !== -1) {
		if (this._subMessageTimer && this._subMessageTimer.isRunning) this._subMessageTimer.stop();
		this._subMessageTimer = new Timer(this, this.$autoHideMFD, 3, 0);
	}
	this._disableReplyOptions = false;
}

//-------------------------------------------------------------------------------------------------------------
this.$removeBCReplyOptions = function $removeBCReplyOptions() {
	if (this._offerTimer && this._offerTimer.isRunning) {
		this._offerTimer.stop();
		this._offerTimer = null;
	}
	var bc = worldScripts.BroadcastCommsMFD;
	if (bc.$checkMessageExists("epc_accept_change") === true) bc.$removeMessage("epc_accept_change");
	if (bc.$checkMessageExists("epc_decline_change") === true) bc.$removeMessage("epc_decline_change");
}

//-------------------------------------------------------------------------------------------------------------
this.$removeOffer = function $removeOffer() {
	this._timeoutCounter += 1;
	// have we timed out
	if (this._timeoutCounter >= this._offerTimeout) {
		this.$declineContractChange(true);
		return;
	}
}

