"use strict";
this.name           = "erehwonCamera";
this.author         = "Eric Walch";
this.copyright		= "2010 Eric Walch";
this.description	= "Ship photocamera equipment activation script. Based on example code by another_commander";
this.licence		= "CC-by-NC-SA 3.0";

this.activated = function() {
	var self = this.ship;
    var target = self.target;
    var photoName = "wasted_photo_nr_" + (11 - missionVariables.erehwonPictureCount);
    var station = system.shipsWithPrimaryRole("erehwonStation");
    if (station) target = station[0];

	player.consoleMessage(expandMissionText("tr_photo_shot"));

	if (target && target.dataKey == "ErehwonStation") {
        var range = target.position.distanceTo(self.position) - target.collisionRadius;
        var minDistance = target.collisionRadius * 3; // screen filling
        var maxDistance = target.collisionRadius * 10; // 1/5 of screen filling
        var inRange =  (range < maxDistance && range > minDistance);
        var deviation; // deviation in meter.

        switch (self.viewDirection) {
            case "VIEW_FORWARD": deviation = self.vectorForward.angleTo(target.position.subtract(self.position)) * range; break;
            case "VIEW_AFT": deviation = self.vectorForward.angleTo(self.position.subtract(target.position)) * range;break;
            case "VIEW_PORT": deviation = self.vectorRight.angleTo(self.position.subtract(target.position)) * range;break;
            case "VIEW_STARBOARD": deviation = self.vectorRight.angleTo(target.position.subtract(self.position)) * range;break;
            default : deviation = 2 * target.collisionRadius; // can't target when not viewing from inside ship.
        }

        var centered = (deviation < target.collisionRadius);
        if (inRange && centered) {
            missionVariables.erehwonFotoShot = "YES";
            player.consoleMessage(expandMissionText("tr_good_shot"));
            photoName = "Erehwon_station";
            if (missionVariables.erehwonGotStory == "YES") {
                if (missionVariables.erehwonReconnaissance != "SUCCESS") {
                    worldScripts["Tionisla Reporter"].$unmarkSystem(144);
                    worldScripts["Tionisla Reporter"].$markSystem(124);
                }
                missionVariables.erehwonReconnaissance = "SUCCESS";
                mission.setInstructionsKey("erehwonReconnaissance_missioninfo2", "Tionisla Reporter");
            }
        }
        else {
            if (!inRange) {
                if (range >= maxDistance)
					player.consoleMessage(expandMissionText("tr_useless_far"))
                else
					player.consoleMessage(expandMissionText("tr_useless_close"));
            }
            else {
                player.consoleMessage(expandMissionText("tr_unless_unaligned"));
            }
        }

	}
    if (global.takeSnapShot != undefined) takeSnapShot(photoName); // This function will only work in testversions, never in an official release.
    if (--missionVariables.erehwonPictureCount < 1) {
        self.removeEquipment("EQ_EREHWON_PHOTOCAMERA");
        player.consoleMessage(expandMissionText("tr_empty"));
    }
}
