"use strict";
this.name        = "ErehwonStation";
this.author      = "eric walch";
this.copyright   = "2008 Eric Walch";
this.description = "station at Erehwon Planet. About 3 LY west of Biorle in galaxy 1";
this.licence     = "CC-by-NC-SA 3.0";

// Just add a default buoy. Advanced compass itself is not working in interstellar space
this.shipSpawned = function () {
    var planet = system.planets[0];
    if (planet) {
        var targetVector = planet.position.subtract(this.ship.position).direction();
        this.ship.orientation = targetVector.rotationTo(new Vector3D(0,0,1));
        system.addShips("erehwon-buoy", 1, this.ship.position.add(this.ship.heading.multiply(10E3)), 1);
    }
	if (worldScripts.StationDockControl) {
		worldScripts.StationDockControl._trafficNone.push("ErehwonStation");
		worldScripts.StationDockControl._shuttleTrafficNone.push("ErehwonStation");
	}
    delete this.shipSpawned;
}

this.stationLaunchedShip = function (ship) {
    if (ship && ship.AI == "route2sunskimAI.plist") {
        // no sunskimming possible from this station.
        ship.fuel = 7;
        ship.switchAI("exitingTraderAI.plist");
    }
}

this.shipDied = function(whom, why) {
    missionVariables.erehwonDestroyed = true;
}
