"use strict";
this.name = "Deep_Horizon_Adv_Nav_Comp_Equipment";
this.authors	= "Cmd. Cheyd (Blake Deakins) and PhantorGorth (Paul Cooper)";
this.contributors = "Svengali";
this.description = "Adds a prime-able piece of equipment that improves interstellar navigation in the form of fuel savings.";
this.version = "1.0.0";
this.copyright = " Creative Commons Attribution-Noncommercial-ShareAlike 3.0 Unported license (Modified)";

//*************************************************************************************************************
//************************************           Event Functions           ************************************
//*************************************************************************************************************

this.activated = function () {
	// If there is already a coutdown running
	if (player.ship.status == "STATUS_WITCHSPACE_COUNTDOWN") {
		// Was the countdown triggered by DH-ANC?
		if (worldScripts["Deep_Horizon_Adv_Nav_Comp"].usedANC == true) {
			// Yes - Cancel the ANC countdown with notice and end processing.
			worldScripts["Deep_Horizon_Adv_Nav_Comp"]._cancelANC(false);
			return;
		} else {
			// No - use the ANC cancellation function to kill the countdown silently.
			worldScripts["Deep_Horizon_Adv_Nav_Comp"]._cancelANC(true);
			player.consoleMessage("Prior hyperspace initiation cancelled by Adv. Nav Computer calcuations.", 4);
		}
	}
	// No countdown previously running - Set flag that ANC is being used and activate the equipment via the world script
	worldScripts["Deep_Horizon_Adv_Nav_Comp"].usedANC = true;
	worldScripts["Deep_Horizon_Adv_Nav_Comp"]._ancActivated();
}

this.equipmentDestroyed = this.equipmentDamanged = function (equipment) {
	// Let the world script handle.
	worldScripts["Deep_Horizon_Adv_Nav_Comp"]._ancDamaged();
}


