"use strict";
this.name = "AnacondaCruiseLiners";
this.author = "phkb";
this.copyright = "Creative Commons Attribution - Non-Commercial - Share Alike 4.0 license.";
this.description = "Populator for Anaconda cruise liners";

this._safeClusters = [
    // galaxy 1 (index 0)
    [
        8, 51, 114, 215, 218, 246,
        16, 28, 80, 161, 83, 179, 57, 242, 240, 243,
        19, 193, 239,
        45, 144, 48, 168, 250, 58, 111, 186, 188,
        87, 136,
        97, 151,
        118, 119, 176, 208, 122, 205
    ],
    // galaxy 2 (index 1)
    [
        7, 104, 120, 194, 168,
        19, 33, 97, 102, 113, 40, 178, 15, 167, 209, 226, 242, 72, 183, 216, 87,
        23, 54, 82,
        49, 67, 199, 147, 215, 231,
        56, 161,
        145, 184
    ],
    // galaxy 3 (index 2)
    [
        5, 150, 26, 177, 175,
        10, 70, 47, 53, 68, 181, 202, 164, 111, 81, 37, 85, 225,
        15, 193, 225, 214, 148, 117, 95, 245, 250,
        38, 79, 154, 182, 122,
        49, 234,
        52, 145, 223,
        54, 165, 129,
        84, 86,
        134, 207, 244,
    ],
    // galaxy 4 (index 3)
    [
        37, 53, 74, 237, 82, 117, 181, 125, 234, 245,
        170, 229
    ],
    // galaxy 5 (index 4)
    [
        7, 70, 161, 173, 205,
        13, 116, 244, 248, 65, 146, 153, 203, 188, 252,
        30, 39,
        24, 35, 28, 102, 180,
        30, 89, 109,
        38, 82, 97,
        103, 184, 220, 193, 225
    ],
    // galaxy 6 (index 5)
    [
        16, 53, 102,
        18, 38, 122,
        26, 80, 239, 247,
        40, 79, 50, 81, 163, 45, 154, 198, 204, 183, 99, 85, 176, 195, 213, 237, 232,
        49, 145,
        67, 209,
        82, 178,
        87, 168,
        108, 143,
        113, 134
    ],
    // galaxy 7 (index 6)
    [
        2, 24, 34, 54,
        7, 56, 198, 209,
        17, 178,
        21, 184, 162, 149, 152, 242,
        23, 177,
        37, 193, 247, 150, 72,
        49, 117,
        66, 103, 119, 197,
        73, 184,
        81, 102, 135, 88, 225, 231
    ],
    // galaxy 8 (index 7)
    [
        7, 73, 110, 104, 39, 41, 125, 168, 233, 241, 201,
        14, 83, 188, 60, 71, 155, 206, 209, 218, 17, 199, 221,
        20, 84, 98,
        40, 59, 105, 169, 232,
        46, 243, 92,
        49, 148, 52, 180, 212, 238,
        72, 231,
        78, 220,
        103, 136, 187
    ],
];

this._spacelanes = [
    [
        141, 250, 111, 186, 50, 73, 35, 188, 250,
        7, 129, 227, 73, 89, 222, 29, 93, 42, 131,
        131, 62, 150, 198, 36, 28, 16, 221, 99,
        99, 241, 86, 126, 18, 246
    ],
    [
        82, 23, 188, 23, 54, 74, 122, 57, 115, 178, 45,
        45, 144, 189, 140, 65, 48, 204, 193, 221, 236, 66, 58, 88, 127,
        127, 109, 42, 114, 202,
        127, 207, 136, 6, 24, 53, 78, 48,
        205, 59, 100, 9, 156, 92, 61, 41, 179, 189,
        113, 115, 57, 94, 29
    ],
    [
        38, 182, 246, 91, 22, 140, 5, 56, 177, 150, 26, 75, 144, 209, 17, 218,
        50, 65, 79, 154, 38, 139, 189, 135, 42,
        205, 241, 101, 132, 6, 180, 164, 70, 10, 85, 81, 225, 81, 85, 10, 70, 202, 53,
        140, 58, 152, 76, 77, 97, 168,
        106, 250, 245, 160, 245, 22,
        118, 161, 54, 165, 129, 186
    ],
    [
        116, 230, 167, 48, 210, 36, 150, 84, 240, 193, 223, 118, 197, 135, 85, 154, 213, 162, 166, 213,
        16, 42, 172, 40, 80, 65, 144, 105, 119, 208, 189, 1, 174, 146, 100, 233,
        50, 239, 103, 108, 103, 177, 17, 177, 103, 45, 105, 137, 95, 54, 77, 76, 21, 2, 249, 113, 141, 113, 97,
        209, 33, 62, 25, 134, 58, 138, 191, 78, 57, 242, 234, 245, 181, 82, 117, 53, 74, 38,
        71, 79, 68, 110, 220, 158, 215, 63, 44, 66, 146, 174, 1, 4, 121, 145, 142, 6, 142, 11, 7, 161, 140,
        7, 32, 232, 216, 60
    ],
    [
        41, 216, 112, 230, 28, 102, 181, 35, 180, 24, 19, 156, 1, 45, 79, 172, 169,
        140, 137, 173, 70, 7, 253, 243, 135, 193, 225, 184, 150, 115, 201, 189, 227, 226, 221, 57, 202, 135, 202, 57, 221, 226, 227, 189, 115, 11, 54, 158, 175, 85, 178, 204, 12, 215, 212, 158,
        194, 8, 210, 41, 222, 183, 254, 149, 130, 108, 82, 92, 29, 121, 34, 183,
        114, 118, 2, 116, 244, 248, 65, 146, 153, 10, 99, 91, 200, 244,
        120, 9, 233, 104, 136, 129, 139, 163, 61,
        249, 16, 20, 39, 93, 207, 131, 74, 182, 252, 188, 40, 146, 153, 146, 40, 188, 252, 182, 166, 53, 221, 220, 225,
        30, 89, 87, 89, 152, 170, 88, 194, 77, 246, 106, 190, 208, 167
    ],
    [
        84, 3, 8, 88, 206, 136, 144, 13, 92, 99, 85, 133, 40, 215, 115, 83, 246, 39, 35, 114,
        169, 51, 80, 103, 243, 98, 102, 16, 109, 101, 67, 142, 60, 209, 233, 112, 225, 131, 210, 12, 150, 91,
        104, 54, 162, 148, 211, 6, 181, 17, 108, 28,
        156, 113, 14, 216, 82, 177, 116, 154, 120, 50, 232, 124, 215,
        10, 77, 159, 226, 31, 203, 30, 234, 240, 234, 140, 159
    ],
    [
        103, 58, 253, 65, 39, 44, 236, 150, 247, 193, 179, 133, 215, 95, 109,
        194, 73, 146, 239, 86, 74, 199, 23, 138, 18, 234, 244, 166, 152, 162, 242, 184,
        218, 130, 125, 205, 79, 191, 17, 178,
        211, 7, 163, 67, 209, 250, 19, 239,
        46, 36, 212, 187, 53, 107, 174
    ],
    [
        114, 12, 241, 39, 23, 38, 123, 130, 167, 63, 136, 8, 44, 91, 56, 62, 186, 93, 32, 61, 244, 243, 116, 46, 157, 230, 151, 213, 198, 148, 49, 76, 203, 255, 161, 98, 53, 1, 145, 33,
        215, 2, 211, 9, 13, 147, 216, 225, 21, 218, 71, 206, 236, 190, 18, 26, 152, 51, 209, 24, 174, 82, 179, 173, 30, 251, 233, 125, 45, 41, 104, 110, 73, 135, 117, 55,
        126, 6, 81, 65, 169, 232, 252,
        75, 219, 248, 117,
        10, 72, 219, 248, 117
    ]
];

this._data = [];
this._selectedDataSet = expandMissionText("acl_safesystems");
this._aclSelection = 2;
this._spawnChance = 0.3;
this._repopChance = 0.03;
this._debug = false;

this._dataSets = [
    { name: expandMissionText("acl_allsystems"), data: [[], [], [], [], [], [], [], []] },
    { name: expandMissionText("acl_safesystems"), data: this._safeClusters },
    { name: expandMissionText("acl_spacelanes"), data: this._spacelanes }
];

this._aclConfig = {
    Name: this.name,
    Display: expandMissionText("acl_config_display"),
    Alias: expandMissionText("acl_config_alias"),
    Alive: "_aclConfig",
    Notify: "$update",
    Bool: {
        B0: { Name: "_debug", Def: false, Desc: expandMissionText("acl_config_debug") },
        Info: expandMissionText("acl_config_bool_info")
    },
    SInt: {
        S0: { Name: "_spawnChance", Def: 0.3, Min: 0, Max: 1, Float: true, Desc: expandMissionText("acl_config_spawn") },
        S1: { Name: "_repopChance", Def: 0.03, Min: 0, Max: 1, Float: true, Desc: expandMissionText("acl_config_repop") },
        Info: expandMissionText("acl_config_sint_info")
    },
    EInt: {
        E0: {
            Name: "_aclSelection",
            Def: 2,
            Min: 1,
            Max: 4,
            OneOf: true,
            Desc: [expandMissionText("acl_allsystems"), expandMissionText("acl_safesystems"), expandMissionText("acl_spacelanes")]
        },
        Info: expandMissionText("acl_config_eint_info")
    },
};

//-------------------------------------------------------------------------------------------------------------
this.startUp = function () {
    if (missionVariables.AnacondaCruises_DataSet) {
        this._selectedDataSet = missionVariables.AnacondaCruises_DataSet;
    }
    if (missionVariables.AnacondaCruises_SpawnChance) {
        this._spawnChance = parseFloat(missionVariables.AnacondaCruises_SpawnChance);
        this._spawnChance = parseInt(this._spawnChance * 100) / 100;
    }
    if (missionVariables.AnacondaCruises_RepopChance) {
        this._repopChance = parseFloat(missionVariables.AnacondaCruises_RepopChance);
        this._repopChance = parseInt(this._repopChance * 100) / 100;
    }
    this.$loadSelectedDataSet();
}

//-------------------------------------------------------------------------------------------------------------
this.systemWillPopulate = function () {
    // chance of spawning is less likely in more dangerous systems
    if (this.$checkSystem() == false || Math.random() < ((1 - this._spawnChance) + (7 - system.government) / 28)) return;
    system.setPopulator("anacondaLiners", {
        location: "COORDINATES",
        coordinates: Vector3D(0, 0, (Math.random() * 0.7) + 0.2).fromCoordinateSystem("pwu"),
        callback: function (pos) {
            var ws = worldScripts.AnacondaCruiseLiners;
            var acl = system.addShips("anaconda_cruiseliner", 1, pos, system.mainPlanet.radius * 0.5);
            if (ws._debug) {
                if (!acl || acl.length == 0) {
                    log("anaconda_cruiseliners_populator", expandMissionText("acl_log_none_spawned"));
                } else {
                    log("anaconda_cruiseliners_populator", expandMissionText("acl_log_spawned", {datakey: acl[0].dataKey}));
                    acl[0].reportAIMessages = true;
                }
            }
        }
    });
}

//-------------------------------------------------------------------------------------------------------------
this.systemWillRepopulate = function () {
    if (this.$checkSystem() == false) return;
    if (system.countShipsWithRole("anaconda_cruiseliner") > 0) return;
    if (Math.random() > ((1 - this._repopChance) + (7 - system.government) / 350)) {
        // decide what type of repop we're going to do: station launch or wp arrival
        if (Math.random() > 0.5) {
            // sometimes launch a cruise liner from the main station
            if (this._debug) log(this.name, expandMissionText("acl_log_launch_mainstation"));
            var acl = system.mainStation.launchShipWithRole("anaconda_cruiseliner");
            this._updateTimer = new Timer(this, this.$updateShipAI, 5, 2);
        } else {
            // sometimes spawn a cruise liner at the wp
            if (this._debug) log(this.name, expandMissionText("acl_log_spawn_witchpoint"));
            var acl = system.addShips("anaconda_cruiseliner", 1);
            if (acl && acl.length > 0) {
                if (this._debug) acl[0].reportAIMessages = true;
            }
        }
    }
}

//-------------------------------------------------------------------------------------------------------------
this.startUpComplete = function () {
    // register our settings, if Lib_Config is present
    if (worldScripts.Lib_Config) {
        worldScripts.Lib_Config._registerSet(this._aclConfig);
    }
}

//-------------------------------------------------------------------------------------------------------------
this.playerWillSaveGame = function () {
    missionVariables.AnacondaCruises_DataSet = this._selectedDataSet;
    missionVariables.AnacondaCruises_SpawnChance = this._spawnChance;
    missionVariables.AnacondaCruises_RepopChance = this._repopChance;

}

//-------------------------------------------------------------------------------------------------------------
this.shipWillEnterWitchspace = this.shipDied = function () {
    if (this._updateTimer && this._updateTimer.isRunning) this._updateTimer.stop();
}

//-------------------------------------------------------------------------------------------------------------
this.$loadSelectedDataSet = function () {
    for (var i = 0; i < this._dataSets.length; i++) {
        if (this._dataSets[i].name == this._selectedDataSet) {
            this._data = this._dataSets[i].data;
        }
    }
}

//-------------------------------------------------------------------------------------------------------------
this.$checkSystem = function () {
    // only corp states
    if (system.government < 5) return false;
    // check we have a valid data array to check
    if (!this._data || !Array.isArray(this._data) || this._data.length < galaxyNumber + 1) return false;
    return (this._selectedDataSet == expandMissionText("acl_allsystems") || this._data[galaxyNumber].indexOf(system.ID) >= 0);
}

//-------------------------------------------------------------------------------------------------------------
this.$addDataSet = function (dataSetName, dataSetData) {
    var found = false;
    for (var i = 0; i < this._dataSets.length; i++) {
        if (this._dataSets[i].name == dataSetName) {
            found = true;
            this._dataSets[i].data = dataSetData;
        }
    }
    if (!found) {
        this._dataSets.push({ name: dataSetName, data: dataSetData })
    }
    this.$updateBitwiseValues();
    this.$updateACLConfig();
    this.$loadSelectedDataSet();
}

//-------------------------------------------------------------------------------------------------------------
this.$update = function () {
    var bitVals = [1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048];
    var index = bitVals.indexOf(this._aclSelection);
    this._selectedDataSet = this._dataSets[index].name;
    this._spawnChance = parseInt(this._spawnChance * 100) / 100;
    this._repopChance = parseInt(this._repopChance * 100) / 100;
    this.$loadSelectedDataSet();
}

//-------------------------------------------------------------------------------------------------------------
this.$updateBitwiseValues = function () {
    var curVal = 1;
    for (var i = 0; i < this._dataSets.length; i++) {
        if (this._dataSets[i].name == this._selectedDataSet) this._aclSelection = curVal;
        curVal *= 2;
    }
}

//-------------------------------------------------------------------------------------------------------------
this.$updateACLConfig = function () {
    var bitVals = [1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048];
    var desc = [];
    for (var i = 0; i < this._dataSets.length; i++) {
        desc.push(this._dataSets[i].name);
    }
    this._aclConfig.EInt.E0.Max = bitVals[this._dataSets.length - 1];
    this._aclConfig.EInt.E0.Desc = desc;
}

//-------------------------------------------------------------------------------------------------------------
this.$updateShipAI = function $updateShipAI() {
    var acl = system.shipsWithRole("anaconda_cruiseliner");
    if (acl && acl.length > 0) {
        for (var i = 0; i < acl.length; i++) {
            acl[i].switchAI("anacondaCruiseLinerExitAI.plist");
            if (worldScripts.AnacondaCruiseLiners._debug) acl[i].reportAIMessages = true;
        }
        this._updateTimer.stop();
    }
}