"use strict";
this.name        = "CompressedF7Layout";
this.author      = "phkb";
this.copyright   = "2017 phkb";
this.description = "Moves all standard F7 data to the top of the screen, leaving no blank lines between data elements, including details from 'Distant Suns' and 'Explorers Club', if installed.";
this.licence     = "CC BY-NC-SA 4.0";

//-------------------------------------------------------------------------------------------------------------
this.startUpComplete = function() {

	var sd = worldScripts["oolite-system-data-config"];
    sd.setSystemDataLine(1, "[sysdata-eco]\t[economy_desc]", "system");
    sd.setSystemDataLine(2, "[sysdata-govt]\t[government_desc]", "system");
    sd.setSystemDataLine(3, "[sysdata-tl]\t[sysdata-tl-value]", "system");
    sd.setSystemDataLine(4, "[sysdata-pop]\t[sysdata-pop-value]", "system");
    sd.setSystemDataLine(5, "\t([inhabitants])", "system");
    sd.setSystemDataLine(6, "[sysdata-prod]\t\t[sysdata-prod-value]", "system");
    sd.setSystemDataLine(7, "[sysdata-radius]\t\t[sysdata-radius-value]", "system");
    sd.setSystemDataLine(8, "[sysdata-distance]\t[distanceInfo]", "system");
    sd.resetSystemDataLine(9);
    sd.resetSystemDataLine(10);
    sd.resetSystemDataLine(11);
    sd.resetSystemDataLine(12);
    sd.resetSystemDataLine(13);
    sd.resetSystemDataLine(14);
    sd.resetSystemDataLine(15);
    sd.resetSystemDataLine(16);

	if (worldScripts.Stars) {
		// we're overriding distant Sun's guiScreenChanged so it doesn't add text to the bottom part of the F7 screen
		worldScripts.Stars.$overrideGUI = worldScripts.Stars.guiScreenChanged;
		delete worldScripts.Stars.guiScreenChanged;
		// instead, we'll add a callback to do the update
		sd.addChangeCallback(this.name, "$stars_updateData");
	}
	if (worldScripts["Explorers Club"]) {
		// we're overriding EC's guiScreenChanged so we can capture and ignore any change to GUI_SCREEN_SYSTEM_DATA
		worldScripts["Explorers Club"].$ovr_guiScreenChanged = worldScripts["Explorers Club"].guiScreenChanged;
		delete worldScripts["Explorers Club"].guiScreenChanged;
		// we'll also add a callback to do the update
		sd.addChangeCallback(this.name, "$explorersClub_updateData");
	}
}

//-------------------------------------------------------------------------------------------------------------
this.guiScreenChanged = function(to, from) {
	// for anything other than GUI_SCREEN_SYSTEM_DATA fire EC's original guiScreenChanged event
	if (guiScreen !== "GUI_SCREEN_SYSTEM_DATA" && worldScripts["Explorers Club"]) worldScripts["Explorers Club"].$ovr_guiScreenChanged(to, from);
}

//-------------------------------------------------------------------------------------------------------------
this.$explorersClub_updateData = function(ctype, to, from) {
	var ec = worldScripts["Explorers Club"];
	var sd = worldScripts["oolite-system-data-config"];
	// find the first free slot (or the one we're currently using)
	for (var i = 1; i <= 16; i++) {
		if (sd.systemDataLineOwner(i) === "" || sd.systemDataLineOwner(i) === "explorers_club") {
			// found it! now work out what system we're looking at
			var sysID = -1;
			if (ctype === "guiScreenWillChange") {
				// for this event, we need to check out the infoSystem or targetSystem of the player ship
				var sysID = player.ship.targetSystem;
				if (player.ship.hasOwnProperty("infoSystem")) sysID = player.ship.infoSystem;
			} else {
				// for an infoSystemWillChange, the "to" property has the value we need
				sysID = to;
			}
			// make sure we have a valid system ID
			if (isNaN(sysID) === false && sysID >=0 && sysID <= 255) {
				// extract the correct text from missionText
				var text = "";
				if (ec.$xc_record[galaxyNumber].indexOf(sysID) === -1) {
					text = expandMissionText("explorers_club_never_visited");
				} else if (player.ship.targetSystem === system.ID) {
					text = expandMissionText("explorers_club_here_now");
				} else {
					text = expandMissionText("explorers_club_already_visited");
				}
				// and update the data line
				sd.setSystemDataLine(i, text, "explorers_club");
			} else {
				// if we have an invalid system ID, reset the line
				if (sd.systemDataLineOwner(i) === "explorers_club") sd.resetSystemDataLine(i);
			}
			break;
		}
	}
}

//-------------------------------------------------------------------------------------------------------------
this.$stars_updateData = function(ctype, to, from) {
	var sd = worldScripts["oolite-system-data-config"];
	// find the first free slot (or the one we're currently using)
	for (var i = 1; i <= 16; i++) {
		if (sd.systemDataLineOwner(i) === "" || sd.systemDataLineOwner(i) === "stars") {
			// found it! now work out what system we're looking at
			var sysID = -1;
			if (ctype === "guiScreenWillChange") {
				// for this event, we need to check out the infoSystem or targetSystem of the player ship
				var sysID = player.ship.targetSystem;
				if (player.ship.hasOwnProperty("infoSystem")) sysID = player.ship.infoSystem;
			} else {
				// for an infoSystemWillChange, the "to" property has the value we need
				sysID = to;
			}
			// make sure we have a valid system ID
			if (isNaN(sysID) === false && sysID >=0 && sysID <= 255) {
				// and update the data line
				sd.setSystemDataLine(i, this.$starInfo(sysID), "stars");
			} else {
				// if we have an invalid system ID, reset the line
				if (sd.systemDataLineOwner(i) === "stars") sd.resetSystemDataLine(i);
			}
			break;
		}
	}
}

//-------------------------------------------------------------------------------------------------------------
// slightly modified from Distant Sun's original code
this.$starInfo = function(sysID) {
	var info = System.infoForSystem(galaxyNumber, sysID);
	if (info.sun_gone_nova) return "";
	
	var name    = info.name;
	var sunName = info.sun_name;
	var colour  = info.sun_color;
	if (colour) var colourText = worldScripts.Stars.$spectroscope(colour);
	var text = "";
	if (worldScripts.RandomStationNames && missionVariables.random_station_names_stars === "On") {
		var starGrid = Math.floor(player.ship.targetSystem+(256 * galaxyNumber));
		sunName = worldScripts.RandomStationNames.starpool[starGrid&2047];
	}
	if (colourText && sunName) text += "The planet " + name + " orbits the " + colourText + " " + sunName + ".";
	else if (colourText) text += "The planet " + name + " orbits a " + colourText + ".";
	else if (sunName) text += "The planet " + name + " orbits the star " + sunName + ".";
	
	return text;
}