"use strict";

this.name    = "Throbtastic_Crosshairs";
this.version = "1.0";

 // Step definitions for the crosshairs animation
    this.CROSSHAIRS_SEQUENCE = [
    "throb-in-crosshairs.plist",   // Step 1: In
    null,                          // Step 2: In - don't reset
    "throb-both-crosshairs.plist", // Step 3: Both
    "throb-out-crosshairs.plist",  // Step 4: Out
    null,                          // Step 5: Out - don't reset
    "throb-both-crosshairs.plist"  // Step 6: Both
    ];

    this._sequenceLength = 6;
    this._currentStep = 0;
    this._throbTimer = null;

    this._throb = function throb () {
     // Get the current step's crosshairs configuration
        const crosshairs = this.CROSSHAIRS_SEQUENCE[this._currentStep];

     // Update the player's crosshairs if the step is not null
        if (crosshairs) {
            player.ship.crosshairs = crosshairs;
        }

     // Move to the next step in the sequence
        this._currentStep++;

     // Loop back to the beginning after completing the sequence
        if (this._currentStep >= this._sequenceLength) {
            this._currentStep = 0;
        }
    };

    this.weaponsSystemsToggled = function (online) {
        if (online) {
            this._sequenceLength = this.CROSSHAIRS_SEQUENCE.length;
            if (this._throbTimer) {
                this._throbTimer.start();
            } else {
                this._throbTimer = new Timer(this, this._throb, 0, 0.5);
            }
        } else {
            if (this._throbTimer) {
                this._throbTimer.stop();
            }
        }
    };

    this.shipWillLaunchFromStation = function () {
        this.weaponsSystemsToggled(player.ship.weaponsOnline);
        delete this.shipWillLaunchFromStation;
    };

    this.alertConditionChanged = function (newAlert, oldAlert) {
        if (!this._throbTimer) {
            return;
        }
        let restart = false;
        if (this._throbTimer.isRunning) {
            this._throbTimer.stop();
            restart = true;
        }
        const INTERVALS = [600, 0.67, 0.5, 0.25];
        this._throbTimer.interval = INTERVALS[newAlert];
        if (restart) {
            this._throbTimer.start();
        }        
    };

    this._updateCrosshairsSequence = function (newSequence) {
        if (Array.isArray(newSequence) && newSequence.length > 0) {
            this.CROSSHAIRS_SEQUENCE = newSequence;
            this._sequenceLength = this.CROSSHAIRS_SEQUENCE.length;
            log(this.name, "Updated CROSSHAIRS_SEQUENCE: " + JSON.stringify(this.CROSSHAIRS_SEQUENCE));
            log(this.name, "New sequence length: " + this._sequenceLength);
            return true;
        } else {
            log(this.name, "Error: Invalid sequence provided.");
            return false;
        }
    };
