this.name			= "GalTech_colonial_viper_mark_I";
this.author			= "Montana05";
this.description	= "event handler for GalTech colonial viper OXP";
this.version		= "0.50";
this.copyright		= "2020 Montana05";
this.licence   		= "CC BY-NC-SA 4.0";
"use strict";

// new features for Colonial Viper:

this.shipSpawned = function(ship)
{
	this.$GalTech_shipType = this.ship.dataKey;
			
	if(this.ship.hasRole("escape-capsule"))
	{
		// neutral inits first
		var $GalTech_crewName = expandDescription("[nom]");
		var $GalTech_description = "a crew member of an evacuated ship";
		var $GalTech_crewRole = "hunter";  // not perfect but somewhere in the middle
		var $GalTech_crewRace = expandDescription("[GalTech_GalCop_races]");  // added a race to the crew members
		
		// now it's time to be more specific, based on a 1 person crew
		// every individual without insurance or bounty will be defined as a slave
		switch(this.$GalTech_shipType) 
		{
			case "GalTech_colonial_viper_mark_I_escape_suit":
			
				this.$GalTech_colonial_viper_mark_I_crew_ranks_Array = 
				["Pilot", "Commander"];
				var $GalTech_crewRanks = 
				$GalTech_colonial_viper_mark_I_crew_ranks_Array[Math.floor(Math.random() * $GalTech_colonial_viper_mark_I_crew_ranks_Array.length)];
			
				$GalTech_crewName = ("the " + $GalTech_crewRace + " " + $GalTech_crewRanks + " " + expandDescription("[nom]"));
				$GalTech_description = "a fighter pilot";
				$GalTech_crewRole = "hunter"; 	
				break;
			
			case "GalTech_colonial_viper_mark_I_escape_suit_police":
				
				this.$GalTech_colonial_viper_mark_I_police_ranks_Array = 
				["Space Junior Lieutenant", "Space Lieutenant"];
				var $GalTech_policeRank = 
				$GalTech_colonial_viper_mark_I_police_ranks_Array[Math.floor(Math.random() * $GalTech_colonial_viper_mark_I_police_ranks_Array.length)];
			
				$GalTech_crewName = ("the " + $GalTech_crewRace + " " + $GalTech_policeRank + " " + expandDescription("[nom]"));
				$GalTech_description = "a crew member of a space police ship";
				$GalTech_crewRole = "police"; 		
				break;
			
			case "GalTech_colonial_viper_mark_I_escape_suit_pirate":
				
				$GalTech_crewName = 
				("the " + $GalTech_crewRace + " " + expandDescription("[GalTech_pirate_nicknames]") + expandDescription("[nom]"));
				
				$GalTech_description = "a criminal wanted by GalCop police";
				$GalTech_crewRole = "pirate";
				break;	
			
			default: 
				break;			
		};

		this.ship.setCrew
		(
			{
				name: $GalTech_crewName,
				short_description: $GalTech_description,
				role: $GalTech_crewRole,
				species: $GalTech_crewRace
			}
		);
	};
};

this.shipDied = function(whom, why)
{
	if(this.ship.hasRole("escape-capsule"))
	{
		return;
	}
	else
	{
		// neutral inits first
		var $GalTech_podType = "escape-capsule";
		var debrisCount = 1;  // for pods
				
		// time to eject the escape pods
		if(this.ship.bounty > 7)
		{
			this.ship.commsMessage(expandDescription("[GalTech_colonial_viper_msg_pirate]"), player.ship);
			$GalTech_podType = "GalTech_colonial_viper_mark_I_escape_suit_pirate";
		}
		else
		{
			switch(this.$GalTech_shipType) 
			{
				case "GalTech_colonial_viper_mark_I":

					this.ship.commsMessage(expandDescription("[GalTech_colonial_viper_msg_escort]"), player.ship);
					$GalTech_podType = "GalTech_colonial_viper_mark_I_escape_suit";
					break;
				
				case "GalTech_colonial_viper_mark_I-S":

					this.ship.commsMessage(expandDescription("[GalTech_colonial_viper_msg_trader]"), player.ship);
					$GalTech_podType = "GalTech_colonial_viper_mark_I_escape_suit";
					break;
					
				case "GalTech_colonial_viper_mark_I-S_hunter":
				case "GalTech_colonial_viper_mark_I_hunter_team_01":
				case "GalTech_colonial_viper_mark_I_hunter":	

					this.ship.commsMessage(expandDescription("[GalTech_colonial_viper_msg_hunter]"), player.ship);
					$GalTech_podType = "GalTech_colonial_viper_mark_I_escape_suit";
					break;

				case "GalTech_colonial_viper_mark_I_police":
				
					this.ship.commsMessage(expandDescription("[GalTech_colonial_viper_msg_police]"), player.ship);
					$GalTech_podType = "GalTech_colonial_viper_mark_I_escape_suit_police";	
					break;	
				
				// for pirates with small bounty, unlikely but better make sure
				case "GalTech_colonial_viper_mark_I_pirate":
				case "GalTech_colonial_viper_mark_I_pirate_team_01":	
		
					this.ship.commsMessage(expandDescription("[GalTech_colonial_viper_msg_pirate]"), player.ship);
					$GalTech_podType = "GalTech_colonial_viper_mark_I_escape_suit_pirate";
					break;	

				default: 
					break;	
			};	
		};
					
		// added 1x spacesuit of ejected pilot
		system.addShips($GalTech_podType, 1, this.ship.position);
		
		debrisCount = this.$getRndInteger(2, 4);
		// added explosive shrapnels
		system.addShips("GalTech_effects_explosive_shrapnel", debrisCount, this.ship.position);
		// added various depris
		system.addShips("GalTech_ship_debris", debrisCount, this.ship.position);

		// added burning fuel
		debrisCount = (this.ship.fuel.toFixed(0)) * 2;	
		system.addShips("GalTech_effects_burningFuel", debrisCount, this.ship.position);
	};
};	

this.$getRndInteger = function(min, max)
{
	return Math.floor(Math.random() * (max - min + 1) ) + min;
};
