"use strict";
this.name        = "TOGY_Memorials";
this.author      = "phkb, smivs";
this.copyright   = "2017 phkb";
this.description = "Controls the creation of the TOGY memorials.";
this.licence     = "CC BY-NC-SA 3.0";

this.systemWillRepopulate = function() {
    var togy = worldScripts.TOGY_Main;
    if (togy) {
        var togypos = togy._pos;
        if (((galaxyNumber === 0 && system.ID === 124) || togy._debug === true) && system.countShipsWithRole("togy_station") != 0) {
            var pos = Vector3D(togypos.x + 350, togypos.y + 3000, togypos.z - 350).fromCoordinateSystem("psm");
            var sr = 1000;
            var bcc = worldScripts.BroadcastCommsMFD;
            var iron = system.addShips("memorial_ironfist", 1, pos, sr);
            if (iron.length > 0) {
                if (bcc) {
                    iron[0].script._togy_info = "In memory of Commander John Tugwell, aka 'Ironfist', d 2013. A friendly, helpful test of others' work, and author of the Dwarven OXP.";
                    bcc.$createMessage({
                        messageName:"togy_memorial_reply_1", 
                        displayText:"[Query monument info]", 
                        messageText:"",
                        ship:iron[0],
                        transmissionType:"target", 
                        callbackFunction:togy.$transmitMonumentInfo,
                        deleteOnTransmit:false, 
                        delayCallback:1, 
                        hideOnConditionRed:false}
                    );
                }
            }
            var sven = system.addShips("memorial_svengali", 1, pos, sr);
            if (sven.length > 0) {
                if (bcc) {
                    sven[0].script._togy_info = "In memory of Commander Olli Krienke, aka 'Svengali', d 2021. One of our talented musician oxp-ers with a knack for getting Oolite to jump through hoops! Author of several vital OXP's including CCL, BGS and Library.";
                    bcc.$createMessage({
                        messageName:"togy_memorial_reply_2", 
                        displayText:"[Query monument info]", 
                        messageText:"",
                        ship:sven[0],
                        transmissionType:"target", 
                        callbackFunction:togy.$transmitMonumentInfo,
                        deleteOnTransmit:false, 
                        delayCallback:1, 
                        hideOnConditionRed:false}
                    );
                }
            } else {
                log("testing", "svengali memorial not created!");
            }
        } else {
            log(this.name, "mismatch on system/galaxy id - ie not Tionisla or togy_station not present.")
        }
    } else {
        log(this.name, "did not find togy main script");
    }
    // we only want to do this once
    delete this.systemWillRepopulate;
}