// JavaScript for Oolite (ECMAScript 5)

"use strict";
    this.license = "CC-BY-NC-SA 4.0";
    this.author = "Wildeblood";
    this.version = "0.7";
    this.name = "Lost_In_Space";

    this.playerEnteredNewGalaxy = function (galaxy) {
     // Choose number of systems to hide
        const TOTAL = 256;
        const MIN = 51;      // 20 % of 256
        const MAX = 128;     // 50 % of 256
        const SYSTEMS_TO_HIDE = Math.floor(Math.random() * (MAX - MIN + 1)) + MIN;

     // Create an array of sysIDs (0-255), but with order shuffled
        var sysIDs = [];
        for (let i = 0; i < TOTAL; i++) {
            sysIDs.push(i);
        }
     // Shuffle using Fisher–Yates algorithm
        for (let i = sysIDs.length - 1; i > 0; i--) {
            const j = Math.floor(Math.random() * (i + 1));
            [sysIDs[i], sysIDs[j]] = [sysIDs[j], sysIDs[i]];
        }

     // Read sysIDs from the array and hide up to chosen number
        for (let i = 0; i < TOTAL; i++) {
            if (i < SYSTEMS_TO_HIDE) {
                this._concealSystem(sysIDs[i]);
            } else {
                this._renewSystem(sysIDs[i]);
            }
        }
        log(this.oolite_manifest_identifier, "Randomly concealed " + SYSTEMS_TO_HIDE + " systems in galaxy " + galaxyNumber + ".");

     // Remove changes made to previous galaxy to avoid bloating the save file
        if (typeof galaxy === "undefined" || galaxy < 0 || galaxy > 7) {
            log(this.name, "playerEnteredNewGalaxy called with no galaxy parameter, skipped resetting the previous galaxy.");
            return;
        }
        galaxy = (galaxy + 7) % 8;  // Calculate previous galaxy number
        this._resetAllSystemsInGalaxy(galaxy);

     // Add disabled galactic hyperdrive
        player.ship.awardEquipment("EQ_GAL_DRIVE");
        player.ship.setEquipmentStatus("EQ_GAL_DRIVE", "EQUIPMENT_DAMAGED");
    };

    this._concealSystem = function (sysID) {
        System.infoForSystem(galaxyNumber, sysID).setProperty(3, "concealment", "300");
    };

    this._renewSystem = function (sysID) {
        const sys = System.infoForSystem(galaxyNumber, sysID);
        sys.setProperty(3, "concealment", null);
        sys.setProperty(2, "name", this._generatePlanetName());
        sys.setProperty(1, "economy", Math.floor(Math.random() * 8));
        sys.setProperty(1, "government", Math.floor(Math.random() * 8));
        sys.setProperty(1, "techlevel", Math.floor(Math.random() * 16));
        sys.setProperty(1, "description", "Mostly harmless.");
    };

    this._resetAllSystemsInGalaxy = function (galaxy) {
        if (typeof galaxy !== "number" || galaxy < 0 || galaxy > 7) {
            log(this.name, "Invalid galaxy parameter. Defaulting to galaxyNumber: " + galaxyNumber);
            galaxy = galaxyNumber;
        }
        for (let sysID = 0; sysID <= 255; sysID++) {
            var sys = System.infoForSystem(galaxy, sysID);
            sys.setProperty(3, "concealment", null);
            sys.setProperty(2, "name", null);
            sys.setProperty(1, "economy", null);
            sys.setProperty(1, "government", null);
            sys.setProperty(1, "techlevel", null);
            sys.setProperty(1, "description", null);
        }
    };

/* ==================== PLANET NAME-GENERATOR ==================== */
/* Courtesy of DeepSeek 2805 */

 this._OFF_generatePlanetName = function () {
    // Syllable components
    var starters = ["Z", "X", "K", "N", "V", "Qu", "Th", "Dr", "Kr", "St"];
    var middles = ["a", "e", "i", "o", "u", "y", "ar", "or", "al", "il", "en", "in", "on"];
    var endings = ["x", "n", "r", "th", "s", "k", "l", "m", "nex", "tus", "ros", "vox", "z", "t", "c"];
    var vowels = ["a", "e", "i", "o", "u", "y"];

    // Name construction function
    function createName() {
        var starter = starters[Math.floor(Math.random() * starters.length)];
        var middle = middles[Math.floor(Math.random() * middles.length)];
        var ending = endings[Math.floor(Math.random() * endings.length)];
        
        // Randomly decide between 1 or 2 middle syllables
        if (Math.random() > 0.5) {
            var extraMiddle = middles[Math.floor(Math.random() * middles.length)];
            // Ensure combined syllables don't create awkward consonant clusters
            if (vowels.indexOf(middle[middle.length - 1]) === -1 && 
                vowels.indexOf(extraMiddle[0]) === -1) {
                extraMiddle = vowels[Math.floor(Math.random() * vowels.length)];
            }
            return starter + middle + extraMiddle + ending;
        }
        return starter + middle + ending;
    }

    // Generate name and ensure proper length
    var name = createName();
    
    // Ensure valid length (3-8 chars)
    if (name.length > 8) {
        name = name.substring(0, 8);
    } else if (name.length < 3) {
        // Add short sci-fi suffix if too short
        var shortSuffixes = ["x", "on", "ax", "ex", "or"];
        name += shortSuffixes[Math.floor(Math.random() * shortSuffixes.length)];
        name = name.substring(0, 8);
    }
    
    return name;
 }

/* ==================== PLANET NAME-GENERATOR ==================== */
/* Courtesy of Qwen2.5-Max */

this._generatePlanetName = function () {
    const starters = ["Z", "X", "K", "N", "V", "Qu", "Th", "Dr", "Kr", "St"];
    const middles = ["a", "e", "i", "o", "u", "ar", "or", "al", "il", "en"];
    const endings = ["x", "n", "th", "s", "k", "nex", "tus", "ros", "vox"];

    const starter = starters[Math.floor(Math.random() * starters.length)];
    const middle = middles[Math.floor(Math.random() * middles.length)];
    const ending = endings[Math.floor(Math.random() * endings.length)];

    let name = starter + middle + ending;
    // Truncate to 8 characters max
    name = name.substring(0, 8);
    // Ensure minimum length of 3 characters
    while (name.length < 3) {
        name += middles[Math.floor(Math.random() * middles.length)];
    }
    return name;
};

/* ==================== TESTING FUNCTIONS ==================== */

 // To add the test functions "Randomize Chart" and "Reset Chart" to the F4 screen,
 // in any world script, in the startUp or startUpComplete functions, set:
 // worldScripts.Lost_In_Space._testing = true;
 // This cannot be changed after startUpComplete.

    this._testing = true;

    this.missionScreenOpportunity = function () {
        if (this._testing) {
            this.shipExitedWitchspace();
        } else {
            delete this.shipExitedWitchspace;
            delete this._randomizeChart;
            delete this._resetChart;
        }
        delete this._testing;
        delete this.missionScreenOpportunity; // Run only once, shortly after startUpComplete
    };

    this.shipExitedWitchspace = function () {
        if (system.mainStation) {
            system.mainStation.setInterface("randomize_chart", {
              title: "Randomize Chart",
              category: "A TEST",
              summary: "Randomize appearance of current chart (galaxy " + galaxyNumber + ").",
              callback: this._randomizeChart.bind(this)
            });
            system.mainStation.setInterface("reset_chart", {
              title: "Reset Chart",
              category: "A TEST",
              summary: "Reset all changes to current chart (galaxy " + galaxyNumber + ").",
              callback: this._resetChart.bind(this)
            });
        }
    };

    this._randomizeChart = function () {
        player.consoleMessage("Chart will be randomized in a few seconds.", 10);
        this.playerEnteredNewGalaxy(); // Call without parameter, because we don't need to reset the previous chart
    };

    this._resetChart = function () {
        player.consoleMessage("Chart will be reset in a few seconds.", 10);
        this._resetAllSystemsInGalaxy(galaxyNumber);
    };
