// JavaScript for Oolite (ECMAScript 5)
// oolite_manifest_identifier: "oolite.oxp.Wildeblood.Lost_In_Space"

"use strict";
    this.license = "CC-BY-NC-SA 4.0";
    this.author = "Wildeblood";
    this.version = "1.0";
    this.name = "lost_in_space";

 // To add the test functions "Randomize Chart" and "Reset Chart" to the F4 screen,
 // in any world script, in the startUp or startUpComplete functions, set:
 // worldScripts.lost_in_space.testing = true;
 // This cannot be changed after startUpComplete.

    this.testing = true;

    this.playerEnteredNewGalaxy = function (galaxy) {
     // Choose number of systems to hide
        const TOTAL = 256;
        const MIN = 51;      // 20 % of 256
        const MAX = 128;     // 50 % of 256
        const SYSTEMS_TO_HIDE = Math.floor(Math.random() * (MAX - MIN + 1)) + MIN;

     // Create an array of sysIDs (0-255), but with order shuffled
        var sysIDs = [];
        for (let i = 0; i < TOTAL; i++) {
            sysIDs.push(i);
        }
     // Fisher–Yates shuffle (in-place, O(n))
        for (let i = sysIDs.length - 1; i > 0; i--) {
            const j = Math.floor(Math.random() * (i + 1));
            [sysIDs[i], sysIDs[j]] = [sysIDs[j], sysIDs[i]];
        }

     // Read sysIDs from the array and hide up to chosen number
        for (let i = 0; i < TOTAL; i++) {
            if (i < SYSTEMS_TO_HIDE) {
                this._concealSystem(sysIDs[i]);
            } else {
                this._renewSystem(sysIDs[i]);
            }
        }
        log(this.oolite_manifest_identifier, "Randomly concealed " + SYSTEMS_TO_HIDE + " systems in galaxy " + galaxyNumber + ".");

     // Reset changes made to previous galaxy (avoid bloating the save file)
        this._resetPreviousGalaxy(galaxy);
    };

    this._concealSystem = function (sysID) {
        System.infoForSystem(galaxyNumber, sysID).setProperty(3, "concealment", "300");
    };

    this._renewSystem = function (sysID) {
     // TODO (later): random name generator comes later,
     // use galaxy chart and sysID instead of name while testing
        const newName = "GC " + galaxyNumber + "-" + sysID;
        System.infoForSystem(galaxyNumber, sysID).setProperty(2, "name", newName);
        System.infoForSystem(galaxyNumber, sysID).setProperty(3, "concealment", null);
    };

    this._resetPreviousGalaxy = function (galaxy) {
        if (typeof galaxy === "undefined" || galaxy < 0 || galaxy > 7) {
            log(this.name, "Invalid galaxy parameter, _resetPreviousGalaxy aborted.");
            return;
        }
     // Calculate previous galaxy number
        galaxy = (galaxy + 7) % 8;
        this._resetAllSystemsInGalaxy(galaxy);
    };

/**
 * Resets the concealment and name properties for all systems in a given galaxy to their defaults.
 * @param {number} [galaxy=galaxyNumber] - The galaxy number (0–7). Defaults to the global `galaxyNumber`.
 */
    this._resetAllSystemsInGalaxy = function (galaxy) {
        if (typeof galaxy !== "number" || galaxy < 0 || galaxy > 7) {
            log(this.name, "Invalid galaxy parameter. Defaulting to galaxyNumber: " + galaxyNumber);
            galaxy = galaxyNumber;
        }
        for (let sysID = 0; sysID <= 255; sysID++) {
            var sys = System.infoForSystem(galaxy, sysID);
            if (sys) {
                sys.setProperty(3, "concealment", null);
                sys.setProperty(2, "name", null);
            }
        }
    };

/* ==================== TESTING FUNCTIONS ==================== */

    // Runs only once, shortly after startUp
    this.missionScreenOpportunity = function () {
        if (this.testing) {
            this.shipExitedWitchspace();
        } else {
            delete this.shipExitedWitchspace;
            delete this._randomizeChart;
            delete this._resetChart;
        }
        delete this.missionScreenOpportunity;
        delete this.testing;
    };

    this.shipExitedWitchspace = function () {
        if (system.mainStation) {
            system.mainStation.setInterface("randomize_chart", {
              title: "Randomize Chart",
              category: "A TEST",
              summary: "Randomize appearance of current chart (galaxy " + galaxyNumber + ").",
              callback: this._randomizeChart.bind(this)
            });
            system.mainStation.setInterface("reset_chart", {
              title: "Reset Chart",
              category: "A TEST",
              summary: "Reset all changes to current chart (galaxy " + galaxyNumber + ").",
              callback: this._resetChart.bind(this)
            });
        }
    };

    this._randomizeChart = function () {
        player.consoleMessage("Chart will be randomized in a few seconds.", 10);
        this.playerEnteredNewGalaxy();
    };

    this._resetChart = function () {
        player.consoleMessage("Chart will be reset in a few seconds.", 10);
        this._resetAllSystemsInGalaxy(galaxyNumber);
    };
