"use strict";
this.name = "togy-patrol";
this.author = "eric walch";
this.copyright = "2010 the authors.";
this.description = "togy-patrol script";
this.license = "CC BY-NC-SA 3.0";

/*
The player will not hear the distress call because only ships with pilots
can send commsMessages and since about Oolite 1.71 stuff of class_cargo
has no pilots as default.
Also are the commsMessages are only send to 16 ships. Starting with 1.75 commsMessages
always wil go to the player.
*/
this.shipSpawned = function () {
    var station = system.shipsWithPrimaryRole("togy_station")[0];
    station.group.addShip(this.ship); // make self part of the station group
    this.ship.group = station.group; // we are one group now.
    //log(this.name, "shipSpawned " + this.ship + "-- group is set: " + (this.ship.group ? "yes" : "no"));
}

this.shipBeingAttacked = function (attacker) {
    //log(this.name, "shipBeingAttacked " + this.ship + "-- group is set: " + (this.ship.group ? "yes" : "no"));
    if (this.ship.group) {
        var station = this.ship.group.leader;
    } else {
        var station = system.shipsWithPrimaryRole("togy_station")[0];
    }
    if (attacker.group && attacker.group == station.group) return;
    station.target = attacker;
    if (station.dockedDefenders > 0) station.launchDefenseShip();
    station.reactToAIMessage("GRAVEYARD_DISTURBED");
}

this.distressMessageReceived = function (aggressor, victim) {
    if (aggressor && victim) this.ship.commsMessage(expandDescription("[togy_patrol_warning]", { shipname: aggressor.displayName, gravename: victim.displayName }));
}