"use strict";
this.name = "TOGY_Main";
this.author = "phkb";
this.copyright = "2017 phkb";
this.description = "Controls the creation of the TOGY station and ships.";
this.license = "CC BY-NC-SA 3.0";

this._debug = false;
this._msgCount = 0;
this._predefinedNames = [];

// we'll set the position of the station from these co-ords, and then make everything else relative to it
// just in case a decision is made to change the position of the graveyard later
this._pos = { x: 0, y: -3000, z: 210600 };

//-------------------------------------------------------------------------------------------------------------
this.startUp = function () {
	var namelist = expandDescription("[togy_monument_names]").split("~");
	for (var i = 0; i < namelist.length; i++) {
		var items = namelist[i].split("|");
		this._predefinedNames.push({ name: items[0], born: items[1], died: items[2] });
	}
}

//-------------------------------------------------------------------------------------------------------------
this.startUpComplete = function () {
	if (worldScripts.BountySystem_Core) {
		var bsc = worldScripts.BountySystem_Core;
		bsc._offenceTypes["togy_cascade_weapon"] = {
			description: expandDescription("[togy_offence]"),
			severity: 3
		};
	}
}

//-------------------------------------------------------------------------------------------------------------
this.systemWillPopulate = function () {
	if (((galaxyNumber === 0 && system.ID === 124) || this._debug === true) && system.countShipsWithRole("togy_station") === 0) {
		var posTOGY = Vector3D(this._pos.x, this._pos.y, this._pos.z).fromCoordinateSystem("psm");
		system.setPopulator("togy-station", {
			callback: function (pos) {
				var sr = 1000;
				var tm = worldScripts.TOGY_Main;
				var stn = system.addShips("togy_station", 1, pos, 0)[0];
				// point station at planet for consistency
				stn.orientation = system.mainPlanet.position.subtract(stn.position).direction().rotationTo([0, 0, 1]);

				var x = tm._pos.x;
				var y = tm._pos.y;
				var z = tm._pos.z;
				system.addShips("togy-patrol", 4, Vector3D(x, y + 2000, z).fromCoordinateSystem("psm"), sr);
				system.addShips("togy-defence", 2, Vector3D(x, y + 2000, z).fromCoordinateSystem("psm"), sr);
				system.addShips("togy_grave_beacon", 1, Vector3D(x - 3400, y + 3000, z - 5800).fromCoordinateSystem("psm"), sr);
				system.addShips("togy_grave_beacon", 1, Vector3D(x + 3400, y + 3000, z - 5800).fromCoordinateSystem("psm"), sr);
				system.addShips("togy_grave_beacon", 1, Vector3D(x - 6600, y + 3000, z).fromCoordinateSystem("psm"), sr);
				system.addShips("togy_grave_beacon", 1, Vector3D(x + 6600, y + 3000, z).fromCoordinateSystem("psm"), sr);
				system.addShips("togy_grave_beacon", 1, Vector3D(x - 3400, y + 3000, z + 5600).fromCoordinateSystem("psm"), sr);
				system.addShips("togy_grave_beacon", 1, Vector3D(x + 3400, y + 3000, z + 5600).fromCoordinateSystem("psm"), sr);
				tm.$addInfoToGrave(system.addShips("grave_monument", 1, Vector3D(x, y + 3000, z).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 5, Vector3D(x, y + 3000, z - 700).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 5, Vector3D(x - 400, y + 3000, z - 400).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 5, Vector3D(x + 380, y + 3000, z - 400).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 5, Vector3D(x - 400, y + 3000, z - 3600).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 5, Vector3D(x + 160, y + 3000, z - 3600).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 5, Vector3D(x - 760, y + 3000, z).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 5, Vector3D(x + 760, y + 3000, z).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 5, Vector3D(x - 400, y + 3000, z + 400).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 5, Vector3D(x + 400, y + 3000, z + 400).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 5, Vector3D(x, y + 3000, z + 700).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 400, y + 3000, z - 3600).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 160, y + 3000, z - 3600).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 800, y + 3000, z - 3400).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 1200, y + 3000, z - 3000).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x, y + 3000, z + 2600).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 1360, y + 3000, z - 2400).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 1160, y + 3000, z - 2000).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 1380, y + 3000, z - 1800).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 200, y + 3000, z - 1700).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 760, y + 3000, z - 1660).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 2400, y + 3000, z - 1400).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 1800, y + 3000, z - 1400).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 3000, y + 3000, z - 1200).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 1200, y + 3000, z - 1200).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 380, y + 3000, z - 1200).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 340, y + 3000, z - 1200).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 1200, y + 3000, z - 1200).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 2000, y + 3000, z - 1040).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 3400, y + 3000, z - 800).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 800, y + 3000, z - 800).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 800, y + 3000, z - 800).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 1620, y + 3000, z + 1250).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 3600, y + 3000, z - 400).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 1200, y + 3000, z - 380).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 1200, y + 3000, z - 360).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 3600, y + 3000, z - 200).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 1740, y + 3000, z + 1600).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 3600, y + 3000, z + 120).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 1640, y + 3000, z + 200).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 1200, y + 3000, z + 300).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 1200, y + 3000, z + 360).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 3600, y + 3000, z + 400).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 1620, y + 3000, z + 700).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 800, y + 3000, z + 800).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 800, y + 3000, z + 800).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 3400, y + 3000, z + 800).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 2000, y + 3000, z + 1100).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 1200, y + 3000, z + 1200).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 300, y + 3000, z + 1200).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 340, y + 3000, z + 1200).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 1200, y + 3000, z + 1200).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 3000, y + 3000, z + 1200).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 1800, y + 3000, z + 1400).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 2400, y + 3000, z + 1400).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 640, y + 3000, z + 1600).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 200, y + 3000, z + 1680).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 1400, y + 3000, z + 1800).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 1100, y + 3000, z + 2000).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 1400, y + 3000, z + 2400).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 1200, y + 3000, z + 2800).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 800, y + 3000, z + 3400).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 200, y + 3000, z + 3600).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 400, y + 3000, z + 3600).fromCoordinateSystem("psm"), sr));
			},
			location: "COORDINATES",
			coordinates: posTOGY,
			deterministic: true
		});
	}
}

//-------------------------------------------------------------------------------------------------------------
this.$addInfoToGrave = function (ships) {
	if (!ships || ships.length === 0) return;
	var bcc = worldScripts.BroadcastCommsMFD;
	if (!bcc) return;
	var tm = worldScripts.TOGY_Main;
	for (var i = 0; i < ships.length; i++) {
		if (Math.random() > 0.5 && tm._predefinedNames.length > 0) {
			// get the first element in the array, and remove it
			var item = tm._predefinedNames.shift();
			var nm = item.name;
			var born = new Date(Date.parse(item.born));
			var died = new Date(Date.parse(item.died));
		} else {
			// just generate a random name
			var end = Math.floor(Math.random() * 750 + 20); // how long ago did they die?
			// if this is a newer type ship, move the death date to be a bit closer to now
			if (ships[i].hasRole("togy_newship") === true) end = Math.floor(Math.random() * 20 + 20);
			var age = Math.floor(Math.random() * 70 + 20); // how old were they?
			// calc a date of death
			var died = new Date(3142 - end, Math.floor(Math.random() * 12), Math.floor(Math.random() * 27 + 1));
			// calc a birth date
			var born = new Date(died.getFullYear() - age, Math.floor(Math.random() * 12), Math.floor(Math.random() * 27 + 1));
			var nm = expandDescription("%N ") + expandDescription("[nom]");
		}
		ships[i].script._togy_info = expandDescription("[togy_memorial]",
			{ name: nm, born: tm.$getShortDate(born), died: tm.$getShortDate(died) }
		);
		// add a reply option
		tm._msgCount += 1;
		bcc.$createMessage({
			messageName: "togy_transmit_reply_" + tm._msgCount,
			displayText: "[Query monument info]",
			messageText: "",
			ship: ships[i],
			transmissionType: "target",
			callbackFunction: tm.$transmitMonumentInfo,
			deleteOnTransmit: false,
			delayCallback: 1,
			hideOnConditionRed: false
		}
		);
	}
}

//-------------------------------------------------------------------------------------------------------------
this.$transmitMonumentInfo = function () {
	var t = player.ship.target;
	if (!t || !t.script || t.script.hasOwnProperty("_togy_info") === false) return;
	t.commsMessage(t.script._togy_info, player.ship);
}

//-------------------------------------------------------------------------------------------------------------
this.$getShortDate = function (date) {
	return date.getDate() + " " + this.$monthName(date.getMonth()) + " " + date.getFullYear();
}

//-------------------------------------------------------------------------------------------------------------
this.$monthName = function (month) {
	var months = expandDescription("[togy_months]").split("|");
	return months[month];
}