"use strict";
this.name      = "togy_dodo"; 
this.author    = "eric walch"; 
this.copyright = "2010 the authors.";
this.description = "togy_dodo script";
this.license     = "CC BY-NC-SA 3.0";

this.dockedPatrols = 0;
this.dockedTourists = 5;

this.shipSpawned = function () {
    // look for any nearby cargo after spawning.
    // ships within 2000 meter in front of the docking area block launches.
    // The dock is positioned at 392 meter from the station center, so ships must stay
    // at 2400 meter from the station. This sometimes happens, so remove them.
    // Moving ships are no problem as they are suposed to fly away themselves.
    var problem = system.entitiesWithScanClass("CLASS_CARGO", this.ship, 2.4E3);
    for (var i=0; i< problem.length; i++) {
        problem[i].remove();
    }
    var problem = system.entitiesWithScanClass("CLASS_ROCK", this.ship, 2.4E3);
    for (var i=0; i< problem.length; i++) {
        problem[i].remove();
    }
}

this.otherShipDocked = function (ship) {
    if (ship.primaryRole == "togy-patrol") this.dockedPatrols++;
    else if (ship.primaryRole == "togy_tourist") this.dockedTourists++;
    if (!this.launchTimer || this.launchTimer.isRunning === false) this.launchTimer = new Timer(this, this.launchPatrol, 30 + 120 * Math.random());
}

this.launchPatrol = function launchPatrol() { // is triggered by any docking ship.
    if (this.dockedPatrols > 0) {
        this.dockedPatrols--;
        this.ship.launchShipWithRole("togy-patrol");
        // patrols add themselves to the station group.
    }
    else if (this.dockedTourists > 0) {
        this.dockedTourists--;
        var tourist = this.ship.launchShipWithRole("togy_tourist");
        // add tourist to group to be able to call help from group when attacked.
        this.ship.group.addShip(tourist);
        tourist.group = this.ship.group;
    }

    if (this.dockedPatrols > 0) {
        this.launchTimer = new Timer(this, this.launchPatrol, 30 + 120 * Math.random());
    } else {
        delete this.launchTimer;
    }
}

this.shipDied = function (killer, why) {
    if (why && why == "cascade weapon") {
        if (killer.isPlayer) killer.setBounty(killer.bounty + 10E3, "togy_cascade_weapon"); // takes the player quite a while to become clean again. Might give valuable npc ships!
    }
    if (this.launchTimer) {
        this.launchTimer.stop();
        delete this.launchTimer;
    }
}