"use strict";
this.name      = "togy_monument"; 
this.author    = "eric walch"; 
this.copyright = "2010 the authors.";
this.description = "script for monuments";

/*
    The AI sends a distress message when attacked. But when the patrol ships are not very near they will miss it because the distress message only goes to the 16 nearest opjects.
    Same is true for commsMessages. Those are only send to the 16 nearest ships. The AI can send a "sendTargetCommsMessage", but it needs a pilot to do that
    Therefor we add deliberate checks that are send directly to the station.
    With 1.75 things might have changed in a way that the player always will receive the plain commsMessage when in range.
*/
this.shipBeingAttacked = function (attacker) {
   if (!this.canReact()) return;
   var station = system.shipsWithPrimaryRole("togy_station", this.ship, this.ship.scannerRange)[0];
   if (!station || (attacker.group && attacker.group == station.group)) return;
   station.target = attacker;
   station.launchDefenseShip();
   station.reactToAIMessage("GRAVEYARD_ATTACKED");
   attacker.bounty += 10;
}

this.shipCollided = function (collider)
{
    if (!this.canReact()) return;
    if (collider && (collider.scanClass == "CLASS_CARGO" || collider.scanClass == "CLASS_ROCK")) return;
    var station = system.shipsWithPrimaryRole("togy_station", this.ship, this.ship.scannerRange)[0];
    if (!station || (collider.group && collider.group == station.group)) return;
    station.target = collider;
    station.reactToAIMessage("GRAVEYARD_DISTURBED");
    if (Math.random() < 0.1) { // don't always attack
       station.launchDefenseShip();
    }
}

this.shipAttackedWithMissile = function (missile, missileOwner) {
   if (!this.canReact()) return;
   var station = system.shipsWithPrimaryRole("togy_station", this.ship, this.ship.scannerRange)[0];
   if (!station || (missileOwner.group && missileOwner.group == station.group)) return;
   station.target = missileOwner;
   station.launchDefenseShip();
   station.reactToAIMessage("GRAVEYARD_ATTACKED");
   missileOwner.bounty += 10;
}

this.canReact = function () {
    if (this.lastMessageTime && this.lastMessageTime + 60 > clock.absoluteSeconds) return false; // don't react to often.
    this.lastMessageTime = clock.absoluteSeconds;
    return true;
}