"use strict";
this.name        = "TOGY_Main";
this.author      = "phkb";
this.copyright   = "2017 phkb";
this.description = "Controls the creation of the TOGY station and ships.";
this.licence     = "CC BY-NC-SA 3.0";

this._debug = false;
this._msgCount = 0;
this._predefinedNames = [
	{name:"Robert Holdstock",born:"1948-08-02",died:"2009-11-29"},
	{name:"Steve Jobs",born:"1955-02-24",died:"2011-10-05"},
	{name:"Terry Pratchett",born:"1948-04-28",died:"2015-03-12"},
	{name:"Isaac Asimov",born:"1920-01-02",died:"1992-04-06"},
	{name:"Arthur C. Clarke",born:"1917-12-16",died:"2008-03-19"},
	{name:"Philip P. Dick",born:"1928-12-16",died:"1982-03-02"},
	{name:"Ray Bradbury",born:"1920-08-22",died:"2012-06-05"},
	{name:"Frank Herbert",born:"1920-10-08",died:"1986-02-11"},
	{name:"George Orwell",born:"1903-06-25",died:"1950-01-21"},
	{name:"Jules Verne",born:"1828-02-08",died:"1905-03-24"},
	{name:"Robert Heinlein",born:"1907-07-07",died:"1988-05-08"},
	{name:"H. G. Wells",born:"1866-09-21",died:"1946-08-13"},
	{name:"Carrie Fisher",born:"1956-10-21",died:"2016-12-27"},
	{name:"J. R. R. Tolkien",born:"1892-01-03",died:"1973-09-02"},
	{name:"Douglas Adams",born:"1952-03-11",died:"2001-05-11"},
	{name:"Albert Einstein",born:"1879-03-14",died:"1955-04-18"},
	{name:"Nikola Tesla",born:"1856-07-10",died:"1943-01-07"},
	{name:"Thomas Edison",born:"1847-02-11",died:"1931-10-18"},
	{name:"Alexander Graham Bell",born:"1847-03-03",died:"1922-08-02"},
	{name:"Leonardo da Vinci",born:"1452-04-15",died:"1519-05-02"},
	{name:"Johannes Kepler",born:"1571-12-27",died:"1630-11-15"},
	{name:"Carl Sagan",born:"1934-11-09",died:"1996-12-20"},
	{name:"Edwin Hubble",born:"1889-11-20",died:"1953-09-28"},
	{name:"Ursula K Le Guin",born:"1929-10-21",died:"2018-01-22"},
	{name:"Galileo Galilei",born:"1564-02-15",died:"1642-01-08"},
	{name:"Nicolaus Copernicus",born:"1473-02-19",died:"1543-05-24"},
	{name:"Stephen Hawking",born:"1942-01-08",died:"2018-03-14"},
	{name:"Marie Curie",born:"1867-11-07",died:"1934-07-04"},
	{name:"Alfred Nobel",born:"1833-10-21",died:"1896-12-10"},
	{name:"Mary Winston Jackson",born:"1921-04-09",died:"2005-02-11"},
	{name:"Marie M. Daly",born:"1921-04-16",died:"2003-10-28"},
	{name:"Virgil Ivan 'Gus' Grissom",born:"1926-04-03",died:"1967-01-27"},
	{name:"Edward Higgins White II",born:"1930-11-14",died:"1967-01-27"},
	{name:"Roger Bruce Chaffee",born:"1935-02-15",died:"1967-01-27"},
	{name:"Michael John Smith",born:"1945-04-30",died:"1986-01-28"},
	{name:"Francis Richard Scobee",born:"1939-05-19",died:"1986-01-28"},
	{name:"Ronald Erwin McNair",born:"1950-10-21",died:"1986-01-28"},
	{name:"Edison Shoji Onizuka",born:"1946-06-24",died:"1986-01-28"},
	{name:"Sharon Christa McAuliffe",born:"1948-09-02",died:"1986-01-28"},
	{name:"Gregory Bruce Jarvis",born:"1944-08-24",died:"1986-01-28"},
	{name:"Judith Arlene Resnik",born:"1949-04-05",died:"1986-01-28"},
	{name:"Theodore C. Freeman",born:"1930-02-18",died:"1964-10-31"},
	{name:"Charles A. Bassett II",born:"1931-12-30",died:"1966-02-28"},
	{name:"Elliot M. See, Jr",born:"1927-07-23",died:"1966-02-28"},
	{name:"Edward G. Givens",born:"1930-01-05",died:"1967-06-06"},
	{name:"Clifton C. Williams, Jr",born:"1932-09-26",died:"1967-10-05"},
	{name:"Michael James Adams",born:"1930-05-30",died:"1967-11-15"},
	{name:"Robert Henry Lawrence",born:"1935-10-02",died:"1967-12-08"},
	{name:"Michael P. Anderson",born:"1959-12-25",died:"2003-02-01"},
	{name:"David M. Brown",born:"1956-04-16",died:"2003-02-01"},
	{name:"Kalpana Chawla",born:"1962-03-17",died:"2003-02-01"},
	{name:"Laurel Blair Salton Clark",born:"1961-03-10",died:"2003-02-01"},
	{name:"Rick Douglas Husband",born:"1957-07-12",died:"2003-02-01"},
	{name:"William C. McCool",born:"1961-09-23",died:"2003-02-01"},
	{name:"Ilan Ramon",born:"1954-07-20",died:"2003-02-01"},
	{name:"Vladimir Mikhaylovich Komarov",born:"1927-03-16",died:"1967-04-24"},
	{name:"Georgiy Timofeyevich Dobrovolsky",born:"1928-06-01",died:"1971-06-30"},
	{name:"Viktor Ivanovich Patsayev",born:"1933-06-19",died:"1971-06-30"},
	{name:"Vladislav Nikolayevich Volkov",born:"1935-11-23",died:"1971-06-30"},
	{name:"Yuri Alekseyevich Gagarin",born:"1934-03-09",died:"1968-03-27"},
	{name:"Vladimir Sergeyevich Seryogin",born:"1922-07-07",died:"1968-03-27"},
	{name:"Valentin Vasiliyevich Bondarenko",born:"1937-02-16",died:"1961-03-23"},
	{name:"Sergei Yuriyevich Vozovikov",born:"1958-04-17",died:"1993-07-11"},
	{name:"Rosalind Elsie Franklin",born:"1920-07-25",died:"1958-04-16"},
	{name:"Frederick William Herschel",born:"1738-11-15",died:"1822-08-25"},
	{name:"Andre-Marie Ampere",born:"1775-01-20",died:"1836-06-10"},
	{name:"Francis Bacon",born:"1561-01-02",died:"1626-04-09"},
	{name:"Daniel Bernoulli",born:"1700-02-08",died:"1782-03-17"},
	{name:"Niels Bohr",born:"1885-10-07",died:"1962-11-18"},
	{name:"Satyendra Nath Bose",born:"1894-01-01",died:"1974-02-04"},
	{name:"Tycho Brahe",born:"1546-12-12",died:"1601-10-24"},
	{name:"Subrahmanyan Chandrasekhar",born:"1910-10-19",died:"1995-08-21"},
	{name:"Michael Faraday",born:"1791-09-22",died:"1867-08-25"},
	{name:"Carl Friedrich Gauss",born:"1777-04-30",died:"1855-02-23"},
	{name:"Joseph Henry",born:"1797-12-17",died:"1878-05-13"},
	{name:"Heinrich Rudolf Hertz",born:"1857-02-22",died:"1894-01-01"},
	{name:"David Hilbert",born:"1862-01-23",died:"1943-02-14"},
	{name:"Grace Murray Hopper",born:"1906-12-09",died:"1992-01-01"},
	{name:"Stephanie Louise Kwolek",born:"1923-07-31",died:"2014-06-14"},
	{name:"Ada Lovelace",born:"1815-12-10",died:"1852-11-27"},
	{name:"Lise Meitner",born:"1878-11-07",died:"1968-10-27"},
	{name:"Amalie Emmy Noether",born:"1882-03-23",died:"1935-04-14"},
	{name:"Hans Christian Oersted",born:"1777-08-14",died:"1851-03-09"},
	{name:"Max Planck",born:"1858-04-23",died:"1947-10-04"},
	{name:"Ernest Rutherford",born:"1871-08-30",died:"1937-10-19"},
	{name:"Eugene Merle Shoemaker",born:"1928-04-28",died:"1997-07-18"},
	{name:"Joseph John Thomson",born:"1856-12-18",died:"1940-08-30"},
	{name:"Alessandro Volta",born:"1745-02-18",died:"1827-03-05"},
	{name:"James Watt",born:"1736-01-30",died:"1819-08-25"}
];

// we'll set the position of the station from these co-ords, and then make everything else relative to it
// just in case a decision is made to change the position of the graveyard later
this._pos = {x:0, y:-3000, z:210600};

//-------------------------------------------------------------------------------------------------------------
this.startUpComplete = function() {
    if (worldScripts.BountySystem_Core) {
        var bsc = worldScripts.BountySystem_Core;
        bsc._offenceTypes["togy_cascade_weapon"] = {
            description: "Deliberate detonation of a cascade weapon near the gravesite.",
		    severity: 3
        };
	}
}

//-------------------------------------------------------------------------------------------------------------
this.systemWillPopulate = function() {
    if (((galaxyNumber === 0 && system.ID === 124) || this._debug === true) && system.countShipsWithRole("togy_station") === 0) {
		var posTOGY = Vector3D(this._pos.x, this._pos.y, this._pos.z).fromCoordinateSystem("psm");
		system.setPopulator("togy-station", {
			callback: function(pos) {
				var sr = 1000;
				var tm = worldScripts.TOGY_Main;
				var stn = system.addShips("togy_station", 1, pos, 1)[0];
				// point station at planet for consistency
				stn.orientation = system.mainPlanet.position.subtract(stn.position).direction().rotationTo([0,0,1]);

				var x = tm._pos.x;
				var y = tm._pos.y;
				var z = tm._pos.z;
				system.addShips("togy-patrol", 4, Vector3D(x, y + 2000, z).fromCoordinateSystem("psm"), sr);
				system.addShips("togy-defence", 2, Vector3D(x, y + 2000, z).fromCoordinateSystem("psm"), sr);
				system.addShips("togy_grave_beacon", 1, Vector3D(x - 3400, y + 3000, z - 5800).fromCoordinateSystem("psm"), sr);
				system.addShips("togy_grave_beacon", 1, Vector3D(x + 3400, y + 3000, z - 5800).fromCoordinateSystem("psm"), sr);
				system.addShips("togy_grave_beacon", 1, Vector3D(x - 6600, y + 3000, z).fromCoordinateSystem("psm"), sr);
				system.addShips("togy_grave_beacon", 1, Vector3D(x + 6600, y + 3000, z).fromCoordinateSystem("psm"), sr);
				system.addShips("togy_grave_beacon", 1, Vector3D(x - 3400, y + 3000, z + 5600).fromCoordinateSystem("psm"), sr);
				system.addShips("togy_grave_beacon", 1, Vector3D(x + 3400, y + 3000, z + 5600).fromCoordinateSystem("psm"), sr);
				tm.$addInfoToGrave(system.addShips("grave_monument", 1, Vector3D(x, y + 3000, z).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 5, Vector3D(x, y + 3000, z - 700).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 5, Vector3D(x - 400, y + 3000, z - 400).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 5, Vector3D(x + 380, y + 3000, z - 400).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 5, Vector3D(x - 400, y + 3000, z - 3600).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 5, Vector3D(x + 160, y + 3000, z - 3600).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 5, Vector3D(x - 760, y + 3000, z).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 5, Vector3D(x + 760, y + 3000, z).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 5, Vector3D(x - 400, y + 3000, z + 400).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 5, Vector3D(x + 400, y + 3000, z + 400).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 5, Vector3D(x, y + 3000, z + 700).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 400, y + 3000, z - 3600).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 160, y + 3000, z - 3600).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 800, y + 3000, z - 3400).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 1200, y + 3000, z - 3000).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x, y + 3000, z + 2600).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 1360, y + 3000, z - 2400).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 1160, y + 3000, z - 2000).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 1380, y + 3000, z - 1800).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 200, y + 3000, z - 1700).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 760, y + 3000, z - 1660).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 2400, y + 3000, z - 1400).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 1800, y + 3000, z - 1400).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 3000, y + 3000, z - 1200).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 1200, y + 3000, z - 1200).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 380, y + 3000, z - 1200).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 340, y + 3000, z - 1200).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 1200, y + 3000, z - 1200).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 2000, y + 3000, z - 1040).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 3400, y + 3000, z - 800).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 800, y + 3000, z - 800).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 800, y + 3000, z - 800).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 1620, y + 3000, z + 1250).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 3600, y + 3000, z - 400).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 1200, y + 3000, z - 380).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 1200, y + 3000, z - 360).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 3600, y + 3000, z - 200).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 1740, y + 3000, z + 1600).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 3600, y + 3000, z + 120).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 1640, y + 3000, z + 200).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 1200, y + 3000, z + 300).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 1200, y + 3000, z + 360).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 3600, y + 3000, z + 400).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 1620, y + 3000, z + 700).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 800, y + 3000, z + 800).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 800, y + 3000, z + 800).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 3400, y + 3000, z + 800).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 2000, y + 3000, z + 1100).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 1200, y + 3000, z + 1200).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 300, y + 3000, z + 1200).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 340, y + 3000, z + 1200).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 1200, y + 3000, z + 1200).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 3000, y + 3000, z + 1200).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 1800, y + 3000, z + 1400).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 2400, y + 3000, z + 1400).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 640, y + 3000, z + 1600).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 200, y + 3000, z + 1680).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 1400, y + 3000, z + 1800).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 1100, y + 3000, z + 2000).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 1400, y + 3000, z + 2400).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 1200, y + 3000, z + 2800).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 800, y + 3000, z + 3400).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x - 200, y + 3000, z + 3600).fromCoordinateSystem("psm"), sr));
				tm.$addInfoToGrave(system.addShips("grave_monument", 3, Vector3D(x + 400, y + 3000, z + 3600).fromCoordinateSystem("psm"), sr));
			},
			location:"COORDINATES",
			coordinates:posTOGY,
			deterministic:true
		});
	}
}

//-------------------------------------------------------------------------------------------------------------
this.$addInfoToGrave = function(ships) {
	if (!ships || ships.length === 0) return;
	var bcc = worldScripts.BroadcastCommsMFD;
	if (!bcc) return;
	var tm = worldScripts.TOGY_Main;
	for (var i = 0; i < ships.length; i++) {
		if (Math.random() > 0.5 && tm._predefinedNames.length > 0) {
			// get the first element in the array, and remove it
			var item = tm._predefinedNames.shift();
			var nm = item.name;
			var born = new Date(Date.parse(item.born));
			var died = new Date(Date.parse(item.died));
		} else {
			// just generate a random name
			var end = Math.floor(Math.random() * 750 + 20); // how long ago did they die?
			// if this is a newer type ship, move the death date to be a bit closer to now
			if (ships[i].hasRole("togy_newship") === true) end = Math.floor(Math.random() * 20 + 20);
			var age = Math.floor(Math.random() * 70 + 20); // how old were they?
			// calc a date of death
			var died = new Date(3142 - end, Math.floor(Math.random() * 12), Math.floor(Math.random() * 27 + 1));
			// calc a birth date
			var born = new Date(died.getFullYear() - age, Math.floor(Math.random() * 12), Math.floor(Math.random() * 27 + 1));
			var nm = expandDescription("%N ") + expandDescription("[nom]");
		}
		ships[i].script._togy_info = expandDescription("[togy_memorial]", 
			{name:nm, born:tm.$getShortDate(born), died:tm.$getShortDate(died)}
		);
		// add a reply option
		tm._msgCount += 1;
		bcc.$createMessage({
			messageName:"togy_transmit_reply_" + tm._msgCount, 
			displayText:"[Query monument info]", 
			messageText:"",
			ship:ships[i],
			transmissionType:"target", 
			callbackFunction:tm.$transmitMonumentInfo,
			deleteOnTransmit:false, 
			delayCallback:1, 
			hideOnConditionRed:false}
		);
	}
}

//-------------------------------------------------------------------------------------------------------------
this.$transmitMonumentInfo = function() {
	var t = player.ship.target;
	if (!t || !t.script || t.script.hasOwnProperty("_togy_info") === false) return;
    t.commsMessage(t.script._togy_info, player.ship);
}

//-------------------------------------------------------------------------------------------------------------
this.$getShortDate = function(date) {
	return date.getDate() + " " + this.$monthName(date.getMonth()) + " " + date.getFullYear();
}

//-------------------------------------------------------------------------------------------------------------
this.$monthName = function(month) {
	switch (month) {
		case 0: return "Jan";
		case 1: return "Feb";
		case 2: return "Mar";
		case 3: return "Apr";
		case 4: return "May";
		case 5: return "Jun";
		case 6: return "Jul";
		case 7: return "Aug";
		case 8: return "Sep";
		case 9: return "Oct";
		case 10: return "Nov";
		case 11: return "Dec";
	}
}