this.name			= "GalTech_chimera_gunship";
this.author			= "Montana05";
this.description	= "event handler for chimera gunship OXP";
this.version		= "1.12";
this.copyright		= "2020 Montana05";
this.licence   		= "CC BY-NC-SA 4.0";
"use strict";

// new features for Chimera Gunship (will be removed if Shipbuilder disagrees):

this.shipSpawned = function(ship)
{
	this.$GalTech_shipType = this.ship.dataKey;
	var dice = 0;
	
	if(this.ship.hasRole("escape-capsule"))
	{
		// neutral inits first
		var $GalTech_crewName = expandDescription("[nom]");
		var $GalTech_description = "a crew member of an evacuated ship";
		var $GalTech_crewRole = "hunter";  // not perfect but somewhere in the middle
		var $GalTech_crewRace = expandDescription("[GalTech_GalCop_races]");  // added a race to the crew members
		
		// now it's time to be more specific, based on an estimated crew of up to 5 person
		// every individual without insurance or bounty will be defined as a slave
		switch(this.$GalTech_shipType) 
		{
			case "GalTech_chimera_gunship_escape_pod":
			
				this.$GalTech_chimera_gunship_crew_ranks_Array = 
				["Gunner", "Communications Operator", "Sensor Operator", "Engineer", "Astrogator", "Pilot", "Commander"];
				var $GalTech_crewRanks = 
				$GalTech_chimera_gunship_crew_ranks_Array[Math.floor(Math.random() * $GalTech_chimera_gunship_crew_ranks_Array.length)];
			
				$GalTech_crewName = ("the " + $GalTech_crewRace + " " + $GalTech_crewRanks + " " + expandDescription("[nom]"));
				$GalTech_description = "a ship crew member";
				$GalTech_crewRole = "trader"; 	
		
				dice = this.$getRndInteger(1, 5);
		
				// added some diversity
				if(dice > 2)
				{
					$GalTech_CrewRole = "hunter";
				};

				// once in a while there are passengers as well
				if(dice > 4)
				{
					$GalTech_crewName = "the " + $GalTech_crewRace + " " + expandDescription("[nom]");
					$GalTech_description = "a interstellar passenger";
					$GalTech_crewRole = "passenger";
				};
				break;
			
			case "GalTech_chimera_gunship_escape_pod_police":
				
				this.$GalTech_chimera_gunship_police_ranks_Array = 
				["Ensign", "Space Junior Lieutenant", "Space Lieutenant", "Lt. Commander"];
				var $GalTech_policeRank = 
				$GalTech_chimera_gunship_police_ranks_Array[Math.floor(Math.random() * $GalTech_chimera_gunship_police_ranks_Array.length)];
			
				$GalTech_crewName = ("the " + $GalTech_crewRace + " " + $GalTech_policeRank + " " + expandDescription("[nom]"));
				$GalTech_description = "a crew member of a space police ship";
				$GalTech_crewRole = "police"; 		
				break;
			
			case "GalTech_chimera_gunship_escape_pod_pirate":
				
				$GalTech_crewName = 
				("the " + $GalTech_crewRace + " " + expandDescription("[GalTech_pirate_nicknames]") + expandDescription("[nom]"));
				
				$GalTech_description = "a criminal wanted by GalCop police";
				$GalTech_crewRole = "pirate";
				break;	
			
			default: 
				break;			
		};

		this.ship.setCrew
		(
			{
				name: $GalTech_crewName,
				short_description: $GalTech_description,
				role: $GalTech_crewRole,
				species: $GalTech_crewRace
			}
		);
	}
	else
	{
		var $GalTech_shipRole = this.ship.primaryRole;
		
		// if the ship got no cargo some containers are added
		if(this.ship.cargoSpaceUsed === 0)
		{
			switch($GalTech_shipRole) 
			{
				case "trader-smuggler":
				case "pirate":
				// individual role of the ship, will only be called from other OXP's	
				case "chimera-pirate":	
					
					this.ship.setCargoType("ILLEGAL_GOODS");
					break;
					
				case "trader":
				case "escort":
				case "escort-heavy":
				case "hunter":
				case "hunter-heavy":
				// individual roles per ship, will only be called from other OXP's	
				case "chimera":
				case "chimera_alt":	
				case "chimera_alt_team_01":
					
					dice = this.$getRndInteger(1, 2);
						
					// added some diversity
					if(dice === 1)
						this.ship.setCargoType("SCARCE_GOODS");

					if(dice === 2)
						this.ship.setCargoType("PLENTIFUL_GOODS");
					break;
					
				// police most likely will have weapons, not goods
				case "police":
				case "wingman":
				// individual role of the ship, will only be called from other OXP's	
				case "chimera-police":	
					
					dice = this.$getRndInteger(1, 10);
					this.ship.adjustCargo("firearms", dice);
					break;

				default: 
					break;
			};
		};
	};
};

this.shipDied = function(whom, why)
{
	if(this.ship.hasRole("escape-capsule"))
	{
		return;
	}
	else
	{
		// neutral inits first
		var $GalTech_podType = "escape-capsule";
		var debrisCount = this.$getRndInteger(1, 3); // for pods
		var $GalTech_cargoLoad = this.ship.cargoSpaceUsed;

		this.ship.commsMessage(expandDescription("[chimera-plea]"), player.ship);
		
		// time to eject the escape pods
		if(this.ship.bounty > 7 || this.$GalTech_shipType == "chimera-pirate")
		{
			$GalTech_podType = "GalTech_chimera_gunship_escape_pod_pirate";
		}		
		else
		{
			switch(this.$GalTech_shipType) 
			{
				case "chimera":
				case "chimera_alt":
				case "chimera_alt_team_01":	

					$GalTech_podType = "GalTech_chimera_gunship_escape_pod";
					break;

				case "chimera-police":
					
					$GalTech_podType = "GalTech_chimera_gunship_escape_pod_police";	
					break;

				default: 
					break;
			};
		}	
				
		system.addShips($GalTech_podType, debrisCount, this.ship.position);
					
		debrisCount = this.$getRndInteger(6, 10);
		// added explosive shrapnels similar to Constitution Class Heavy Cruiser
		system.addShips("GalTech_effects_explosive_shrapnel", debrisCount, this.ship.position);
		// added various depris as a new feature
		system.addShips("GalTech_ship_debris", debrisCount, this.ship.position);
		
		// added burning fuel as a new feature
		debrisCount = (this.ship.fuel.toFixed(0)) * 2;	
		system.addShips("GalTech_effects_burningFuel", debrisCount, this.ship.position);

		// added some cargopods as a new feature
		if($GalTech_cargoLoad > 0)
		{
			var cargoIndex = this.ship.cargoList;
			var cargoTotal = 0;
			var debrisCount = 0;

			// calculate all containers from ship.cargoList
			for (var i = cargoIndex.length - 1 ; i >= 0 ; --i)
			{
				cargoTotal = cargoTotal + this.ship.cargoList[i].quantity;
			};

			// shouldn't happen but better save than sorry
			if(cargoTotal > $GalTech_cargoLoad)
				$GalTech_cargoLoad = cargoTotal;

			debrisCount = this.$getRndInteger(1, $GalTech_cargoLoad);	
			
			// time to eject cargopods
			for(var i = cargoIndex.length - 1 ; i >= 0 ; --i)
			{
				var cargoType = this.ship.cargoList[i].commodity;
				var cargoPod = ("GalTech_container_" + cargoType);
				var cargoCount = this.ship.cargoList[i].quantity;
				
				if(debrisCount > 0 && debrisCount < cargoCount)
					debrisCount = cargoCount;
				
				// ejects a random number of cargopods
				// Warning: additional commodities from an OXP are not covered (exceptions: witchfire_whiskey, holy_artifacts)
				while(cargoCount > 0 && debrisCount > 0)
				{
					this.ship.ejectSpecificItem(cargoPod);
					cargoCount = cargoCount - 1;
					debrisCount = debrisCount - 1;
				};
			};
		};
	};
};	

this.$getRndInteger = function(min, max)
{
	return Math.floor(Math.random() * (max - min + 1) ) + min;
};
