"use strict";

    this.name = "Wildeblood Manor";

    this._affectedGalaxy  = 0;
    this._affectedSystem  = 100;
    this._backgroundImage = "distant_space_wildeblood_manor.png";
    this._imageHeight     = 512;

    this._showImage = false;

    this.infoSystemChanged = function (to, from) {
        if (to === this._affectedSystem &&
            system.ID !== this._affectedSystem &&
            galaxyNumber === this._affectedGalaxy) {
            this._showImage = true;
            // Setting radius to 0 hides the animated planet image,
            // so we can see the background image better.
            System.infoForSystem(galaxyNumber, to).radius = 0;
        }
    };

    this.guiScreenChanged = function (to, from) {
        if (from === "GUI_SCREEN_SYSTEM_DATA" &&
            this._showImage) {
            System.infoForSystem(this._affectedGalaxy, this._affectedSystem).radius = null; // Unset the 0.
            this._showImage = false;
            return;
        }
        if (to === "GUI_SCREEN_SYSTEM_DATA" &&
            guiScreen === "GUI_SCREEN_SYSTEM_DATA" &&
            this._showImage) {
            // The setScreenBackground method is a temporary over-ride, which resets as soon as
            // the player changes screens, we don't need to do anything to reset it.
            setScreenBackground({ name: (this._backgroundImage), height: (this._imageHeight) });
        }
    };

    this.startUp = function () {
        if (missionVariables.WildebloodManor_galaxy !== undefined) {
            this._affectedGalaxy = parseInt(missionVariables.WildebloodManor_galaxy, 10);
        }
        if (missionVariables.WildebloodManor_system !== undefined) {
            this._affectedSystem = parseInt(missionVariables.WildebloodManor_system, 10);
        }
        if (missionVariables.WildebloodManor_image !== undefined) {
            this._backgroundImage = missionVariables.WildebloodManor_image;
        }
        if (missionVariables.WildebloodManor_height !== undefined) {
            this._imageHeight = parseInt(missionVariables.WildebloodManor_height, 10);
        }
        delete this.startUp;
    };

    this.playerWillSaveGame = function () {
        // Save the affected galaxy to mission variables
        missionVariables.WildebloodManor_galaxy = this._affectedGalaxy.toString();

        // Save the affected system to mission variables
        missionVariables.WildebloodManor_system = this._affectedSystem.toString();

        // Save the background image filename to mission variables
        missionVariables.WildebloodManor_image = this._backgroundImage;

        // Save the image height to mission variables
        missionVariables.WildebloodManor_height = this._imageHeight.toString();
    };
