"use strict";
this.name = "DisplayCurrentCourse";
this.author = "phkb";
this.copyright = "2015 phkb";
this.description = "Routines for adding the players current course to the galactic map when also showing a contract course.";
this.licence = "CC BY-NC-SA 4.0";

this._debug = false;
this._currentRoute = null;
this._currentTarget = null;
this._currentRouteMode = "";
this._marked = false;
this._screenIDList = [
	"oolite-contracts-parcels-details", 
	"oolite-contracts-passengers-details", 
	"oolite-contracts-cargo-details",
	"oolite-damagereport-detail-map", 
	"damage_report_detail", 
	"oolite-galcopsecoffice-screen4-map", 
	"oolite-galcopsecoffice-screen8-map", 
	"oolite-smuggling-contracts-map", 
	"smuggling-contracts-details",
	"rrs_mission_map", 
	"blackmonks-map", 
	"ups-map", 
	"escort-contracts", 
	"random_hits_map"
];
this._refresh = null;
this._holdDestination = -1;
this._colorList = [
	"greenColor", 
	"redColor", 
	"blueColor", 
	"orangeColor", 
	"purpleColor", 
	"whiteColor", 
	"magentaColor"
];
this._color = 0;
this._libSettings = {
	Name: this.name,
	Display: "UI Settings",
	Alias: "Display Current Course",
	Alive: "_libSettings",
	SInt: {
		S0: {
			Name: "_color",
			Def: 0,
			Min: 0,
			Max: 6,
			Desc: "Link Color"
		},
		Info: "0 = green, 1 = red, 2 = blue, 3 = orange, 4 = purple, 5 = white, 6 = magenta"
	},
};

// IDEA: Include course plot info from any contracts currently in play

//-------------------------------------------------------------------------------------------------------------
this.startUpComplete = function () {
	if (worldScripts.Lib_Config) {
		if (missionVariables.DCC_LinkColor) this._color = parseInt(missionVariables.DCC_LinkColor);
		worldScripts.Lib_Config._registerSet(this._libSettings);
	}

	// make sure we get a copy of the player's target system after a game load
	if (player.ship.targetSystem >= 0) this._holdDestination = player.ship.targetSystem;
}

//-------------------------------------------------------------------------------------------------------------
this.playerWillSaveGame = function () {
	if (worldScripts.Lib_Config) {
		missionVariables.DCC_LinkColor = this._color;
	}
}

//-------------------------------------------------------------------------------------------------------------
this.guiScreenChanged = function (to, from) {
	if (guiScreen != "GUI_SCREEN_LONG_RANGE_CHART" && guiScreen != "GUI_SCREEN_SHORT_RANGE_CHART" && (from == "GUI_SCREEN_LONG_RANGE_CHART" || from == "GUI_SCREEN_SHORT_RANGE_CHART")) {
		if (this._marked) this.$unmarkSystems();
		// grab a copy of the player's destination set on the galactic chart
		this._holdDestination = player.ship.targetSystem;
		this._currentTarget = null;
	}

	if (guiScreen == "GUI_SCREEN_MISSION") {
		var p = player.ship;
		if (p.equipmentStatus("EQ_ADVANCED_NAVIGATIONAL_ARRAY") == "EQUIPMENT_OK") {
			// if the route mode is set to "NONE", jump out now.
			if (p.routeMode == "OPTIMIZED_BY_NONE") {
				// make sure we don't get a residue from previous visits to the galactic chart
				if (this._marked) this.$unmarkSystems();
				return;
			}
			// if we don't yet have a target set, get a copy now.
			if (this._currentTarget == null && this._holdDestination != -1) {
				if (this._debug) log(this.name, "setting current target details");
				this._currentTarget = this._holdDestination;
				this._currentRouteMode = p.routeMode;
				if (this._debug) log(this.name, "A: curr " + system.ID + ", curr dest " + this._currentTarget + ", route mode " + this._currentRouteMode + ", route length " + (this._currentRoute && this._currentRoute.route.length > 0 ? this._currentRoute.route.length : 0));
			}
			// if the screen ID mataches one in our list, then we can add the system links in now
			if (this._screenIDList.indexOf(mission.screenID) >= 0 && this._marked == false) {
				if (this._refresh && this._refresh.isRunning) this._refresh.stop();
				var info = System.infoForSystem(galaxyNumber, this._currentTarget);
				this._currentRoute = system.info.routeToSystem(info, this._currentRouteMode);
				if (this._debug) log(this.name, "B: curr " + system.ID + ", curr dest " + this._currentTarget + ", route mode " + this._currentRouteMode + ", route length " + (this._currentRoute && this._currentRoute.route.length > 0 ? this._currentRoute.route.length : 0));
				if (this._currentRoute && this._currentRoute.route.length > 1) {
					for (var i = 0; i < this._currentRoute.route.length - 1; i++) {
						if (this._currentRoute.route[i] < this._currentRoute.route[i + 1]) {
							SystemInfo.setInterstellarProperty(galaxyNumber, this._currentRoute.route[i], this._currentRoute.route[i + 1], 2, "link_color", this._colorList[this._color]);
						} else {
							SystemInfo.setInterstellarProperty(galaxyNumber, this._currentRoute.route[i + 1], this._currentRoute.route[i], 2, "link_color", this._colorList[this._color]);
						}
					}
					this._marked = true;
				}
			}
			if (this._screenIDList.indexOf(mission.screenID) == -1) {
				// this is a bit of a hack to cope with mission screens that actually set the player's target system as part of their actions
				// start a timer to reset the marked system
				if (!this._refresh || this._refresh.isRunning == false) this._refresh = new Timer(this, this.missionScreenEnded, 0.25, 0);
			}
		}
	}
}

//-------------------------------------------------------------------------------------------------------------
this.missionScreenEnded = function () {
	if (this._marked == true) this.$unmarkSystems();
	// reset the holding destination in case a mission screen updated it
	this._holdDestination = player.ship.targetSystem;
}

//-------------------------------------------------------------------------------------------------------------
this.shipWillEnterWitchspace = function (cause) {
	if (cause == "galactic jump") {
		this.$unmarkSystems();
		this._holdDestination = -1;
	}
}

//-------------------------------------------------------------------------------------------------------------
this.$unmarkSystems = function $unmarkSystems () {
	if (this._currentRoute) {
		for (var i = 0; i < this._currentRoute.route.length - 1; i++) {
			if (this._currentRoute.route[i] < this._currentRoute.route[i + 1]) {
				SystemInfo.setInterstellarProperty(galaxyNumber, this._currentRoute.route[i], this._currentRoute.route[i + 1], 2, "link_color", null);
			} else {
				SystemInfo.setInterstellarProperty(galaxyNumber, this._currentRoute.route[i + 1], this._currentRoute.route[i], 2, "link_color", null);
			}
		}
	}
	this._currentTarget = null;
	this._currentRoute = null;
	this._currentRouteMode = "";
	this._marked = false;
}