"use strict";
this.name = "XenonReduxUI_Compatibility";
this.author = "phkb";
this.copyright = "2021 phkb";
this.description = "OXP Compatibility function overrides";
this.license = "CC BY-NC-SA 3.0";

this.startUp = function () {
    // if xenon UI is also installed, then let it do this work.
    if (worldScripts.XenonUI) return;

    // make Ship's library compatible
    if (worldScripts["Ships Library"] && worldScripts["Ships Library"].version == "0.8") {
        var sl = worldScripts["Ships Library"];
        sl._showPage = this._showPage;
    }
    // make sothis tc compatible
    if (worldScripts.sothis_tc && worldScripts.sothis_tc.version == "1.0.3") {
        var stc = worldScripts.sothis_tc;
        stc.missionScreenOpportunity = this._sothis_missionScreenOpportunity;
    }
    // make New Cargoes compatible
    if (worldScripts["CargoTypeExtension-Auctions"] && worldScripts["CargoTypeExtension-Auctions"].version == "1.2.3") {
        worldScripts["CargoTypeExtension-Auctions"].runOffer = this._auctions_runOffer;
        worldScripts["CargoTypeExtension-Auctions"].endAuction = this._auctions_endAuction;
        worldScripts["CargoTypeExtension-Auctions"].playSantaariAuction = this.playSantaariAuction;
        worldScripts["CargoTypeExtension-Auctions"].playAngianaAuction = this.playAngianaAuction;
        worldScripts["CargoTypeExtension-Auctions"].playColesqueAuction = this.playColesqueAuction;
        worldScripts["CargoTypeExtension-Auctions"].playJaftraAuction = this.playJaftraAuction;
        worldScripts["CargoTypeExtension-Auctions"].playLaratanAuction = this.playLaratanAuction;
        worldScripts["CargoTypeExtension-Auctions"].playProximusAuction = this.playProximusAuction;
        worldScripts["CargoTypeExtension-Auctions"].playSolansAuction = this.playSolansAuction;
        worldScripts["CargoTypeExtension-Auctions"].playXrataAuction = this.playXrataAuction;
        worldScripts["CargoTypeExtension"].startTrading = this.startTrading;
        worldScripts["CargoTypeExtension"].showBuyScreen = this.showBuyScreen;
        worldScripts["CargoTypeExtension"].showNoBuyScreen = this.showNoBuyScreen;
        worldScripts["CargoTypeExtension"].showSellScreen = this.showSellScreen;
        worldScripts["CargoTypeExtension"].showNoSellScreen = this.showNoSellScreen;
        worldScripts["CargoTypeExtension"].gatherInformation = this.gatherInformation;
        worldScripts["CargoTypeExtension"].gatherInformation2 = this.gatherInformation2;
        worldScripts["CargoTypeExtension"].tradeFloor = this.tradeFloor;
        worldScripts["CargoTypeExtension"].tradeFloorEncounter = this.tradeFloorEncounter;
        worldScripts["CargoTypeExtension"].detailedManifest = this.detailedManifest;
        worldScripts["CargoTypeExtension"].permitListing = this.permitListing;
        worldScripts["CargoTypeExtension"].readTraderNet = this.readTraderNet;
        worldScripts["CargoTypeExtension-FetchContracts"].runNewOffer = this.runNewOffer;
        worldScripts["CargoTypeExtension-FetchContracts"].newOfferChoice = this.newOfferChoice;
        worldScripts["CargoTypeExtension-FetchContracts"].runOldOffer = this.runOldOffer;
        worldScripts["CargoTypeExtension-FetchContracts"].oldOfferChoice = this.oldOfferChoice;
        worldScripts["CargoTypeExtension-OpenContract"].runOffer = this._contract_runOffer;
        worldScripts["CargoTypeExtension-OpenContract"].dealOpenC = this.dealOpenC;
        worldScripts["CargoTypeExtension-OpenContract"].openContractWin = this.openContractWin;
        worldScripts["CargoTypeExtension-OpenContract"].openContractLose = this.openContractLose;
        worldScripts["CargoTypeExtension-Permits"].runOffer = this._permits_runOffer;
        worldScripts["CargoTypeExtension-Permits"].permitDealings = this.permitDealings;
        worldScripts["CargoTypeExtension-Scavenger"].runOffer = this._scavenger_runOffer;
        worldScripts["CargoTypeExtension-Scavenger"].dealScavenger = this.dealScavenger;
    }
    // make Iron Raven compatible
    if (worldScripts["IR-main-script.js"] && worldScripts["IR-main-script.js"].version == "1.4.2.1") {
        worldScripts["IR-main-script.js"].questionScreens = this.questionScreens;
        worldScripts["IR-main-script.js"].shipDockedWithStation = this._ir_shipDockedWithStation;
        worldScripts["IR-main-script.js"].missionScreens = this.missionScreens;
        worldScripts["IR-main-script.js"].choiceEvaluation = this.choiceEvaluation;
    }
}

//-------------------------------------------------------------------------------------------------------------
// to make Ships Library compatible
this._showPage = function () {
    var chapter = this.$contents[this.$chapter];

    var text = this._textFromOffset(this.$chapter, this.$offset, this.$msStore, this.$msRows, this.$msCols);

    var opts = {
        screenID: "ships-library",
        titleKey: chapter.key + "-title",
        allowInterrupt: true,
        exitScreen: "GUI_SCREEN_INTERFACES",
        choices: {
            "01_PREV": expandMissionText("ships-library-page-back"),
            "09_NEXT": expandMissionText("ships-library-page-next"),
            "10_CONTENTS": expandMissionText("ships-library-contents"),
            "99_EXIT": expandMissionText("ships-library-exit"),
        },
        initialChoicesKey: this.$lastchoice ? this.$lastchoice : "09_NEXT",
        message: text
    };
    if (chapter.opts) {
        var extras = Object.keys(chapter.opts)
        for (var k = 0; k < extras.length; k++) {
            opts[extras[k]] = chapter.opts[extras[k]];
        }
    }
    if (chapter.backgrounds) {
        var page = this._pageOfOffset(chapter, this.$offset, this.$msStore);
        if (page < chapter.backgrounds.length) {
            var backg = chapter.backgrounds[page];
        } else {
            var backg = chapter.backgrounds[chapter.backgrounds.length - 1];
        }
        if (backg != "") {
            opts.overlay = backg;
        }
    }

    mission.runScreen(opts, this._manualHandler, this);
    this.$fcbM = addFrameCallback(this._moveShip.bind(this));

}

//-------------------------------------------------------------------------------------------------------------
// to make Sothis TC compatible
this._sothis_missionScreenOpportunity = function () {
    if (!this.$showWelcome) return;
    var messText = expandDescription("[STC_welcome]");
    if (this.$new_cargoes)
        messText = messText + expandDescription("[STC_new_cargoes]");
    var tcbgpic = "OOmap_G" + (galaxyNumber + 1) + ".png";
    mission.runScreen({
        title: "Sothis Trade Center",
        message: messText,
        overlay: tcbgpic
    });
    this.$showWelcome = false;
}

//-------------------------------------------------------------------------------------------------------------
// to make New Cargoes compatible
this._auctions_runOffer = function () {
    var auc = this.activeAuction();
    var msg = "Welcome, Trader. Bidding doesn't start until " + clock.clockStringForTime(auc.time) + ", so feel free to get your ship and credit ready before we start. We've got " + auc.quantity + " TC of " + worldScripts["CargoTypeExtension"].cargoDefinition(auc.cargo, "specificType") + " to sell.\n\nRemember, you must have sufficient cargo space to take the goods, and cover all fees and bids from your current credits.\n\nWe'll be using " + this.auctionTypeName(auc.atype) + " bidding:\n" + expandDescription("[cte_auc_rules" + auc.atype + "]");
    mission.runScreen({
        title: this.traderName(),
        message: msg,
        overlay: "cte_auction.png",
        choicesKey: "cte_auc_opening"
    }, this.checkAuction, this);
}

this._auctions_endAuction = function () {
    mission.runScreen({
        title: "Auction over",
        overlay: "cte_auction.png",
        message: this.auctionmessage + "\nThe auction is over."
    });
    this.localAuctioneer();
}

this.playSantaariAuction = function () {
    if (this.currentauction.quantity < 1) {
        this.endAuction();
    } else {
        var title = this.currentauction.quantity + " TC of " + worldScripts["CargoTypeExtension"].cargoDefinition(this.currentauction.cargo, "specificType");
        var msg = "Auction: Santaari (" + this.blockSize(this.currentauction) + " TC blocks)\n";
        if (this.auctionmessage != "") {
            msg += "* " + this.auctionmessage + "\n";
            this.auctionmessage = "";
        }
        msg += this.auctionStatus();
        mission.runScreen({
            title: title,
            overlay: "cte_auction.png",
            message: msg,
            choicesKey: "cte_auc_santaari_bid"
        }, this.choiceSantaariAuction, this);
    }
}

this.playColesqueAuction = function () {
    if (this.currentauction.quantity < 1) {
        this.endAuction();
    } else {
        var title = this.currentauction.quantity + " TC of " + worldScripts["CargoTypeExtension"].cargoDefinition(this.currentauction.cargo, "specificType");
        var msg = "Auction: Colesque (minimum increment " + this.colesqueIncrement(this.currentbid) + "₢)\n";
        if (this.auctionmessage != "") {
            msg += "* " + this.auctionmessage + "\n";
            this.auctionmessage = "";
        }
        msg += this.auctionStatus();
        mission.runScreen({
            title: title,
            overlay: "cte_auction.png",
            message: msg,
            choicesKey: "cte_auc_colesque_bid"
        }, this.choiceColesqueAuction, this);
    }
}

this.playLaratanAuction = function () {
    if (this.lastcall == 6) {
        this.endLaratanAuction();
    } else {
        var title = this.currentauction.quantity + " TC of " + worldScripts["CargoTypeExtension"].cargoDefinition(this.currentauction.cargo, "specificType");
        var msg = "You: " + player.ship.cargoSpaceAvailable + " TC free, " + player.credits.toFixed(1) + "₢ available\n";
        msg += "Auction: Lara'tan (ticket price " + this.currentbid + "₢)\n";
        msg += "Round " + this.lastcall + "/5\n";

        msg += "-----------------------------------\n";
        for (var i = 0; i < this.currentbidders.length; i++) {
            var line = this.currentbidders[i].name + ": ";
            if (this.currentbidders[i].lastbid == 0) {
                line += "no bid";
            } else {
                line += this.currentbidders[i].lastbid + " ticket(s)";
            }
            line += "\n";
            msg += line;
        }
        var line = "Commander " + player.name + ": ";
        if (this.playerbid == 0) {
            line += "no bid";
        } else {
            line += this.playerbid + " ticket(s)";
        }
        line += "\n";
        msg += line;

        mission.runScreen({
            title: title,
            overlay: "cte_auction.png",
            message: msg,
            choicesKey: "cte_auc_laratan_bid"
        }, this.choiceLaratanAuction, this);
    }
}

this.playAngianaAuction = function () {
    if (this.currentauction.quantity < 1) {
        this.endAuction();
    } else {
        var title = this.currentauction.quantity + " TC of " + worldScripts["CargoTypeExtension"].cargoDefinition(this.currentauction.cargo, "specificType");
        var msg = "Auction: Angiana (minimum increment " + this.colesqueIncrement(this.currentbid) + "₢, buyout " + this.angianaBuyout() + "₢/TC)\n";
        if (this.auctionmessage != "") {
            msg += "* " + this.auctionmessage + "\n";
            this.auctionmessage = "";
        }
        msg += this.auctionStatus();
        mission.runScreen({
            title: title,
            overlay: "cte_auction.png",
            message: msg,
            choicesKey: "cte_auc_angiana_bid"
        }, this.choiceAngianaAuction, this);
    }
}

this.playProximusAuction = function () {
    if (this.currentauction.quantity < 1) {
        this.endAuction();
    } else {
        var title = this.currentauction.quantity + " TC of " + worldScripts["CargoTypeExtension"].cargoDefinition(this.currentauction.cargo, "specificType");
        var msg = "Auction: Proximus (minimum increment " + this.colesqueIncrement(this.currentbid) + "₢)\n";
        if (this.auctionmessage != "") {
            msg += "* " + this.auctionmessage + "\n";
            this.auctionmessage = "";
        }
        msg += this.auctionStatus();
        mission.runScreen({
            title: title,
            overlay: "cte_auction.png",
            message: msg,
            choicesKey: "cte_auc_proximus_bid"
        }, this.choiceProximusAuction, this);
    }
}

this.playSolansAuction = function () {
    if (this.currentauction.quantity < 1) {
        this.endAuction();
    } else {
        var title = this.currentauction.quantity + " TC of " + worldScripts["CargoTypeExtension"].cargoDefinition(this.currentauction.cargo, "specificType");
        var msg = "Auction: Solans (increment " + this.colesqueIncrement(this.currentbid) + "₢)\n";
        if (this.auctionmessage != "") {
            msg += "* " + this.auctionmessage + "\n";
            this.auctionmessage = "";
        }
        msg += this.auctionStatus();
        mission.runScreen({
            title: title,
            overlay: "cte_auction.png",
            message: msg,
            choicesKey: "cte_auc_solans_bid"
        }, this.choiceSolansAuction, this);
    }
}

this.playJaftraAuction = function () {
    if (this.currentauction.quantity < 1) {
        this.endAuction();
    } else {
        var title = this.currentauction.quantity + " TC of " + worldScripts["CargoTypeExtension"].cargoDefinition(this.currentauction.cargo, "specificType");
        var msg = "Auction: Jaftra\n";
        if (this.auctionmessage != "") {
            msg += "* " + this.auctionmessage + "\n";
            this.auctionmessage = "";
        }
        msg += this.auctionStatus();
        mission.runScreen({
            title: title,
            overlay: "cte_auction.png",
            message: msg,
            choicesKey: "cte_auc_jaftra_bid"
        }, this.choiceJaftraAuction, this);
    }
}

this.playXrataAuction = function () {
    if (this.currentauction.quantity < 1) {
        this.endAuction();
    } else {
        var title = this.currentauction.quantity + " TC of " + worldScripts["CargoTypeExtension"].cargoDefinition(this.currentauction.cargo, "specificType");
        var msg = "Auction: Xrata (minimum increment " + this.colesqueIncrement(this.currentbid) + "₢)\n";
        if (this.auctionmessage != "") {
            msg += "* " + this.auctionmessage + "\n";
            this.auctionmessage = "";
        }
        msg += this.auctionStatus();
        mission.runScreen({
            title: title,
            overlay: "cte_auction.png",
            message: msg,
            choicesKey: "cte_auc_xrata_bid"
        }, this.choiceXrataAuction, this);
    }
}

this.startTrading = function () {
    var choices = "cte_initscreenchoice";
    if (missionVariables.cargotypeextension_tradernet && missionVariables.cargotypeextension_tradernet >= clock.days) {
        choices = "cte_initscreenchoice_wtn";
    }

    mission.runScreen({
            title: "Specialist Trade Goods Market",
            message: this.showManifest(),
            overlay: "cte_containers.png",
            choicesKey: choices
        },
        this.initScreenChoice, this);
}

this.showNoBuyScreen = function () {
    mission.runScreen({
            title: "Buy Specialist Trade Goods",
            overlay: "cte_containers.png",
            message: "No specialist trade goods available for purchase"
        },
        this.startTrading, this);
}

this.showBuyScreen = function () {
    var goods = this.stationMarket[this.pointer];

    mission.runScreen({
            title: "Buy " + this.specialCargoRegister[goods.type].specificType,
            overlay: "cte_containers.png",
            message: this.buyMessage(goods),
            choicesKey: "cte_buyscreenchoice",
            initialChoicesKey: this.lastscreenchoice
        },
        this.handleBuyDecision, this);
}

this.showNoSellScreen = function () {
    mission.runScreen({
            overlay: "cte_containers.png",
            title: "Sell Specialist Trade Goods",
            message: "No specialist trade goods in hold"
        },
        this.startTrading, this);
}

this.showSellScreen = function () {
    var goods = this.holdgoods[this.pointer];
    mission.runScreen({
            overlay: "cte_containers.png",
            title: "Sell " + this.specialCargoRegister[goods].specificType,
            message: this.sellMessage(goods),
            choicesKey: "cte_sellscreenchoice",
            initialChoicesKey: this.lastscreenchoice
        },
        this.handleSellDecision, this);
}

this.gatherInformation = function () {
    mission.runScreen({
            title: "Local imports/exports",
            overlay: "cte_tradefloor.png",
            message: this.localTradeGoods()
        },
        this.gatherInformation2, this);
}

this.gatherInformation2 = function () {
    mission.runScreen({
            title: "Gossip in the trade district",
            overlay: "cte_tradefloor.png",
            message: this.localGossip()
        },
        this.startTrading, this);
}

this.tradeFloor = function () {
    var choice = "cte_tradefloorchoice";
    this.debug("Building trade floor");
    var traders = new Array;
    var srole = "";
    if (player.ship.dockedStation != system.mainStation) {
        var srole = player.ship.dockedStation.primaryRole;
    }
    for (var i = 0; i < this.personalities.length; i++) {
        if (worldScripts[this.personalities[i]].traderHere && worldScripts[this.personalities[i]].traderHere(srole)) {
            traders.push(this.personalities[i]);
            this.debug(this.personalities[i] + " is present");
        }
    }
    if (traders.length == 0) {
        this.tradeflooractive = 0;
        mission.runScreen({
                title: "No-one about",
                overlay: "cte_tradefloor.png",
                message: "The trade floor is deserted."
            },
            this.startTrading, this
        );
    } else {
        if (traders.length == 1) {
            choice = "cte_tradeflooronlychoice";
        }
        this.tradeFloorEncounter(traders[this.tradefloorpointer % traders.length], choice);
    }
}

this.tradeFloorEncounter = function (traderscript, choice) {
    var title = worldScripts[traderscript].traderName();
    var desc = worldScripts[traderscript].traderDesc();

    this.traderscript = traderscript;
    mission.runScreen({
        title: title,
        overlay: "cte_tradefloor.png",
        message: desc,
        choicesKey: choice
    }, this.tradeFloorChoice, this);
}

this.detailedManifest = function () {
    var manlines = this.detailedManifestLines();
    var maxlines = 15;
    if (manlines.length <= maxlines) {
        mission.runScreen({
                title: "Detailed Manifest",
                overlay: "cte_containers.png",
                message: this.viewDetailedManifest(manlines, 0, maxlines),
                choicesKey: "cte_manifestlast"
            },
            this.startTrading, this);
    } else {
        var pages = 1 + Math.floor((manlines.length - 1) / maxlines);
        var cpage = 1 + Math.floor((this.dmanoffset) / maxlines);
        var fn = this.startTrading;
        var choice = "cte_manifestlast";
        if (this.dmanoffset + maxlines < manlines.length) {
            fn = this.detailedManifest;
            var choice = "cte_manifestnext";
        }
        mission.runScreen({
                title: "Detailed Manifest (" + cpage + "/" + pages + ")",
                overlay: "cte_containers.png",
                message: this.viewDetailedManifest(manlines, this.dmanoffset, maxlines),
                choicesKey: choice
            },
            fn, this);

        this.dmanoffset += maxlines;
    }
}

this.permitListing = function () {
    var msg = "";
    for (var k = 0; k < this.permits.length; k++) {
        this.debug("Trying " + this.permits[k]);
        msg += worldScripts[this.permits[k]].describePermits();
    }
    for (var k = 0; k < this.personalities.length; k++) {
        this.debug("Trying " + this.personalities[k]);
        msg += worldScripts[this.personalities[k]].describeContracts();
    }

    if (msg == "") {
        msg = "You have no permits or active contracts, and no local regulations apply to trading.";
    }
    mission.runScreen({
            title: "Permits, Contracts and Regulations",
            overlay: "cte_permit.png",
            message: msg
        },
        this.startTrading, this);
}

this.readTraderNet = function () {
    var background = worldScripts["CargoTypeExtension-TraderNet"].getPic();
    var messages = worldScripts["CargoTypeExtension-TraderNet"].numMessages();
    if (messages == 0) {
        mission.runScreen({
                title: "TraderNet News",
                overlay: background,
                message: "\n\n\n\n\n\n\n\nNo news available.",
                choicesKey: "cte_tradernet_last"
            },
            this.startTrading, this);
    } else {
        if (this.tradernetpointer >= messages) {
            var article = worldScripts["CargoTypeExtension-TraderNet"].getMessage(messages);
            var ckey = "cte_tradernet_last";
        } else {
            var ckey = "cte_tradernet";
            var article = worldScripts["CargoTypeExtension-TraderNet"].getMessage(this.tradernetpointer++);
        }
        mission.runScreen({
                title: "TraderNet News",
                overlay: background,
                message: "\n\n\n\n\n\n\n\n" + article,
                choicesKey: ckey
            },
            function (choice) {
                if (choice == "01_NEXT") {
                    this.readTraderNet();
                } else {
                    this.startTrading();
                }
            }, this);
    }
}

this.runNewOffer = function () {
    var offer = this.currentOffer();
    var msg = "This is a standard procurement contract - you bring me " + offer.amount + " TC of " + worldScripts["CargoTypeExtension"].cargoDefinition(offer.good, "specificType") + " by " + offer.deadline + ", at a rate of " + offer.price + "₢/TC.\nYou can bring them in more than one load, if you want, and how you obtain the goods is up to you.\nIf you fail to fulfil the contract, there will be a penalty charge of " + offer.price + "₢ for every TC you are short, to cover my risk of being short on what I need, so it's in your interests to have a good idea of how you're going to deliver the goods.\n";

    mission.runScreen({
        title: this.traderName(),
        message: msg,
        overlay: "cte_tradefloor.png",
        choicesKey: "cte_fetch_deal"
    }, this.newOfferChoice, this);
}

this.newOfferChoice = function (choice) {
    if (choice == "01_ACCEPT") {
        this.fetchContracts.push(this.localOffer);
        this.localOffer = false;
        var msg = "Thank you, Trader " + player.name + ". I look forward to you returning with the goods.";
    } else {
        var msg = "If you change your mind after a look at your charts, then I'll be around here for a little bit longer.";
    }

    mission.runScreen({
        title: this.traderName(),
        message: msg,
        overlay: "cte_tradefloor.png"
    }, this.leaveFetch, this);
}

this.runOldOffer = function () {
    var offer = this.currentOffer();

    var carried = worldScripts["CargoTypeExtension"].hasSpecialCargo(offer.good);
    if (carried == 0) {
        mission.runScreen({
            title: this.traderName(),
            message: "You don't seem to have any " + worldScripts["CargoTypeExtension"].cargoDefinition(offer.good, "specificType") + " in your hold right now, Trader. Remember, I still need you to deliver " + offer.amount + " TC by " + offer.deadline + ".",
            overlay: "cte_tradefloor.png"
        }, this.leaveFetch, this);
    } else {
        var msg = "Welcome back, Trader " + player.name + ". Your manifest indicates that you have " + carried + " TC of " + worldScripts["CargoTypeExtension"].cargoDefinition(offer.good, "specificType") + " in your hold. Would you like to transfer them now, for the agreed price of " + offer.price + "₢ up to the " + offer.amount + " TC remaining on this contract?";
        mission.runScreen({
            title: this.traderName(),
            message: msg,
            overlay: "cte_tradefloor.png",
            choicesKey: "cte_fetch_transfer"
        }, this.oldOfferChoice, this);
    }
}

this.oldOfferChoice = function (choice) {
    if (choice != "01_ACCEPT") {
        mission.runScreen({
            title: this.traderName(),
            message: "Don't forget to drop them off here before you leave, then!",
            overlay: "cte_tradefloor.png"
        }, this.leaveFetch, this);
        return;
    }

    var offer = this.currentOffer();
    var transferred = 0;
    while (offer.amount > 0 && worldScripts["CargoTypeExtension"].hasSpecialCargo(offer.good) > 0) {
        if (worldScripts["CargoTypeExtension"].removeSpecialCargo(offer.good)) {
            transferred++;
            offer.amount--;
        } else {
            worldScripts["CargoTypeExtension"].error("Unable to transfer expected good in fetch contract?!");
            player.consoleMessage("Warning: Unexpected error in NewCargoes OXP. Please see Latest.Log");
            return;
        }
    }

    var price = offer.price * transferred;
    var msg = "Thank you. " + transferred + " TC has been transferred, and " + price + "₢ has been credited to your account.\n";
    player.credits += price;

    if (offer.amount > 0) {
        msg += offer.amount + " TC remain to be delivered by " + offer.deadline + ", Trader - I hope to see you back soon with more.";
    } else {
        msg += "Thank you, Trader. This is all of the goods we agreed. I hope to see you again soon.";
    }
    mission.runScreen({
        title: this.traderName(),
        message: msg,
        overlay: "cte_tradefloor.png"
    }, this.leaveFetch, this);
}

this._contract_runOffer = function () {
    var price = worldScripts["CargoTypeExtension"].cargoPriceExport("CTE_CTOC_1", 15, worldScripts["CargoTypeExtension"].defaultMarketInfo()) / 10;
    var totalprice = price * this.contractdata.amount;

    if (player.ship.cargoSpaceCapacity < this.contractdata.amount) {
        var msg = "Trader, I appreciate your enthusiasm, but unfortunately my buyer isn't interested in partial deliveries. Come back and see me when you've got a proper freighter.";

        if (player.ship.equipmentStatus("EQ_HYPERCARGO") === "EQUIPMENT_OK" || player.ship.equipmentStatus("EQ_MULTIBAY") === "EQUIPMENT_OK") {
            msg = "Unfortunately, Trader, my buyer is somewhat old-fashioned, and doesn't approve of all these new hyperspatial storage arrangements. I'm afraid I can only offer this contract to people with a sufficiently large primary cargo bay.";
        }
        mission.runScreen({
            title: this.traderName(),
            overlay: "cte_tradefloor.png",
            message: msg
        }, this.leaveOpenC, this);

    } else if (player.ship.cargoSpaceAvailable < this.contractdata.amount) {
        var msg = "I'm sorry, Trader. You'll need to free up some hold space before we can discuss this contract.";

        if (player.ship.equipmentStatus("EQ_HYPERCARGO") === "EQUIPMENT_OK" || player.ship.equipmentStatus("EQ_MULTIBAY") === "EQUIPMENT_OK") {
            msg = "Unfortunately, Trader, my buyer is somewhat old-fashioned, and doesn't approve of all these new hyperspatial storage arrangements. You'll have to reorganise your cargo to get enough space in the main hold area for the goods before I can transfer them.";
        }

        mission.runScreen({
            title: this.traderName(),
            overlay: "cte_tradefloor.png",
            message: msg
        }, this.leaveOpenC, this);
    } else if (totalprice > player.credits) {
        var msg = "I'm sorry, Trader. You don't have enough credits to afford the security deposit. Come back some day when you're a little richer.";
        mission.runScreen({
            title: this.traderName(),
            overlay: "cte_tradefloor.png",
            message: msg
        }, this.leaveOpenC, this);

    } else {

        var msg = "Here's the deal, " + player.name + ". I'll sell you " + this.contractdata.amount + " of " + this.contractdata.cargospecific + " for " + price.toFixed(1) + "₢/TC (" + totalprice + "₢) security deposit. When you get to " + System.infoForSystem(galaxyNumber, this.contractdata.dest).name + " station, " + this.contractdata.buyer + " will pay you over ten times that for delivery. I can't tell you the exact price, unfortunately, because that obsolete Galcop regulation is still being enforced. They'll then pay me the rest of the goods cost minus your delivery fee and the security deposit. Everyone's a winner.\n\nWhat's that? What's the catch? Well, you're not the only one taking this contract. " + this.contractdata.buyer + " is only going to pay the first one there, so you'll need to be fast. You're one of the first to show up, so your odds are pretty good.";

        if (player.ship.equipmentStatus("EQ_HYPERCARGO") === "EQUIPMENT_OK" || player.ship.equipmentStatus("EQ_MULTIBAY") === "EQUIPMENT_OK") {
            msg = "\n\nOh, by the way, Trader, my buyer is somewhat old-fashioned, and doesn't approve of all these new hyperspatial storage arrangements. For auditing purposes, you should keep the cargo in your main hold throughout the trip.";
        }

        mission.runScreen({
            title: this.traderName(),
            overlay: "cte_tradefloor.png",
            message: msg,
            choicesKey: "cte_oc_deal"
        }, this.dealOpenC, this);
    }
}

this.dealOpenC = function (choice) {
    if (choice == "01_DEAL") {
        var price = worldScripts["CargoTypeExtension"].cargoPriceExport("CTE_CTOC_1", 15, worldScripts["CargoTypeExtension"].defaultMarketInfo()) / 10;
        for (var i = 1; i <= this.contractdata.amount; i++) {
            worldScripts["CargoTypeExtension"].addSpecialCargo("CTE_CTOC_1", price.toFixed(1) + "₢ for open contract in " + system.info.name);
        }
        worldScripts["CargoTypeExtension"].debug(price + " " + this.contractdata.amount);
        player.credits = player.credits - (price * this.contractdata.amount);
        this.contractdata.active = 1;

        var msg = "Thank you, Trader. The cargo is being loaded on to your ship as we speak. I recommend you launch as soon as possible.";
        if (player.ship.equipmentStatus("EQ_HYPERCARGO") === "EQUIPMENT_OK" || player.ship.equipmentStatus("EQ_MULTIBAY") === "EQUIPMENT_OK") {
            msg += "\n\nRemember that the buyer doesn't approve of hyperspatial cargo storage. You can carry the cargo there in flight at your own risk if you must, but make sure that all the goods are in your primary cargo hold when you dock at the destination station, or they probably won't take them.";
        }

    } else {
        var msg = "Understood, Trader. Now, if you'll excuse me, I have a few other potential couriers to talk to. I'll still be here for a little while if you change your mind.";
    }
    mission.runScreen({
        title: this.traderName(),
        overlay: "cte_tradefloor.png",
        message: msg
    }, this.leaveOpenC, this);
}

this.openContractWin = function () {
    var price = worldScripts["CargoTypeExtension"].cargoPriceImport("CTE_CTOC_1", 15, worldScripts["CargoTypeExtension"].defaultMarketInfo()) / 10;
    var carried = worldScripts["CargoTypeExtension"].hasSpecialCargo("CTE_CTOC_1");
    var msg = "Welcome, Trader " + player.name + ". Let's see those " + this.contractdata.cargospecific + " then.\n\n";
    if (carried == this.contractdata.amount) {
        msg += "Ah, excellent. All present and correct. If you'll just authorise the cargo transfer, the " + price.toFixed(1) + " ₢/TC will be yours.";

    } else if (carried >= this.contractdata.amount) { // shouldn't be possible, in general. Well, they probably deserve a small bonus.
        msg += "Ah, excellent. All present and correct. If you'll just authorise the cargo transfer, the " + price.toFixed(1) + " ₢/TC will be yours. I'll take the spares off your hands for the same price, I think. Don't tell " + this.contractdata.seller + ", though, or they'll be wanting their cut.";

    } else if (carried > 0) {
        price = Math.floor(price * (carried / this.contractdata.amount));
        msg += "You appear to be missing some of the cargo I need. I'll take what you have off your hands, now it's here, but your payment has been reduced to " + price.toFixed(1) + " ₢/TC to account for my costs in obtaining replacements.";
    } else if (carried == 0) {
        msg += "Ah. Apologies. I seem to have been misinformed. I thought you were carrying some goods for me, but it must have been someone with a similar name.";
    }

    player.credits += price * carried;
    for (var i = 1; i <= carried; i++) {
        worldScripts["CargoTypeExtension"].removeSpecialCargo("CTE_CTOC_1");
    }

    this.contractdata.active = 0;
    mission.runScreen({
        title: this.contractdata.buyer,
        overlay: "cte_tradefloor.png",
        message: msg
    }, function () {}, this);
}

this.openContractLose = function () {
    this.contractdata.active = 0;

    var missed = clock.adjustedSeconds - this.contractdata.deadline;
    var msg = "You can't find " + this.contractdata.buyer + " when you dock. You ask the harbourmaster if they've seen them.\n\n"
    if (missed < 60) {
        msg += "You've literally just missed them. Some trader in a Boa Clipper was unloading cargo with them over there.";
    } else if (missed < 3600) {
        msg += "They were here a moment ago. I think they left a few minutes ago with a Boa II pilot.";
    } else if (missed < 86400) {
        msg += "I saw them around earlier today. An L-Crate full of cargo came in for them, I think, so they were supervising the unloading.";
    } else if (missed < (86400 * 7)) {
        msg += "Not for a few days, no. They were taking some cargo from a Boa planetside.";
    } else {
        msg += "No, they've not been up here for a while, not since that Anaconda came in last week.";
    }

    mission.runScreen({
        title: "Too late...",
        overlay: "cte_tradefloor.png",
        message: msg
    }, function () {}, this);
}

this._permits_runOffer = function () {
    if (player.ship.targetSystem == system.ID) {
        this.permitDealings("Please set your navigation computer's destination system to your desired importer.");
        return;
    }
    this.currentpermit = this.decodePermit(this.permitSeller.permitcode);
    this.currentpermit.good = this.permitSeller.good;
    this.currentpermit.dest = player.ship.targetSystem;
    this.currentpermit.real = this.permitSeller.real;
    this.currentpermit.deadline = this.calculatePermitDeadline(this.currentpermit.dest, this.currentpermit.timenoise);
    if (this.currentpermit.deadline == 0) {
        this.permitDealings("I'm afraid we don't have a trade agreement with " + System.infoForSystem(galaxyNumber, player.ship.targetSystem).name + ", Trader.");
        return;
    } else {
        var price = this.permitPrice(this.currentpermit);
        var desc = this.permitDescription(this.currentpermit);
        var msg = "We can offer the following permit:\n";
        msg += "-------------------------\n";
        msg += desc + "\n";
        msg += "-------------------------\n";
        msg += "Inclusive of all fees and taxes, this will cost " + price + "₢";

        mission.runScreen({
            title: this.traderName(),
            message: msg,
            choicesKey: "cte_permit_deal",
            overlay: "cte_permit.png"
        }, this.permitChoice, this);
    }
}

this.permitDealings = function (msg) {
    mission.runScreen({
        title: this.traderName(),
        message: msg,
        overlay: "cte_permit.png"
    }, this.permitExit, this);
}

this._scavenger_runOffer = function () {
    var scav = this.activeScavenger();

    var spec = worldScripts["CargoTypeExtension"].cargoDefinition(this.scavengerCargoes[scav], "specificType");
    var gen = worldScripts["CargoTypeExtension"].cargoDefinition(this.scavengerCargoes[scav], "genericType");

    var amount = worldScripts["CargoTypeExtension"].hasSpecialCargo(this.scavengerCargoes[scav]);
    if (amount == 0) {
        var msg = "I'm sorry, Trader. I'm sure the contents of your hold are fascinating to the right buyer, but I'm only looking for " + spec + ". I won't take up your time any further.";
        mission.runScreen({
            title: this.traderName(),
            overlay: "cte_tradefloor.png",
            message: msg
        }, this.leaveScavenger, this);

    } else {
        var price = Math.floor(1000 * amount * (Math.pow(amount, 0.25)));
        if (gen == "slaves" || gen == "narcotics" || gen == "firearms") {
            price *= 2; // illegal goods
        }

        var msg = "Excellent work, Trader. In exchange for the " + amount + " TC of " + spec + " in your hold, I will pay " + price + "₢. Do we have a deal?";
        mission.runScreen({
            title: this.traderName(),
            overlay: "cte_tradefloor.png",
            message: msg,
            choicesKey: "cte_scav_deal"
        }, this.dealScavenger, this);
    }
}

this.dealScavenger = function (choice) {
    if (choice == "01_DEAL") {
        var scav = this.activeScavenger();
        var gen = worldScripts["CargoTypeExtension"].cargoDefinition(this.scavengerCargoes[scav], "genericType");

        var amount = worldScripts["CargoTypeExtension"].hasSpecialCargo(this.scavengerCargoes[scav]);
        for (var i = 0; i < amount; i++) {
            worldScripts["CargoTypeExtension"].removeSpecialCargo(this.scavengerCargoes[scav]);
        }
        var price = Math.floor(1000 * amount * (Math.pow(amount, 0.25)));
        if (gen == "slaves" || gen == "narcotics" || gen == "firearms") {
            price *= 2; // illegal goods
        }

        player.credits += price;

        var msg = "A pleasure dealing with you, Trader. " + price + "₢ has been credited to your account. Contact me again if you find any more.";

    } else {
        var msg = "Your choice, but you won't find anyone else willing to pay this much. Come back when you've figured that out for yourself.";
    }
    mission.runScreen({
        title: this.traderName(),
        overlay: "cte_tradefloor.png",
        message: msg
    }, this.leaveScavenger, this);
}

//-------------------------------------------------------------------------------------------------------------
// to make Iron Raven compatible
this.questionScreens = function () {
    if (system.ID == 23) // Maenes
    {
        if (missionVariables.IR_status == "IR_IBANEZ_4") {
            this._runScreen({
                title: "QuiCo Pharmaceuticals",
                overlay: "IR_quico_logo.png",
                messageKey: "IR_MAENES_intro",
                choicesKey: "IR_questions"
            }, this.choiceEvaluation);
            missionVariables.IR_offer = "IR_MAENES_QUESTIONS"
        }
    }

    if (system.ID == 171) // Yokohama
    {
        if (missionVariables.IR_status == "IR_IBANEZ_4") {
            this._runScreen({
                title: "Yokohama Exports",
                overlay: "IR_yk_logo.png",
                messageKey: "IR_YOKOHAMA_intro",
                choicesKey: "IR_questions"
            }, this.choiceEvaluation);
            missionVariables.IR_offer = "IR_YOKOHAMA_QUESTIONS"
        }
    }

    if (system.ID == 232) //Janes
    {
        if (missionVariables.IR_status == "IR_IBANEZ_4") {
            this._runScreen({
                title: "Janes's Shipyard Intelligence",
                overlay: "IR_janes_logo.png",
                messageKey: "IR_JANES_intro",
                choicesKey: "IR_questions"
            }, this.choiceEvaluation);
            missionVariables.IR_offer = "IR_JANES_QUESTIONS"
        }
    }

    if (system.ID == 240) // Pirate Cove
    {
        if (missionVariables.IR_status == "IR_IBANEZ_4") {
            if (!missionVariables.IR_alsto) {
                this._runScreen({
                    title: " ",
                    messageKey: "IR_PIRATE_intro",
                    choicesKey: "IR_questions"
                }, this.choiceEvaluation);
                missionVariables.IR_offer = "IR_PIRATE_QUESTIONS"
                missionVariables.IR_alsto = "MET"
            } else {
                this._runScreen({
                    title: " ",
                    messageKey: "IR_PIRATE_intro_alt",
                    choicesKey: "IR_questions"
                }, this.choiceEvaluation);
                missionVariables.IR_offer = "IR_PIRATE_QUESTIONS"
            }
        }
    }

    if (system.ID == 119) // PleasureWorld
    {
        if (missionVariables.IR_status == "IR_IBANEZ_4") {
            this._runScreen({
                title: "PleasureWorld",
                overlay: "IR_pw_logo.png",
                messageKey: "IR_PW_intro",
                choicesKey: "IR_questions"
            }, this.choiceEvaluation);
            missionVariables.IR_offer = "IR_PW_QUESTIONS"
        }
    }

    if (system.ID == 180) // NWE
    {
        if (missionVariables.IR_status == "IR_IBANEZ_4") {
            this._runScreen({
                title: "Naval Weapons Establishment",
                overlay: "IR_NWE_logo.png",
                messageKey: "IR_NWE_intro",
                choicesKey: "IR_questions"
            }, this.choiceEvaluation);
            missionVariables.IR_offer = "IR_NWE_QUESTIONS"
        }
    }

    if (system.ID == 219) // GSE
    {
        if (missionVariables.IR_status == "IR_IBANEZ_4") {
            this._runScreen({
                title: "Galactic Stock Exchange",
                overlay: "IR_GSE_logo.png",
                messageKey: "IR_GSE_intro",
                choicesKey: "IR_questions"
            }, this.choiceEvaluation);
            missionVariables.IR_offer = "IR_GSE_QUESTIONS"
        }
    }

    if (system.ID == 31) // KORSHKOV
    {
        if (missionVariables.IR_status == "IR_IBANEZ_4") {
            this._runScreen({
                title: "OKB Korshkov",
                overlay: "IR_korshlogo.png",
                messageKey: "IR_KORSHKOV_intro",
                choicesKey: "IR_questions"
            }, this.choiceEvaluation);
            missionVariables.IR_offer = "IR_KORSHKOV_QUESTIONS"
        }
    }
}

this._ir_shipDockedWithStation = function (station) {
    this.addIRinterface()

    if (missionVariables.IR_status == "IR_epilogue" && clock.days > missionVariables.IR_epilogue_deadline) {
        this._runScreen({
            messageKey: "IR_final",
            choicesKey: "IR_continue"
        }, function (choice) {
            if (choice == 1) {
                this._runScreen({
                    overlay: "IR_title.png",
                    messageKey: "IR_theend"
                });
                missionVariables.IR_status = "IR_completed"
                mission.setInstructionsKey(null)
                missionVariables.IR_epilogue_deadline = null
                missionVariables.IR_shipment_quest = null
                missionVariables.IR_SDF_quest = null
                missionVariables.IR_SDF_question_no = null
                missionVariables.IR_SDF_question_key = null
                missionVariables.IR_SDF_question_string = null
                missionVariables.IR_defences_quest = null
                missionVariables.IR_defences_question_no = null
                missionVariables.IR_defences_question_key = null
                missionVariables.IR_defences_question_string = null
                missionVariables.IR_finance_quest = null
                missionVariables.IR_finance_question_no = null
                missionVariables.IR_finance_question_key = null
                missionVariables.IR_finance_question_string = null
                missionVariables.IR_shipment_quest_method = null
                missionVariables.IR_shipment_question_no = null
                missionVariables.IR_shipment_question_key = null
                missionVariables.IR_shipment_question_string = null
                missionVariables.IR_GSE_loan = null
                missionVariables.IR_wife_status = null
                missionVariables.IR_alsto = null
                missionVariables.IR_count = null
                missionVariables.IR_defences_kill_count = null
                missionVariables.IR_SDF_quest_location = null
                missionVariables.IR_SDF_quest_location_name = null
                missionVariables.IR_KORSHKOV_deadline = null
                missionVariables.IR_asked_question = null
                missionVariables.IR_question_settings = null
                missionVariables.IR_screen_log = null
                missionVariables.IR_screen_location = null
            }
        });
    }
    if (player.ship.docked && galaxyNumber == 7) this.missionScreens();
}

this.missionScreens = function () {
    if (guiScreen == "GUI_SCREEN_MISSION" || !player.ship.docked)
        return;

    if (player.ship.dockedStation.hasRole("IR-luft-core")) {
        if (missionVariables.IR_SDF_quest == "JACOB" || missionVariables.IR_SDF_quest == "LUFTSLOTTE") {
            this._runScreen({
                title: "Luftslotte 6",
                messageKey: "IR_SDF_quest_4"
            })
            missionVariables.IR_SDF_quest = "KRAIT"
        }
    }

    if (player.ship.dockedStation.isMainStation && missionVariables.IR_offer == null) {
        if (missionVariables.IR_status == null) {
            this._runScreen({
                overlay: "IR_title.png",
                choicesKey: "IR_continue"
            }, function (choice) {
                if (choice == 1) {
                    this._runScreen({
                        messageKey: "IR_IBANEZ_1"
                    });
                    mission.setInstructionsKey("IR_IBANEZ_INFO")
                    missionVariables.IR_status = "IR_IBANEZ_1"
                }
            });
        }

        if (missionVariables.IR_finance_quest == "REPROCESSED" && clock.days >= missionVariables.IR_KORSHKOV_deadline) //this is 20 days
        {
            this._runScreen({
                title: "Jane's Shipyard Intelligence",
                messageKey: "IR_finance_quest_4"
            });
            missionVariables.IR_finance_quest = "JANES_NEWS"
            missionVariables.IR_KORSHKOV_deadline = null
            player.incrementFinanceStatus()
        }

        if (missionVariables.IR_SDF_quest == "ADDRESS" && clock.days >= missionVariables.IR_SDF_deadline) {
            this._runScreen({
                messageKey: "IR_SDF_quest_2"
            });
            missionVariables.IR_SDF_quest = "JACOB"
            player.incrementSDFStatus()
        }

        if (missionVariables.IR_SDF_quest == "POD_SCOOPED") {
            this._runScreen({
                messageKey: "IR_SDF_quest_5"
            });
            player.ship.useSpecialCargo("WARNING: Radiation detected in cargo hold")
            missionVariables.IR_SDF_quest = "KORSHKOV"
            player.incrementSDFStatus()
        }

        if (missionVariables.IR_SDF_quest == "PHOTO" && clock.days >= missionVariables.IR_SDF_deadline) {
            this._runScreen({
                messageKey: "IR_SDF_quest_8a",
                overlay: "IR_kinnaird.png",
                choicesKey: "IR_continue"
            }, function (choice) {
                if (choice == 1)
                    this._runScreen({
                        messageKey: "IR_SDF_quest_8b",
                        overlay: "IR_match.png",
                        choicesKey: "IR_continue"
                    }, function (choice) {
                        if (choice == 1) {
                            this._runScreen({
                                messageKey: "IR_SDF_quest_8c"
                            });
                            missionVariables.IR_SDF_quest = "COMPLETED"
                            player.clearSDFStatus()
                            missionVariables.IR_SDF_status_no = null
                            missionVariables.IR_SDF_deadline = null
                                ++missionVariables.IR_quest_count
                        }
                    });
            });
        }

        if (missionVariables.IR_finance_quest == "WAIT3" && clock.days >= missionVariables.IR_KORSHKOV_deadline) {
            this._runScreen({
                title: " ",
                overlay: "IR_bloomberg.png",
                messageKey: "IR_finance_quest_10"
            });
            missionVariables.IR_KORSHKOV_deadline = null
            player.clearFinanceStatus()
            missionVariables.IR_finance_status_no = null
            missionVariables.IR_finance_quest = "COMPLETED"
                ++missionVariables.IR_quest_count
        }

        if (missionVariables.IR_shipment_quest == "SUCCESS") {
            this._runScreen({
                messageKey: "IR_shipment_success"
            });
            player.clearShipmentStatus()
            missionVariables.IR_shipment_status_no = null
            missionVariables.IR_shipment_quest = "COMPLETED"
            missionVariables.IR_YOKOHAMA_deadline = null
                ++missionVariables.IR_quest_count
            missionVariables.IR_tipoff_deadline = clock.days + 10
        }

        if (missionVariables.IR_shipment_quest == "DISPATCHED") {
            this._runScreen({
                messageKey: "IR_shipment_failure"
            });
            player.clearShipmentStatus()
            missionVariables.IR_shipment_status_no = null
            missionVariables.IR_shipment_quest = "FAILED"
                ++missionVariables.IR_quest_count
            missionVariables.IR_YOKOHAMA_deadline = null
        }

        if (missionVariables.IR_shipment_quest == "COMPLETED") {
            if (clock.days >= missionVariables.IR_tipoff_deadline) {
                this._runScreen({
                    messageKey: "IR_tipoff"
                });
                missionVariables.IR_tipoff_deadline = null
                missionVariables.IR_shipment_quest = "TIPPEDOFF"
            }
        }

        if (missionVariables.IR_loan_deadline) {
            if (clock.days >= missionVariables.IR_loan_deadline) {
                this._runScreen({
                    title: "First Galactic Bank",
                    messageKey: "IR_GSE_loan_warning"
                });
                mission.setInstructionsKey(null)
                missionVariables.IR_loan_deadline = null
                missionVariables.IR_load_remaining = null
                player.credits -= 550000
                missionVariables.IR_GSE_loan = "DEFAULTED"
            }
        }

        if (missionVariables.IR_defences_quest == "DEMO_6" && clock.days > missionVariables.IR_defences_quest_deadline) {
            this._runScreen({
                messageKey: "IR_defences_quest_6"
            });
            ++missionVariables.IR_quest_count
            missionVariables.IR_defences_quest = "COMPLETED"
            missionVariables.IR_defences_quest_deadline = null
            missionVariables.IR_defences_status_no = null
            player.clearDefencesStatus()
        }

        if (missionVariables.IR_status == "IR_KINNAIRD_2") {
            this._runScreen({
                messageKey: "IR_kinnaird_3alt"
            });
        }

        if (missionVariables.IR_status == "IR_LEXICON_1" && clock.days > missionVariables.IR_LEXICON_deadline) {
            this._runScreen({
                messageKey: "IR_LEXICON_2"
            });
            missionVariables.IR_status = "IR_LEXICON_2"
            mission.setInstructionsKey("IR_LEXICON_brief_2")
            missionVariables.IR_LEXICON_deadline = null
        }

        if (missionVariables.IR_status == "IR_CHERKASOVA_1") // briefing with Cherkasova
        {
            this._runScreen({
                messageKey: "IR_CHERKASOVA_1a",
                overlay: "IR_KSR_logo.png",
                choicesKey: "IR_continue"
            }, function (choice) {
                if (choice == 1)
                    this._runScreen({
                        messageKey: "IR_CHERKASOVA_1b",
                        overlay: "IR_KSR_logo.png",
                        choicesKey: "IR_continue"
                    }, function (choice) {
                        if (choice == 1)
                            this._runScreen({
                                messageKey: "IR_CHERKASOVA_1c",
                                overlay: "IR_KSR_logo.png",
                                choicesKey: "IR_continue"
                            }, function (choice) {
                                if (choice == 1)
                                    this._runScreen({
                                        messageKey: "IR_CHERKASOVA_1d",
                                        overlay: "IR_KSR_logo.png",
                                        choicesKey: "IR_cherkasova_choices"
                                    }, function (choice) {
                                        if (choice == 1) {
                                            this._runScreen({
                                                messageKey: "IR_LOA_1",
                                                overlay: "IR_KSR_logo.png"
                                            })
                                            mission.setInstructionsKey("IR_LOA_brief_1")
                                            missionVariables.IR_status = "IR_LOA_1"
                                            mission.setInstructionsKey("IR_LOA_brief_1")
                                            missionVariables.IR_cherkasova_deadline = null
                                        }
                                        if (choice == 2) {
                                            this._runScreen({
                                                messageKey: "IR_sources_1",
                                                overlay: "IR_KSR_logo.png"
                                            }) //screen fails to run
                                            mission.setInstructionsKey("IR_LEXICON_brief_1")
                                            missionVariables.IR_status = "IR_sources_1"
                                            missionVariables.IR_cherkasova_deadline = null
                                            mission.setInstructionsKey("IR_LEXICON_brief_1")
                                            missionVariables.IR_sources_deadline = clock.days + 15
                                        }
                                    });
                            });
                    });
            });
        }

        if (missionVariables.IR_status == "IR_sources_1" && clock.days > missionVariables.IR_sources_deadline) {
            this._runScreen({
                messageKey: "IR_sources_2"
            });
            missionVariables.IR_status = "IR_sources_2"
            mission.setInstructionsKey("IR_waitforinfo_brief")
            missionVariables.IR_sources_deadline = clock.days + 7
        }

        if (missionVariables.IR_status == "IR_sources_2" && clock.days > missionVariables.IR_sources_deadline) {
            this._runScreen({
                messageKey: "IR_sources_3"
            });
            missionVariables.IR_status = "IR_sources_3"
            missionVariables.IR_sources_deadline = null
            mission.setInstructionsKey("IR_sources_brief_1")
        }

        if (missionVariables.IR_status == "IR_LOA_4" && clock.days > missionVariables.IR_attack_deadline) {
            this._runScreen({
                messageKey: "IR_LOA_5"
            });
            missionVariables.IR_status = "IR_LOA_5"
            missionVariables.IR_attack_deadline = null
            mission.setInstructionsKey("IR_LOA_brief_4")
        }

        if (missionVariables.IR_status == "IR_LOA_7" && clock.days > missionVariables.IR_epilogue_deadline) {
            this._runScreen({
                messageKey: "IR_LOA_7"
            });
            missionVariables.IR_status = "IR_LOA_8"
            missionVariables.IR_epilogue_deadline = clock.days + 10
        }

        if (missionVariables.IR_status == "IR_LOA_8" && clock.days > missionVariables.IR_epilogue_deadline) {
            this._runScreen({
                messageKey: "IR_LOA_8"
            });
            missionVariables.IR_status = "IR_LOA_9"
            missionVariables.IR_epilogue_deadline = clock.days + 7
        }

        if (missionVariables.IR_status == "IR_LOA_9" && clock.days > missionVariables.IR_epilogue_deadline) {
            this._runScreen({
                messageKey: "IR_invite"
            });
            missionVariables.IR_status = "IR_invite"
            mission.setInstructionsKey("IR_invite_brief")
            missionVariables.IR_epilogue_deadline = null
        }

        if (missionVariables.IR_status == "IR_sources_6" && clock.days > missionVariables.IR_epilogue_deadline) {
            this._runScreen({
                messageKey: "IR_sources_6"
            });
            missionVariables.IR_status = "IR_sources_7"
            missionVariables.IR_epilogue_deadline = clock.days + 15
        }

        if (missionVariables.IR_status == "IR_sources_7" && clock.days > missionVariables.IR_epilogue_deadline) {
            this._runScreen({
                messageKey: "IR_invite"
            });
            missionVariables.IR_status = "IR_invite"
            mission.setInstructionsKey("IR_invite_brief")
            missionVariables.IR_epilogue_deadline = null
        }

        //Location Specific
        if (system.ID == 7) //Vegedius
        {
            if (missionVariables.IR_status == "IR_IBANEZ_1") {
                this._runScreen({
                    title: "GalCop High Command",
                    messageKey: "IR_IBANEZ_2a",
                    choicesKey: "IR_continue"
                }, function (choice) {
                    if (choice == 1)
                        this._runScreen({
                            title: "GalCop High Command",
                            messageKey: "IR_IBANEZ_2b",
                            choicesKey: "IR_continue"
                        }, function (choice) {
                            if (choice == 1) {
                                this._runScreen({
                                    title: "GalCop High Command",
                                    messageKey: "IR_IBANEZ_2c"
                                });
                                missionVariables.IR_status = "IR_IBANEZ_2"
                                mission.setInstructionsKey("IR_RAAED_INFO")
                            }
                        });
                });
            }

            if (missionVariables.IR_status == "IR_RAAED_1") //return to Ibanez
            {
                this._runScreen({
                    title: "Galcop High Command",
                    messageKey: "IR_IBANEZ_3"
                })
                missionVariables.IR_status = "IR_IBANEZ_3"
                mission.setInstructionsKey("IR_JANES_INFO")
            }


            if (missionVariables.IR_status == "IR_JANES_1") // return to Ibanez for big briefing
            {
                this._runScreen({
                    title: "GalCop High Command",
                    messageKey: "IR_IBANEZ_4a",
                    choicesKey: "IR_continue"
                }, function (choice) {
                    if (choice == 1)
                        this._runScreen({
                            title: "GalCop High Command",
                            messageKey: "IR_IBANEZ_4b",
                            choicesKey: "IR_continue"
                        }, function (choice) {
                            if (choice == 1)
                                this._runScreen({
                                    title: "GalCop High Command",
                                    messageKey: "IR_IBANEZ_4c",
                                    choicesKey: "IR_continue"
                                }, function (choice) {
                                    if (choice == 1) {
                                        this._runScreen({
                                            title: "GalCop High Command",
                                            messageKey: "IR_IBANEZ_4d"
                                        });
                                        missionVariables.IR_status = "IR_IBANEZ_4"
                                        mission.setInstructionsKey(null)
                                        this.setupQuestions()
                                        this.setupStatus()
                                        missionVariables.IR_quest_count = 0
                                        this.addIRinterface();
                                    }
                                });
                        });
                });
            }

            if (missionVariables.IR_status == "IR_IBANEZ_4" && missionVariables.IR_quest_count == 4) {
                missionVariables.IR_quest_count = null

                if (missionVariables.IR_shipment_quest_method == "YOKOHAMA_AMBUSH") {
                    this._runScreen({
                        messageKey: "IR_IBANEZ_5a",
                        choicesKey: "IR_continue"
                    }, function (choice) {
                        if (choice == 1) {
                            this._runScreen({
                                overlay: "IR_title.png",
                                messageKey: "IR_theend"
                            });
                            missionVariables.IR_status = "IR_completed"
                            mission.setInstructionsKey(null)
                            missionVariables.IR_epilogue_deadline = null
                            missionVariables.IR_shipment_quest = null
                            missionVariables.IR_SDF_quest = null
                            missionVariables.IR_defences_quest = null
                            missionVariables.IR_finance_quest = null
                            missionVariables.IR_shipment_quest_method = null
                        }
                    });
                }

                if (missionVariables.IR_shipment_quest == "FAILED") {
                    this._runScreen({
                        messageKey: "IR_IBANEZ_5b",
                        choicesKey: "IR_continue"
                    }, function (choice) {
                        if (choice == 1) {
                            this._runScreen({
                                overlay: "IR_title.png",
                                messageKey: "IR_theend"
                            });
                            missionVariables.IR_status = "IR_completed"
                            mission.setInstructionsKey(null)
                            missionVariables.IR_epilogue_deadline = null
                            missionVariables.IR_shipment_quest = null
                            missionVariables.IR_SDF_quest = null
                            missionVariables.IR_defences_quest = null
                            missionVariables.IR_finance_quest = null
                            missionVariables.IR_shipment_quest_method = null
                        }
                    });
                } else
                    this._runScreen({
                        title: "GalCop High Command",
                        messageKey: "IR_IBANEZ_5",
                        choicesKey: "IR_IBANEZ_choices"
                    }, function (choice) {
                        if (choice == "IR_IBANEZ_A_weiss") {
                            this._runScreen({
                                title: "GalCop High Command",
                                messageKey: "IR_weiss_1"
                            });
                            missionVariables.IR_status = "IR_WEISS_1"
                            mission.setInstructionsKey("IR_weiss_brief_1")
                        }
                        if (choice == "IR_IBANEZ_B_kinnaird") {
                            this._runScreen({
                                title: "GalCop High Command",
                                messageKey: "IR_kinnaird_1"
                            });
                            missionVariables.IR_status = "IR_KINNAIRD_1"
                            mission.setInstructionsKey("IR_kinnaird_brief_1")
                        }
                        if (choice == "IR_IBANEZ_C_moreinfo") {
                            this._runScreen({
                                title: "GalCop High Command",
                                messageKey: "IR_LEXICON_1"
                            });
                            missionVariables.IR_status = "IR_LEXICON_1"
                            mission.setInstructionsKey("IR_LEXICON_1")
                            missionVariables.IR_LEXICON_deadline = clock.days + 15
                        }
                    });
            }

            if (missionVariables.IR_status == "IR_WEISS_4" || missionVariables.IR_status == "IR_KINNAIRD_4") {
                this._runScreen({
                    title: "Galcop High Command",
                    messageKey: "IR_IBANEZ_5_debrief"
                })
                missionVariables.IR_status = "IR_IBANEZ_5"
                mission.setInstructionsKey("IR_waitforinfo_brief")
                missionVariables.IR_cherkasova_deadline = clock.days + 20
            }

            if (missionVariables.IR_status == "IR_invite" && clock.days > missionVariables.IR_epilogue_deadline) {
                this._runScreen({
                    messageKey: "IR_reward_a",
                    choicesKey: "IR_continue"
                }, function (choice) {
                    if (choice == 1)
                        this._runScreen({
                            messageKey: "IR_reward_b",
                            choicesKey: "IR_continue"
                        }, function (choice) {
                            if (choice == 1)
                                this._runScreen({
                                    messageKey: "IR_reward_c",
                                    choicesKey: "IR_continue",
                                    overlay: "IR_maenesmedal.png"
                                }, function (choice) {
                                    if (choice == 1)
                                        this._runScreen({
                                            messageKey: "IR_reward_d",
                                            choicesKey: "IR_continue"
                                        }, function (choice) {
                                            if (choice == 1) {
                                                this._runScreen({
                                                    messageKey: "IR_reward_e"
                                                });
                                                missionVariables.IR_status = "IR_epilogue"
                                                missionVariables.IR_epilogue_deadline = clock.days + 5
                                                player.credits += 50000
                                                mission.setInstructionsKey(null)
                                            }
                                        });
                                });
                        });
                });
            }
        }

        if (system.ID == 230) // RAAED
        {
            if (missionVariables.IR_status == "IR_IBANEZ_2") {
                this._runScreen({
                    messageKey: "IR_RAAED_1a",
                    overlay: "IR_forest.png",
                    choicesKey: "IR_continue"
                }, function (choice) {
                    if (choice == 1)
                        this._runScreen({
                            overlay: "IR_invoice.png",
                            choicesKey: "IR_continue"
                        }, function (choice) {
                            if (choice == 1)
                                this._runScreen({
                                    messageKey: "IR_RAAED_1c",
                                    overlay: "IR_forest.png",
                                    choicesKey: "IR_continue"
                                }, function (choice) {
                                    if (choice == 1)
                                        this._runScreen({
                                            messageKey: "IR_RAAED_1d",
                                            choicesKey: "IR_continue",
                                            overlay: "IR_forest.png"
                                        }, function (choice) {
                                            if (choice == 1) {
                                                this._runScreen({
                                                    messageKey: "IR_RAAED_1e",
                                                    overlay: "IR_forest.png"
                                                });
                                                missionVariables.IR_status = "IR_RAAED_1"
                                                mission.setInstructionsKey("IR_IBANEZ_INFO")
                                            }
                                        });
                                });
                        });
                });
            }
        }

        if (system.ID == 232) // Janes
        {
            if (missionVariables.IR_status == "IR_IBANEZ_3") // quick visit to Janes
            {
                this._runScreen({
                    messageKey: "IR_JANES_1a",
                    choicesKey: "IR_continue"
                }, function (choice) {
                    if (choice == 1)
                        this._runScreen({
                            messageKey: "IR_JANES_1b",
                            choicesKey: "IR_continue"
                        }, function (choice) {
                            if (choice == 1) {
                                this._runScreen({
                                    messageKey: "IR_JANES_1c"
                                });
                                missionVariables.IR_status = "IR_JANES_1"
                                mission.setInstructionsKey("IR_IBANEZ_INFO")
                            }
                        });
                });
            }

            if (missionVariables.IR_status == "IR_IBANEZ_4") {
                this._runScreen({
                    title: "Janes's Shipyard Intelligence",
                    overlay: "IR_janes_logo.png",
                    messageKey: "IR_JANES_intro",
                    choicesKey: "IR_questions"
                }, this.choiceEvaluation);
                missionVariables.IR_offer = "IR_JANES_QUESTIONS"
            }
        }

        if (system.ID == 171) // Yokohama
        {
            if (missionVariables.IR_status == "IR_IBANEZ_4") {
                this._runScreen({
                    title: "Yokohama Exports",
                    overlay: "IR_yk_logo.png",
                    messageKey: "IR_YOKOHAMA_intro",
                    choicesKey: "IR_questions"
                }, this.choiceEvaluation);
                missionVariables.IR_offer = "IR_YOKOHAMA_QUESTIONS"
            }
        }

        if (missionVariables.IR_convoy_exited == "TRUE" && missionVariables.IR_alsto == "HELP_ACCEPTED") {
            this._runScreen({
                messageKey: "IR_shipment_contact_report"
            });
            player.incrementShipmentStatus()
            missionVariables.IR_alsto = "INFORMED"
            missionVariables.IR_convoy_exited = null
        }

        if (system.ID == 240) // Pirate Cove
        {
            if (missionVariables.IR_status == "IR_IBANEZ_4")

            {
                if (!missionVariables.IR_alsto) {
                    this._runScreen({
                        title: " ",
                        messageKey: "IR_PIRATE_intro",
                        choicesKey: "IR_questions"
                    }, this.choiceEvaluation);
                    missionVariables.IR_offer = "IR_PIRATE_QUESTIONS"
                    missionVariables.IR_alsto = "MET"
                } else {
                    this._runScreen({
                        title: " ",
                        messageKey: "IR_PIRATE_intro_alt",
                        choicesKey: "IR_questions"
                    }, this.choiceEvaluation);
                    missionVariables.IR_offer = "IR_PIRATE_QUESTIONS"
                }
            }

            if (missionVariables.IR_status == "IR_LOA_1") {
                if (missionVariables.IR_alsto)
                    missionVariables.IR_LOA_text = "known"
                if (missionVariables.IR_alsto == "INFORMED")
                    missionVariables.IR_LOA_text = "helped"
                if (!missionVariables.IR_alsto)
                    missionVariables.IR_LOA_text = "unknown"

                this._runScreen({
                    messageKey: "IR_LOA_" + [missionVariables.IR_LOA_text] + "_2a",
                    choicesKey: "IR_continue"
                }, function (choice) {
                    if (choice == 1)
                        this._runScreen({
                            messageKey: "IR_LOA_" + [missionVariables.IR_LOA_text] + "_2b",
                            choicesKey: "IR_continue"
                        }, function (choice) {
                            if (choice == 1)
                                this._runScreen({
                                    messageKey: "IR_LOA_2c",
                                    choicesKey: "IR_continue"
                                }, function (choice) {
                                    if (choice == 1) {
                                        this._runScreen({
                                            messageKey: "IR_LOA_2d"
                                        })
                                        missionVariables.IR_status = "IR_LOA_2"
                                        mission.setInstructionsKey("IR_LOA_brief_2")
                                        missionVariables.IR_alsto = null
                                        missionVariables.IR_LOA_text = null
                                    }
                                });
                        });
                });
            }
        }

        if (system.ID == 119) // PleasureWorld
        {
            if (missionVariables.IR_status == "IR_IBANEZ_4") {
                this._runScreen({
                    title: "PleasureWorld",
                    overlay: "IR_pw_logo.png",
                    messageKey: "IR_PW_intro",
                    choicesKey: "IR_questions"
                }, this.choiceEvaluation);
                missionVariables.IR_offer = "IR_PW_QUESTIONS"
            }

            if (missionVariables.IR_status == "IR_WEISS_3") {
                this._runScreen({
                    title: "PleasureWord",
                    overlay: "IR_pw_logo.png",
                    messageKey: "IR_weiss_3a",
                    choicesKey: "IR_continue"
                }, function (choice) {
                    if (choice == 1)
                        this._runScreen({
                            overlay: "IR_pw_logo.png",
                            messageKey: "IR_weiss_3b"
                        })
                    missionVariables.IR_status = "IR_WEISS_4"
                    mission.setInstructionsKey("IR_weiss_brief_3")
                });
            }

            if (missionVariables.IR_status == "IR_KINNAIRD_3") {
                this._runScreen({
                    title: "PleasureWord",
                    overlay: "IR_pw_logo.png",
                    messageKey: "IR_kinnaird_4a",
                    choicesKey: "IR_continue"
                }, function (choice) {
                    if (choice == 1)
                        this._runScreen({
                            messageKey: "IR_kinnaird_4b"
                        })
                    missionVariables.IR_status = "IR_KINNAIRD_4"
                    mission.setInstructionsKey("IR_kinnaird_brief_4")
                });
            }

            if (missionVariables.IR_status == "IR_LEXICON_2") {
                this._runScreen({
                    messageKey: "IR_LEXICON_3a",
                    overlay: "IR_nightclub.png",
                    choicesKey: "IR_continue"
                }, function (choice) {
                    if (choice == 1)
                        this._runScreen({
                            messageKey: "IR_LEXICON_3b",
                            overlay: "IR_nightclub.png",
                            choicesKey: "IR_launch_choice"
                        }, function (choice) {
                            if (choice == 1) {
                                missionVariables.IR_status = "IR_LEXICON_4"
                                player.ship.launch()
                            }
                        });
                });
            }

            if (missionVariables.IR_status == "IR_weiss_scooped") {
                this._runScreen({
                    messageKey: "IR_LEXICON_4a",
                    choicesKey: "IR_continue"
                }, function (choice) {
                    if (choice == 1)
                        this._runScreen({
                            messageKey: "IR_LEXICON_4b"
                        })
                    missionVariables.IR_status = "IR_IBANEZ_5"
                    mission.setInstructionsKey("IR_waitforinfo_brief")
                    missionVariables.IR_cherkasova_deadline = clock.days + 20
                });
            }
        }

        if (system.ID == 180) // NWE
        {
            if (missionVariables.IR_status == "IR_IBANEZ_4") {
                this._runScreen({
                    title: "Naval Weapons Establishment",
                    overlay: "IR_NWE_logo.png",
                    messageKey: "IR_NWE_intro",
                    choicesKey: "IR_questions"
                }, this.choiceEvaluation);
                missionVariables.IR_offer = "IR_NWE_QUESTIONS"
            }

            if (missionVariables.IR_defences_quest == "DEMO_2") {
                this._runScreen({
                    title: "Naval Weapons Establishment",
                    overlay: "IR_NWE_logo.png",
                    messageKey: "IR_defences_quest_2a",
                    choicesKey: "IR_continue"
                }, function (choice) {
                    if (choice == 1) {
                        this._runScreen({
                            title: "Naval Weapons Establishment",
                            overlay: "IR_NWE_logo.png",
                            messageKey: "IR_defences_quest_2b"
                        });
                        missionVariables.IR_defences_quest_deadline = clock.days + 7
                        missionVariables.IR_defences_quest = "DEMO_3"
                        player.incrementDefencesStatus()
                    }
                });
            }

            if (missionVariables.IR_defences_quest == "DEMO_3" && clock.days > missionVariables.IR_defences_quest_deadline) {
                this._runScreen({
                    title: "Naval Weapons Establishment",
                    overlay: "IR_NWE_logo.png",
                    messageKey: "IR_defences_quest_3"
                });
                missionVariables.IR_defences_quest_deadline = null
                missionVariables.IR_defences_quest = "DEMO_4"
                player.incrementDefencesStatus()
            }
        }

        if (system.ID == 82) // Inorle
        {
            if (missionVariables.IR_SDF_quest == "JACOB") {
                this._runScreen({
                    messageKey: "IR_SDF_quest_3"
                })
                missionVariables.IR_SDF_quest = "LUFTSLOTTE"
            }
        }

        if (system.ID == 219) // GSE
        {
            if (missionVariables.IR_status == "IR_IBANEZ_4") {
                this._runScreen({
                    title: "Galactic Stock Exchange",
                    overlay: "IR_GSE_logo.png",
                    messageKey: "IR_GSE_intro",
                    choicesKey: "IR_questions"
                }, this.choiceEvaluation);
                missionVariables.IR_offer = "IR_GSE_QUESTIONS"
            }


            if (missionVariables.IR_finance_quest == "JANES_NEWS") {
                this._runScreen({
                    title: "Galactic Stock Exchange",
                    overlay: "IR_GSE_logo.png",
                    messageKey: "IR_finance_quest_6a",
                    choicesKey: "IR_continue"
                }, function (choice) {
                    if (choice == 1) {
                        this._runScreen({
                            title: "Galactic Stock Exchange",
                            overlay: "IR_GSE_logo.png",
                            messageKey: "IR_finance_quest_6b"
                        });
                        player.incrementFinanceStatus()
                        missionVariables.IR_offer = null
                        missionVariables.IR_finance_quest = "WIFE"
                    }
                });
            }

            if (missionVariables.IR_finance_quest == "WIFE_MET") {
                this._runScreen({
                    title: "Galactic Stock Exchange",
                    overlay: "IR_GSE_logo.png",
                    messageKey: "IR_finance_quest_8",
                    choicesKey: "IR_wife_choices"
                }, function (choice) {
                    if (choice == "IR_wife_yes") {
                        this._runScreen({
                            title: "Galactic Stock Exchange",
                            overlay: "IR_GSE_logo.png",
                            messageKey: "IR_finance_quest_9_confirm"
                        });
                        missionVariables.IR_wife_status = "AFFAIR_CONFIRMED"
                    }

                    if (choice == "IR_wife_no") {
                        this._runScreen({
                            title: "Galactic Stock Exchange",
                            overlay: "IR_GSE_logo.png",
                            messageKey: "IR_finance_quest_9_deny"
                        });
                        missionVariables.IR_wife_status = "AFFAIR_DENIED"
                    }

                    player.incrementFinanceStatus()
                    missionVariables.IR_finance_quest = "WAIT3"
                    missionVariables.IR_KORSHKOV_deadline = clock.days + 10
                    missionVariables.IR_offer = null
                });
            }
        }

        if (system.ID == 31) // KORSHKOV
        {
            if (missionVariables.IR_finance_quest == "WAIT" && clock.days >= missionVariables.IR_KORSHKOV_deadline) {
                this._runScreen({
                    title: "OKB Korshkov",
                    overlay: "IR_korshlogo.png",
                    messageKey: "IR_finance_quest_1"
                });
                player.incrementFinanceStatus()
                missionVariables.IR_finance_quest = "COLLECTION"
                missionVariables.IR_KORSHKOV_deadline = null
                return;
            }

            if (missionVariables.IR_finance_quest == "COLLECTION") {
                this.checkManifest()

                if (missionVariables.IR_manifestOK == "TRUE") {
                    this._runScreen({
                        title: "OKB Korshkov",
                        overlay: "IR_korshlogo.png",
                        messageKey: "IR_finance_quest_2"
                    });
                    player.incrementFinanceStatus()
                    missionVariables.IR_KORSHKOV_deadline = clock.days + 10
                    missionVariables.IR_finance_quest = "WAIT2"
                    player.ship.manifest.radioactives -= 10
                    player.ship.manifest.alloys = -5
                    player.ship.manifest.minerals -= 2
                    player.ship.manifest.alienItems -= 2
                    player.ship.manifest.platinum -= 1
                    missionVariables.IR_manifestOK = null
                    return;
                }

                if (missionVariables.IR_manifestOK != "TRUE")
                    this._runScreen({
                        title: "OKB Korshkov",
                        overlay: "IR_korshlogo.png",
                        messageKey: "IR_finance_quest_3alt"
                    });
                else return;
            }

            if (missionVariables.IR_finance_quest == "WAIT2" && clock.days >= missionVariables.IR_KORSHKOV_deadline) {
                this._runScreen({
                    title: "OKB Korshkov",
                    overlay: "IR_korshlogo.png",
                    messageKey: "IR_finance_quest_3"
                });
                player.incrementFinanceStatus()
                missionVariables.IR_KORSHKOV_deadline = null
                missionVariables.IR_finance_quest = "IRRADIATE"
                return;
            }

            if (missionVariables.IR_SDF_quest == "KORSHKOV") {
                this._runScreen({
                    title: "OKB Korshkov",
                    overlay: "IR_korshlogo.png",
                    messageKey: "IR_SDF_quest_6"
                });
                player.incrementSDFStatus()
                missionVariables.IR_SDF_deadline = clock.days + 10
                missionVariables.IR_SDF_quest = "ANALYSIS"
                player.ship.removeAllCargo()
                missionVariables.IR_cargoCount = null
                return;
            }

            if (missionVariables.IR_SDF_quest == "ANALYSIS" && clock.days >= missionVariables.IR_SDF_deadline)

            {
                this._runScreen({
                    title: "OKB Korshkov",
                    overlay: "IR_korshlogo.png",
                    messageKey: "IR_SDF_quest_7a",
                    choicesKey: "IR_continue"
                }, function (choice) {
                    if (choice == 1) {
                        this._runScreen({
                            messageKey: "IR_SDF_quest_7b"
                        });
                        missionVariables.IR_SDF_quest = "DATA"
                        player.incrementSDFStatus()
                        this.incrementSDFQuestion()
                        missionVariables.IR_SDF_location = null
                        missionVariables.IR_SDF_location_name = null
                    }
                });
                return;
            }

            if (missionVariables.IR_status == "IR_IBANEZ_4") {
                this._runScreen({
                    title: "OKB Korshkov",
                    overlay: "IR_korshlogo.png",
                    messageKey: "IR_KORSHKOV_intro",
                    choicesKey: "IR_questions"
                }, this.choiceEvaluation);
                missionVariables.IR_offer = "IR_KORSHKOV_QUESTIONS"
                return;
            }
        }

        if (system.ID == 142) // Tibiri bar
        {
            if (missionVariables.IR_finance_quest == "WIFE_DOCKED") {
                this._runScreen({
                    messageKey: "IR_finance_quest_7a",
                    choicesKey: "IR_continue"
                }, function (choice) {
                    if (choice == 1) {
                        this._runScreen({
                            messageKey: "IR_finance_quest_7b"
                        });
                        player.incrementFinanceStatus()
                        player.credits += 1000
                        missionVariables.IR_offer = null
                        missionVariables.IR_finance_quest = "WIFE_MET"
                    }
                });
            }
            if (missionVariables.IR_finance_quest == "WIFE" || missionVariables.IR_finance_quest == "WIFE_IDENTIFIED")
                this._runScreen({
                    messageKey: "IR_finance_quest_7alt"
                });
        }

        if (system.ID == 23) // Maenes
        {
            if (missionVariables.IR_defences_question_no == 3 && !missionVariables.IR_defences_quest) {
                if (!missionVariables.IR_Maenes_visit) {
                    this._runScreen({
                        title: "QuiCo Pharmaceuticals",
                        overlay: "IR_quico_logo.png",
                        messageKey: "IR_defences_quest_1_alt"
                    });
                    missionVariables.IR_defences_quest = "DEMO_1"
                }
                if (missionVariables.IR_Maenes_visit == "TRUE") {
                    this._runScreen({
                        title: "QuiCo Pharmaceuticals",
                        overlay: "IR_quico_logo.png",
                        messageKey: "IR_defences_quest_1"
                    });
                    missionVariables.IR_defences_quest = "DEMO_1"
                    missionVariables.IR_Maenes_visit = null
                }

            }
            if (missionVariables.IR_defences_quest == "DEMO_4") {
                this._runScreen({
                    title: "QuiCo Pharmaceuticals",
                    overlay: "IR_quico_logo.png",
                    messageKey: "IR_defences_quest_4"
                });
                missionVariables.IR_defences_quest = "DEMO_5"
            }

            if (missionVariables.IR_defences_quest == "SABOTAGED") {
                this._runScreen({
                    title: "QuiCo Pharmaceuticals",
                    overlay: "IR_quico_logo.png",
                    messageKey: "IR_defences_quest_5a",
                    choicesKey: "IR_continue"
                }, function (choice) {
                    if (choice == 1) {
                        this._runScreen({
                            messageKey: "IR_defences_quest_5b"
                        });
                        player.incrementDefencesStatus()
                        missionVariables.IR_defences_quest = "DEMO_6"
                        missionVariables.IR_defences_quest_deadline = clock.days + 15
                    }
                });
            }

            if (missionVariables.IR_status == "IR_sources_5") {
                this._runScreen({
                    title: "QuiCo Pharmaceuticals",
                    overlay: "IR_quico_logo.png",
                    messageKey: "IR_sources_5a",
                    choicesKey: "IR_continue"
                }, function (choice) {
                    if (choice == 1) {
                        this._runScreen({
                            messageKey: "IR_sources_5b"
                        });
                        mission.setInstructionsKey("IR_waitforinfo_brief")
                        missionVariables.IR_status = "IR_sources_6"
                        missionVariables.IR_epilogue_deadline = clock.days + 10
                    }
                });
            }

            if (missionVariables.IR_status == "IR_LOA_6") {
                this._runScreen({
                    title: "QuiCo Pharmaceuticals",
                    overlay: "IR_quico_logo.png",
                    messageKey: "IR_LOA_6"
                });
                mission.setInstructionsKey("IR_waitforinfo_brief")
                missionVariables.IR_status = "IR_LOA_7"
                missionVariables.IR_epilogue_deadline = clock.days + 10
            }
        }

        if (system.ID == 35 && missionVariables.IR_status == "IR_KINNAIRD_1") //Atanon
        {
            this._runScreen({
                messageKey: "IR_kinnaird_2"
            });
            missionVariables.IR_status = "IR_KINNAIRD_2"
        }

        if (system.ID == 41 && missionVariables.IR_status == "IR_KINNAIRD_2") //Orlaroor
        {
            this._runScreen({
                messageKey: "IR_kinnaird_3"
            });
            missionVariables.IR_status = "IR_KINNAIRD_3"
            mission.setInstructionsKey("IR_kinnaird_brief_3")
        }

        if (system.ID == 149 && missionVariables.IR_status == "IR_LOA_3") //Arenxeon
        {
            this._runScreen({
                messageKey: "IR_LOA_4a",
                choicesKey: "IR_continue"
            }, function (choice) {
                if (choice == 1) {
                    this._runScreen({
                        messageKey: "IR_LOA_4b"
                    });
                    missionVariables.IR_status = "IR_LOA_4"
                    missionVariables.IR_attack_deadline = clock.days + 10
                    mission.setInstructionsKey("IR_waitforinfo_brief")
                }
            });
        }

        if (system.ID == 63 && missionVariables.IR_status == "IR_sources_3") //Edsoan
        {
            this._runScreen({
                messageKey: "IR_sources_4a",
                choicesKey: "IR_continue"
            }, function (choice) {
                if (choice == 1) {
                    this._runScreen({
                        messageKey: "IR_sources_4b"
                    });
                    missionVariables.IR_status = "IR_sources_4"
                    mission.setInstructionsKey("IR_sources_brief_2")
                }
            });
        }
        //keep brackets	
    }
}

this.choiceEvaluation = function (choice) {
    switch (missionVariables.IR_offer) {
        case "IR_GSE_QUESTIONS": {
            if (choice == "IR_B_finance_question_key") {
                if (missionVariables.IR_finance_question_no == 1) {
                    this._runScreen({
                        title: "Galactic Stock Exchange",
                        overlay: "IR_GSE_logo.png",
                        messageKey: "IR_GSE_finance_answer_1a",
                        choicesKey: "IR_continue"
                    }, function (choice) {
                        if (choice == 1) {
                            this.incrementFinanceQuestion()
                            this._runScreen({
                                title: "Galactic Stock Exchange",
                                overlay: "IR_GSE_logo.png",
                                messageKey: "IR_GSE_finance_answer_1b",
                                choicesKey: "IR_questions"
                            }, this.choiceEvaluation);
                            missionVariables.IR_offer = "IR_GSE_QUESTIONS"
                        }
                    });
                    break;
                }

                if (missionVariables.IR_finance_question_no > 1) {
                    missionVariables.IR_asked_question = missionVariables.IR_finance_question_string
                    this._runScreen({
                        title: "Galactic Stock Exchange",
                        overlay: "IR_GSE_logo.png",
                        messageKey: "IR_no_more_answer",
                        choicesKey: "IR_questions"
                    }, this.choiceEvaluation);
                    break;
                }
            }

            if (choice == "IR_A_shipment_question_key") {
                if (missionVariables.IR_shipment_question_no == 2 && !missionVariables.IR_GSE_loan) {
                    this._runScreen({
                        title: "Galactic Stock Exchange",
                        overlay: "IR_GSE_logo.png",
                        messageKey: "IR_GSE_loan_offer",
                        choicesKey: "IR_loan_choices"
                    }, function (choice) {
                        if (choice == "IR_loan_yes") {
                            this._runScreen({
                                title: "Galactic Stock Exchange",
                                overlay: "IR_GSE_logo.png",
                                messageKey: "IR_GSE_loan_agreed"
                            });
                            missionVariables.IR_GSE_loan = "ACCEPTED"
                            player.credits += 500000
                            missionVariables.IR_loan_deadline = clock.days + 60
                            missionVariables.IR_loan_remaining = missionVariables.IR_loan_deadline - clock.days
                            mission.setInstructionsKey("IR_loan_amount")
                            missionVariables.IR_offer = null
                        }
                        if (choice == "IR_loan_no") {
                            this._runScreen({
                                title: "Galactic Stock Exchange",
                                overlay: "IR_GSE_logo.png",
                                messageKey: "IR_GSE_loan_rejected",
                                choicesKey: "IR_questions"
                            }, this.choiceEvaluation);
                            missionVariables.IR_offer = null
                            missionVariables.IR_GSE_loan = "REJECTED"
                        }
                        if (choice == "IR_loan_defer") {
                            this._runScreen({
                                title: "Galactic Stock Exchange",
                                overlay: "IR_GSE_logo.png",
                                messageKey: "IR_GSE_loan_deferred",
                                choicesKey: "IR_questions"
                            }, this.choiceEvaluation);
                            missionVariables.IR_offer = "IR_GSE_QUESTIONS"
                            missionVariables.IR_GSE_loan = "DEFERRED"
                        }
                    });
                    break;
                }

                if (missionVariables.IR_GSE_loan == "DEFERRED") {
                    this._runScreen({
                        title: "Galactic Stock Exchange",
                        overlay: "IR_GSE_logo.png",
                        messageKey: "IR_GSE_loan_repeat_offer",
                        choicesKey: "IR_loan_choices"
                    }, function (choice) {
                        if (choice == "IR_loan_yes") {
                            this._runScreen({
                                title: "Galactic Stock Exchange",
                                overlay: "IR_GSE_logo.png",
                                messageKey: "IR_GSE_loan_agreed"
                            });
                            missionVariables.IR_GSE_loan = "ACCEPTED"
                            player.credits += 500000
                            missionVariables.IR_loan_deadline = clock.days + 60
                            missionVariables.IR_loan_remaining = missionVariables.IR_loan_deadline - clock.days
                            mission.setInstructionsKey("IR_loan_amount")
                            missionVariables.IR_offer = null
                        }
                        if (choice == "IR_loan_no") {
                            this._runScreen({
                                title: "Galactic Stock Exchange",
                                overlay: "IR_GSE_logo.png",
                                messageKey: "IR_GSE_loan_rejected",
                                choicesKey: "IR_questions"
                            }, this.choiceEvaluation);
                            missionVariables.IR_offer = "IR_GSE_QUESTIONS"
                            missionVariables.IR_GSE_loan = "REJECTED"
                        }
                        if (choice == "IR_loan_defer") {
                            this._runScreen({
                                title: "Galactic Stock Exchange",
                                overlay: "IR_GSE_logo.png",
                                messageKey: "IR_GSE_loan_deferred",
                                choicesKey: "IR_questions"
                            }, this.choiceEvaluation);
                            missionVariables.IR_offer = "IR_GSE_QUESTIONS"
                            missionVariables.IR_GSE_loan = "DEFERRED"
                        }
                    });
                    break;
                }

                if (missionVariables.IR_GSE_loan == "ACCEPTED") {
                    this._runScreen({
                        title: "Galactic Stock Exchange",
                        overlay: "IR_GSE_logo.png",
                        messageKey: "IR_GSE_loan_demand",
                        choicesKey: "IR_pay_choices"
                    }, function (choice) {
                        if (choice == "IR_pay_yes") {
                            this._runScreen({
                                title: "Galactic Stock Exchange",
                                overlay: "IR_GSE_logo.png",
                                messageKey: "IR_GSE_pay_accepted",
                                choicesKey: "IR_questions"
                            }, this.choiceEvaluation);
                            missionVariables.IR_GSE_loan = "PAID"
                            player.credits -= 550000
                            missionVariables.IR_loan_deadline = null
                            missionVariables.IR_loan_remaining = null
                            mission.setInstructionsKey(null)
                            missionVariables.IR_offer = "IR_GSE_QUESTIONS"
                        }
                        if (choice == "IR_pay_no") {
                            this._runScreen({
                                title: "Galactic Stock Exchange",
                                overlay: "IR_GSE_logo.png",
                                messageKey: "IR_GSE_pay_deferred",
                                choicesKey: "IR_questions"
                            }, this.choiceEvaluation);
                            missionVariables.IR_offer = "IR_GSE_QUESTIONS"
                        }
                    });
                    break;
                }
            }

            if (choice == "IR_E_exit_question_key")
                return;
            else
                this._runScreen({
                    title: "Galactic Stock Exchange",
                    overlay: "IR_GSE_logo.png",
                    messageKey: "IR_negative_answer",
                    choicesKey: "IR_questions"
                }, this.choiceEvaluation);
            missionVariables.IR_offer = "IR_GSE_QUESTIONS"
            break;
        }

        case "IR_KORSHKOV_QUESTIONS": {
            if (choice == "IR_B_finance_question_key") {
                if (missionVariables.IR_finance_question_no == 2) {
                    this._runScreen({
                        title: "OKB Korshkov",
                        overlay: "IR_korshlogo.png",
                        messageKey: "IR_KORSHKOV_finance_answer_1a",
                        choicesKey: "IR_continue"
                    }, function (choice) {
                        if (choice == 1) {
                            this.incrementFinanceQuestion()
                            this._runScreen({
                                title: "OKB Korshkov",
                                overlay: "IR_korshlogo.png",
                                messageKey: "IR_KORSHKOV_finance_answer_1b"
                            });
                            missionVariables.IR_offer = "IR_KORSHKOV_QUESTIONS"
                            missionVariables.IR_KORSHKOV_deadline = clock.days + 5
                            player.incrementFinanceStatus()
                            missionVariables.IR_offer = null
                            missionVariables.IR_finance_quest = "WAIT"
                        }
                    });
                    break;
                }

                if (missionVariables.IR_finance_question_no > 2) {
                    missionVariables.IR_asked_question = missionVariables.IR_finance_question_string
                    this._runScreen({
                        title: "OKB Korshkov",
                        overlay: "IR_korshlogo.png",
                        messageKey: "IR_no_more_answer",
                        choicesKey: "IR_questions"
                    }, this.choiceEvaluation);
                    break;
                }
            }


            if (choice == "IR_E_exit_question_key") {
                return;
            } else
                this._runScreen({
                    title: "OKB Korshkov",
                    overlay: "IR_korshlogo.png",
                    messageKey: "IR_negative_answer",
                    choicesKey: "IR_questions"
                }, this.choiceEvaluation);
            missionVariables.IR_offer = "IR_KORSHKOV_QUESTIONS"
            break;
        }

        case "IR_JANES_QUESTIONS": {
            if (choice == "IR_A_shipment_question_key") {
                this._runScreen({
                    title: "Jane's Shipyard Intelligence",
                    overlay: "IR_janes_logo.png",
                    messageKey: "IR_no_more_answer",
                    choicesKey: "IR_questions"
                }, this.choiceEvaluation);
                break;
            }

            if (choice == "IR_C_SDF_question_key") {
                if (missionVariables.IR_SDF_question_no == 1) {
                    this.incrementSDFQuestion()
                    this._runScreen({
                        title: "Jane's Shipyard Intelligence",
                        overlay: "IR_janes_logo.png",
                        messageKey: "IR_JANES_SDF_answer",
                        choicesKey: "IR_questions"
                    }, this.choiceEvaluation);
                    break;
                }

                if (missionVariables.IR_SDF_question_no > 1) {
                    this._runScreen({
                        title: "Jane's Shipyard Intelligence",
                        overlay: "IR_janes_logo.png",
                        messageKey: "IR_no_more_answer",
                        choicesKey: "IR_questions"
                    }, this.choiceEvaluation);
                    break;
                }
            }

            if (choice == "IR_D_defences_question_key") {
                this._runScreen({
                    title: "Jane's Shipyard Intelligence",
                    overlay: "IR_janes_logo.png",
                    messageKey: "IR_JANES_defences_answer",
                    choicesKey: "IR_questions"
                }, this.choiceEvaluation);
                break;
            }

            if (choice == "IR_E_exit_question_key")
                return;
            else
                this._runScreen({
                    title: "Jane's Shipyard Intelligence",
                    messageKey: "IR_negative_answer",
                    choicesKey: "IR_questions"
                }, this.choiceEvaluation);
            missionVariables.IR_offer = "IR_JANES_QUESTIONS"
            break;
        }

        case "IR_PIRATE_QUESTIONS": {
            if (choice == "IR_A_shipment_question_key") {
                if (missionVariables.IR_shipment_question_no == 2 && missionVariables.IR_shipment_quest == "SET") {
                    this._runScreen({
                        title: " ",
                        messageKey: "IR_PIRATE_shipment_answer",
                        choicesKey: "IR_continue"
                    }, function (choice) {
                        if (choice == 1)
                            this._runScreen({
                                title: " ",
                                messageKey: "IR_PIRATE_shipment_offer",
                                choicesKey: "IR_pirate_choices"
                            }, function (choice) {
                                if (choice == "IR_pirate_yes") {
                                    this._runScreen({
                                        title: " ",
                                        messageKey: "IR_PIRATE_shipment_accepted"
                                    });
                                    missionVariables.IR_alsto = "HELP_ACCEPTED"
                                    player.credits -= 250000
                                    player.incrementShipmentStatus()
                                    missionVariables.IR_offer = null
                                }
                                if (choice == "IR_pirate_no") {
                                    this._runScreen({
                                        title: " ",
                                        messageKey: "IR_PIRATE_shipment_declined"
                                    });
                                    missionVariables.IR_offer = null
                                    missionVariables.IR_alsto = "HELP_DECLINED"
                                }
                            });
                    });
                    break;
                }

                if (missionVariables.IR_shipment_question_no == 1) {
                    this._runScreen({
                        title: " ",
                        messageKey: "IR_negative_answer",
                        choicesKey: "IR_questions"
                    }, this.choiceEvaluation);
                    missionVariables.IR_offer = "IR_PIRATE_QUESTIONS"
                    break;
                }

                if (missionVariables.IR_shipment_question_no == 2 && missionVariables.IR_alsto == "HELP_ACCEPTED")
                    this._runScreen({
                        title: " ",
                        messageKey: "IR_PIRATE_shipment_confirm_help"
                    });


                if (missionVariables.IR_shipment_question_no == 2 && missionVariables.IR_alsto == "HELP_DECLINED") {
                    this._runScreen({
                        title: " ",
                        messageKey: "IR_PIRATE_shipment_deferred_help",
                        choicesKey: "IR_pirate_choices"
                    }, function (choice) {
                        if (choice == "IR_pirate_yes") {
                            this._runScreen({
                                title: " ",
                                messageKey: "IR_PIRATE_shipment_accepted"
                            });
                            missionVariables.IR_alsto = "HELP_ACCEPTED"
                            player.credits -= 250000
                            player.incrementShipmentStatus()
                            missionVariables.IR_offer = null
                        }
                        if (choice == "IR_pirate_no") {
                            this._runScreen({
                                title: " ",
                                messageKey: "IR_PIRATE_shipment_declined"
                            });
                            missionVariables.IR_offer = null
                            missionVariables.IR_alsto = "HELP_DECLINED"
                        }

                    });

                    if (missionVariables.IR_shipment_question_no == 2 && missionVariables.IR_shipment_quest != "SET") {
                        missionVariables.IR_asked_question = missionVariables.IR_shipment_question_string
                        this._runScreen({
                            title: " ",
                            messageKey: "IR_no_more_answer",
                            choicesKey: "IR_questions"
                        }, this.choiceEvaluation);
                        break;
                    }
                }
            }

            if (choice == "IR_C_SDF_question_key") {
                if (missionVariables.IR_SDF_question_no < 2)
                    this._runScreen({
                        title: " ",
                        messageKey: "IR_PIRATE_SDF_answer_1",
                        choicesKey: "IR_questions"
                    }, this.choiceEvaluation);

                if (missionVariables.IR_SDF_question_no == 2)
                    this._runScreen({
                        title: " ",
                        messageKey: "IR_PIRATE_SDF_answer_2",
                        choicesKey: "IR_questions"
                    }, this.choiceEvaluation);

                if (missionVariables.IR_SDF_question_no > 2) {
                    this._runScreen({
                        title: " ",
                        messageKey: "IR_no_more_answer",
                        choicesKey: "IR_questions"
                    }, this.choiceEvaluation);
                }
                break;
            }

            if (choice == "IR_E_exit_question_key")
                return;
            else
                this._runScreen({
                    title: " ",
                    messageKey: "IR_negative_answer",
                    choicesKey: "IR_questions"
                }, this.choiceEvaluation);
            missionVariables.IR_offer = "IR_PIRATE_QUESTIONS"
            break;
        }

        case "IR_YOKOHAMA_QUESTIONS": {
            if (choice == "IR_A_shipment_question_key") {
                if (missionVariables.IR_shipment_question_no == 1) {
                    this.incrementShipmentQuestion()
                    this._runScreen({
                        title: "Yokohama Exports",
                        overlay: "IR_yk_logo.png",
                        messageKey: "IR_YOKOHAMA_shipment_answer_1"
                    });
                    missionVariables.IR_YOKOHAMA_deadline = clock.days + 30
                    missionVariables.IR_shipment_quest = "SET"
                    missionVariables.IR_offer = null
                    player.incrementShipmentStatus()
                    break;
                }

                if (missionVariables.IR_shipment_question_no == 2 && clock.days < missionVariables.IR_YOKOHAMA_deadline) {
                    this._runScreen({
                        title: "Yokohama Exports",
                        overlay: "IR_yk_logo.png",
                        messageKey: "IR_YOKOHAMA_shipment_answer_2",
                        choicesKey: "IR_YOKOHAMA_choices"
                    }, function (choice) {
                        if (choice == "IR_YOKOHAMA_yes") {
                            if (player.credits >= 1000000) {
                                this._runScreen({
                                    title: "Yokohama Exports",
                                    overlay: "IR_yk_logo.png",
                                    messageKey: "IR_YOKOHAMA_shipment_agreed"
                                });
                                missionVariables.IR_shipment_quest = "SUCCESS"
                                missionVariables.IR_shipment_quest_method = "PURCHASED"
                                missionVariables.IR_YOKOHAMA_deadline = null
                                    ++missionVariables.IR_quest_count
                                this.incrementShipmentQuestion()
                                player.clearShipmentStatus()
                                missionVariables.IR_offer = null
                                player.credits -= 1000000
                            } else {
                                this._runScreen({
                                    title: "Yokohama Exports",
                                    overlay: "IR_yk_logo.png",
                                    messageKey: "IR_YOKOHAMA_shipment_nomoney"
                                });
                                missionVariables.IR_offer = null
                            }
                        }

                        if (choice == "IR_YOKOHAMA_no") {
                            this._runScreen({
                                title: "Yokohama Exports",
                                overlay: "IR_yk_logo.png",
                                messageKey: "IR_YOKOHAMA_shipment_declined"
                            });
                            missionVariables.IR_shipment_quest = "ENROUTE"
                            this.incrementShipmentQuestion()
                            missionVariables.IR_offer = null
                            if (missionVariables.IR_alsto) {
                                player.incrementShipmentStatus()
                            }
                        }

                        if (choice == "IR_YOKOHAMA_defer") {
                            this._runScreen({
                                title: "Yokohama Exports",
                                overlay: "IR_yk_logo.png",
                                messageKey: "IR_YOKOHAMA_shipment_defer"
                            });
                            missionVariables.IR_offer = null
                        }
                    });
                    break;
                }

                if (missionVariables.IR_shipment_question_no == 2 && clock.days > missionVariables.IR_YOKOHAMA_deadline) {
                    this._runScreen({
                        title: "Yokohama Exports",
                        overlay: "IR_yk_logo.png",
                        messageKey: "IR_YOKOHAMA_shipment_toolate"
                    });
                    missionVariables.IR_shipment_quest = "DISPATCHED"
                    player.clearShipmentStatus()
                    missionVariables.IR_offer = null
                    break;
                }

                if (missionVariables.IR_shipment_question_no > 2) {
                    missionVariables.IR_asked_question = missionVariables.IR_shipment_question_string
                    this._runScreen({
                        title: "Yokohama Exports",
                        overlay: "IR_yk_logo.png",
                        messageKey: "IR_no_more_answer",
                        choicesKey: "IR_questions"
                    }, this.choiceEvaluation);
                    break;
                }
            }

            if (choice == "IR_E_exit_question_key")
                return;
            else
                this._runScreen({
                    title: "Yokohama Exports",
                    overlay: "IR_yk_logo.png",
                    messageKey: "IR_negative_answer",
                    choicesKey: "IR_questions"
                }, this.choiceEvaluation);
            missionVariables.IR_offer = "IR_YOKOHAMA_QUESTIONS"
            break;
        }

        case "IR_PW_QUESTIONS": {
            if (choice == "IR_C_SDF_question_key") {
                if (missionVariables.IR_SDF_question_no == 2) {
                    this._runScreen({
                        title: "PleasureWorld",
                        overlay: "IR_pw_logo.png",
                        messageKey: "IR_PW_SDF_answer_1",
                        choicesKey: "IR_continue"
                    }, function (choice) {
                        if (choice == 1) {
                            this.incrementSDFQuestion()
                            this._runScreen({
                                title: " ",
                                messageKey: "IR_SDF_quest_1"
                            });
                            missionVariables.IR_SDF_quest = "ADDRESS"
                            missionVariables.IR_SDF_deadline = clock.days + 10
                        }
                    });
                    break;
                }

                if (missionVariables.IR_SDF_question_no == 3) {
                    this._runScreen({
                        title: "PleasureWorld",
                        overlay: "IR_pw_logo.png",
                        messageKey: "IR_no_more_answer",
                        choicesKey: "IR_questions"
                    }, this.choiceEvaluation);
                    break;
                }

                if (missionVariables.IR_SDF_question_no == 5) {
                    this._runScreen({
                        title: "PleasureWorld",
                        overlay: "IR_devries.png",
                        messageKey: "IR_PW_SDF_answer_2"
                    });
                    this.incrementSDFQuestion()
                    missionVariables.IR_SDF_quest = "PHOTO"
                    missionVariables.IR_SDF_deadline = clock.days + 35
                } else {
                    this._runScreen({
                        title: "PleasureWorld",
                        overlay: "IR_pw_logo.png",
                        messageKey: "IR_negative_answer",
                        choicesKey: "IR_questions"
                    }, this.choiceEvaluation);
                }
                break;
            }

            if (choice == "IR_E_exit_question_key") {
                missionVariables.IR_offer = "IR_ASKED"
                return;
            } else
                this._runScreen({
                    title: "PleasureWorld",
                    overlay: "IR_pw_logo.png",
                    messageKey: "IR_negative_answer",
                    choicesKey: "IR_questions"
                }, this.choiceEvaluation);
            missionVariables.IR_offer = "IR_PW_QUESTIONS"
            break;
        }

        case "IR_NWE_QUESTIONS": {
            if (choice == "IR_C_SDF_question_key") {
                if (missionVariables.IR_SDF_question_no == 4) {
                    this._runScreen({
                        title: "Naval Weapons Establishment",
                        overlay: "IR_NWE_logo.png",
                        messageKey: "IR_NWE_SDF_answer_1a",
                        choicesKey: "IR_continue"
                    }, function (choice) {
                        if (choice == 1) {
                            this.incrementSDFQuestion()
                            this._runScreen({
                                title: " ",
                                overlay: "IR_NWE_logo.png",
                                messageKey: "IR_NWE_SDF_answer_1b"
                            });
                        }
                        missionVariables.IR_offer = null
                    });
                }

                if (missionVariables.IR_SDF_question_no < 4 || missionVariables.IR_SDF_question_no > 4) {
                    this._runScreen({
                        title: "Naval Weapons Establishment",
                        overlay: "IR_NWE_logo.png",
                        messageKey: "IR_negative_answer",
                        choicesKey: "IR_questions"
                    }, this.choiceEvaluation);
                }
                break;
            }

            if (choice == "IR_D_defences_question_key") {
                if (missionVariables.IR_defences_question_no < 3) {
                    this._runScreen({
                        title: "Naval Weapons Establishment",
                        overlay: "IR_NWE_logo.png",
                        messageKey: "IR_NWE_defences_answer_1"
                    });
                    missionVariables.IR_defences_question_no = 3
                    missionVariables.IR_offer = null
                    player.incrementDefencesStatus()
                    break;
                }

                if (missionVariables.IR_defences_question_no == 3) {
                    this._runScreen({
                        title: "Naval Weapons Establishment",
                        overlay: "IR_NWE_logo.png",
                        messageKey: "IR_no_more_answer",
                        choicesKey: "IR_questions"
                    }, this.choiceEvaluation);
                    break;
                }
            }

            if (choice == "IR_E_exit_question_key")
                return;
            else
                this._runScreen({
                    title: "Naval Weapons Establishment",
                    messageKey: "IR_negative_answer",
                    choicesKey: "IR_questions"
                }, this.choiceEvaluation);
            missionVariables.IR_offer = "IR_NWE_QUESTIONS"
            break;
        }

        case "IR_MAENES_QUESTIONS": {
            if (choice == "IR_D_defences_question_key") {
                if (missionVariables.IR_defences_question_no == 1) {
                    this._runScreen({
                        title: "QuiCo Pharmaceuticals",
                        overlay: "IR_quico_logo.png",
                        messageKey: "IR_MAENES_defences_answer_1"
                    });
                    this.incrementDefencesQuestion()
                    missionVariables.IR_offer = null
                    missionVariables.IR_Maenes_visit = "TRUE"
                    break;
                }

                if (missionVariables.IR_defences_question_no >= 2) {
                    this._runScreen({
                        title: "QuiCo Pharmaceuticals",
                        overlay: "IR_quico_logo.png",
                        messageKey: "IR_no_more_answer",
                        choicesKey: "IR_questions"
                    }, this.choiceEvaluation);
                    break;
                }
            }

            if (choice == "IR_E_exit_question_key")
                return;
            else
                this._runScreen({
                    title: "QuiCo Pharmaceuticals",
                    overlay: "IR_quico_logo.png",
                    messageKey: "IR_negative_answer",
                    choicesKey: "IR_questions"
                }, this.choiceEvaluation);
            missionVariables.IR_offer = "IR_MAENES_QUESTIONS"
            break;
        }
    }
}
