/*
draven_station.js

Script for draven.oxp version 1.0.

Oolite
Copyright © 2004-2011 Giles C Williams and contributors

This work is licensed under the Creative Commons
Attribution-Noncommercial-Share Alike 3.0 Unported License.

To view a copy of this license, visit
http://creativecommons.org/licenses/by-nc-sa/3.0/ or send a letter
to Creative Commons, 171 Second Street, Suite 300, San Francisco,
California, 94105, USA.
*/

"use strict";
this.name = "draven_station";
this.description = "Script for draven station";
this.author = "Ironfist";
this.copyright = "© 2011 Ironfist";
this.license = "CC-by-nc-sa 3.0";
this.version = "1.2";

this.debug = false;

//-------------------------------------------------------------------------------------------------------------
this.startUp = function () {
	this.draven_station_log = 0;
	if (this.debug) log(this.name, "Initialising " + player.ship.dockedStation.name);
}

//-------------------------------------------------------------------------------------------------------------
this.startUpComplete = function() {
	if (worldScripts["Docking Fees"]) {
		this._feeTimer = new Timer(this, this.$updateFee.bind(this), 2, 0);
	}
}

//-------------------------------------------------------------------------------------------------------------
this.$updateFee = function $updateFee() {
	worldScripts["Docking Fees"].$addFee("draven_st", {fee:0, messageKey:""});
	worldScripts["Docking Fees"].$addFee("draven_c", {fee:0, messageKey:""});
}

//-------------------------------------------------------------------------------------------------------------
this.shipDockedWithStation = function(station) {
	if (station.dataKey == "draven_station") this.$removeNonDravenShips(station);
}

//-------------------------------------------------------------------------------------------------------------
this.shipWillEnterWitchspace = function() {
	if (this._msgTimer && this._msgTimer.isRunning) this._msgTimer.stop();
}

//-------------------------------------------------------------------------------------------------------------
this.systemWillPopulate = function() {
	if (galaxyNumber == 5 && system.ID == 25) {
		var posDS = Vector3D(0.2, 0.6, 1.5).fromCoordinateSystem("wpu");
		system.setPopulator("draven_populator", {
			location: "COORDINATES",
			coordinates: posDS,
			deterministic:true,
			callback: function(pos) {
				var dr = system.addShips("draven_st", 1, pos, 0);
				if (!dr || dr.length === 0) {
					log("draven_populator", "OOPS! No station spawned");
				} else {
					var ds = worldScripts.draven_station;
					ds._station = dr[0];
					ds._msgTimer = new Timer(ds, ds.$transmitInitialHail.bind(ds), 3, 3);
					// only put a beacon on the station if the player has fully docked once.
					if (missionVariables.DravenStation_Docked) {
						dr[0].beaconCode = "O";
						dr[0].beaconLabel = expandMissionText("dr_station_name");
					}
				}
			}}
		);
	}
}

//-------------------------------------------------------------------------------------------------------------
this.$transmitInitialHail = function $transmitInitialHail() {
	if (player.ship.docked && player.ship.dockedStation.dataKey == "draven_station") {
		this._msgTimer.stop();
		return;
	}
	if (player.ship.docked) return; // don't do calcs when docked

	var dist = this._station.position.distanceTo(player.ship);
	if (dist < player.ship.scannerRange * 0.95) {
		var msg = "[Oodulldoff-station-hail]";
		if (player.ship.hasRole("drvn")) {
			msg = "[Oodulldoff-station-hail-draven]";
		}
		this._station.commsMessage(expandDescription(msg), player.ship);
		this._msgTimer.stop();
	}
}

//-------------------------------------------------------------------------------------------------------------
this.$removeNonDravenShips = function (station) {
	var i = station.shipyard.length;
	var d_force = ["draven_gunship-player", "draven_carrier-player", "draven_raider-player", "draven_shuttle-player", "kracken-player"];
	while (i--) {
		var key = station.shipyard[i].shipdata_key;
		if (key.indexOf("draven") == -1 && key.indexOf("kracken") == -1) {
			if (this.debug) log(this.name, "removing " + key);
			station.removeShipFromShipyard(i);
		} else {
			if (d_force.indexOf(key) >= 0) d_force.splice(d_force.indexOf(key), 1);
		}
	}
	// make sure there is at least 1 of each type of draven ship in the shipyard
	if (d_force.length > 0) {
		for (var i = 0; i < d_force.length; i++) {
			var shp = Ship.shipDataForKey(d_force[i]);
			var desc = [];
			var std = shp._oo_shipyard.standard_equipment.extras; 
			for (var j = 0; j < std.length; j++) {
				if (std[j] != "EQ_DRAVEN") {
					log(this.name, std[j]);
					var eq = EquipmentInfo.infoForKey(std[j]);
					desc.push(eq.name);
				}
			}
			if (shp._oo_shipyard.forward_weapon_type) std.push(shp._oo_shipyard.forward_weapon_type);
			if (shp._oo_shipyard.aft_weapon_type) std.push(shp._oo_shipyard.aft_weapon_type);
			var final = "";
			for (var j = 0; j < desc.length; j++) {
				final += (final == "" ? "" : (j == desc.length - 1 ? expandMissionText("dr_and") : ", ")) + desc[j];
			}
			station.addShipToShipyard({ 
				short_description: shp.name + ": " + expandMissionText("dr_with") + final + ". " + expandMissionText("dr_price") + formatCredits(parseFloat(shp._oo_shipyard.price), false, true), 
				shipdata_key:d_force[i], 
				price:shp._oo_shipyard.price, 
				personality:Math.floor(Math.random() * 32768), 
				extras:std
			});			
		}
	}
}

//-------------------------------------------------------------------------------------------------------------
this.missionScreenOpportunity = function () {
	this.missionScreens();
}

//-------------------------------------------------------------------------------------------------------------
this.missionScreens = function () {
	if (guiScreen == "GUI_SCREEN_MISSION" || !player.ship.docked) return;
	if (player.ship.docked && player.ship.dockedStation.hasRole("draven_st") && this.draven_station_log == 0) {
		if (this.debug) {
			var shipRoles = "";
			shipRoles = player.ship.roles;
			var subCounter = shipRoles.length;
			log(this.name, "A " + player.ship.name + " docked at " + player.ship.dockedStation.name + " " + player.ship.roles.length);
			while (subCounter--) { 
				if (this.debug) log(this.name, shipRoles[subCounter]); 
			}
		}
		this.draven_station_log += 1;
		// free fuel and entrance if we built the ship
		if (player.ship.equipmentStatus("EQ_DRAVEN") === "EQUIPMENT_OK") {
			// display dr_mt_1
			mission.runScreen({ title: "Oodulldoff Station Welcome", messageKey: "dr_mt_0" });
			if (this.debug) log(this.name, "Fuel added");
			player.ship.fuel = 7.0;
		} else {
			if (this.debug) log(this.name, "A " + player.ship.name + " docked at " + player.ship.dockedStation.name);
			// display dr_mt_10
			mission.runScreen({ title: expandMissionText("dr_welcome_title"), messageKey: "dr_mt_10", choicesKey: "dr_choices" }, this.choices);
		}
	}
}

//-------------------------------------------------------------------------------------------------------------
this.shipWillLaunchFromStation = function (station) {
	this.draven_station_log = 0;
}

//-------------------------------------------------------------------------------------------------------------
this.choices = function (choice) {
	switch (choice) {
		case "1_Yes":
			if (this.debug) log(this.name, "Yes");
			player.credits -= 1000;
			this.showScreen = "firstPage";
			missionVariables.DravenStation_Docked = true;
			break;
		case "2_No":
			if (this.debug) log(this.name, "No");
			player.ship.launch();
			break;
	}
}