"use strict";
this.name = "Draven_Markets";
this.author = "phkb";
this.copyright = "2024 phkb";
this.license = "CC BY-NC-SA 4.0";

this.$originalDefs = {
    "oodulldoff1": {
        "food": [0, 0, 20, -2, 0, 0, 3, 0, 0],
        "textiles": [0, 0, 20, -1, 0, 0, 3, 0, 0],
        "radioactives": [0, 0, 42, -3, -3, 1, 7, 15, 0],
        "slaves": [0, 0, 40, -5, 0, 0, 31, 0, 0],
        "liquor_wines": [0, 0, 105, -5, 0, 0, 15, 0, 0],
        "luxuries": [0, 0, 190, 8, 0, 0, 9, 0, 0],
        "narcotics": [0, 0, 235, 29, 0, 0, 120, 0, 0],
        "computers": [0, 0, 140, 14, 0, 0, 15, 0, 0],
        "machinery": [0, 0, 120, 6, 0, 0, 15, 0, 0],
        "alloys": [0, 0, 70, 1, 0, 10, 15, 15, 0],
        "firearms": [0, 0, 100, 13, 0, 0, 31, 0, 0],
        "furs": [0, 0, 160, -9, 0, 0, 63, 0, 0],
        "minerals": [0, 0, 16, -1, -3, 10, 3, 31, 0],
        "gold": [0, 0, 73, -1, -1, 5, 7, 3, 1],
        "platinum": [0, 0, 145, -2, -2, 6, 31, 7, 1],
        "gem_stones": [0, 0, 25, -1, -1, 5, 15, 10, 2],
        "alien_items": [0, 0, 100, 1, 0, 0, 31, 0, 0]
    },
    "oodulldoff2": {
        "food": [0, 0, 15, -2, 0, 0, 3, 0, 0],
        "textiles": [0, 0, 15, -1, 0, 0, 3, 0, 0],
        "radioactives": [0, 0, 35, -3, -3, 1, 7, 15, 0],
        "slaves": [0, 0, 30, -5, 0, 0, 31, 0, 0],
        "liquor_wines": [0, 0, 105, -5, 0, 0, 15, 0, 0],
        "luxuries": [0, 0, 190, 8, 0, 0, 9, 0, 0],
        "narcotics": [0, 0, 235, 29, 0, 0, 120, 0, 0],
        "computers": [0, 0, 140, 14, 0, 0, 15, 0, 0],
        "machinery": [0, 0, 120, 6, 0, 0, 15, 0, 0],
        "alloys": [0, 0, 50, 1, 0, 10, 15, 15, 0],
        "firearms": [0, 0, 100, 13, 0, 0, 31, 0, 0],
        "furs": [0, 0, 160, -9, 0, 0, 63, 0, 0],
        "minerals": [0, 0, 12, -1, -3, 10, 3, 31, 0],
        "gold": [0, 0, 73, -1, -1, 5, 7, 3, 1],
        "platinum": [0, 0, 145, -2, -2, 6, 31, 7, 1],
        "gem_stones": [0, 0, 25, -1, -1, 5, 15, 10, 2],
        "alien_items": [0, 0, 100, 1, 0, 0, 31, 0, 0]
    },
};

//-------------------------------------------------------------------------------------------------------------
this.startUp = function() {
	var msi = worldScripts.MarketScriptInterface_Main;
	msi.$addMarketInterface("station_local", "$updateLocalCommodityDefinition", this.name);
}

//-------------------------------------------------------------------------------------------------------------
this.$updateLocalCommodityDefinition = function (goodDefinition, station) {

	if (!station) return goodDefinition;
    if (station.dataKey != "draven_station") return goodDefinition;

	var key = "oodulldoff1";
    if (player.ship.equipmentStatus("EQ_DRAVEN") === "EQUIPMENT_OK") {
        key = "oodulldoff2";
    }

    var commodity = goodDefinition.key;
    if (this.$originalDefs[key] == undefined) return goodDefinition;
    var oldDefs = this.$originalDefs[key][commodity];

    if (oldDefs) {
        var market_base_price = oldDefs[2];
        var market_eco_adjust_price = oldDefs[3];
        var market_eco_adjust_quantity = oldDefs[4];
        var market_base_quantity = oldDefs[5];
        var market_mask_price = oldDefs[6];
        var market_mask_quantity = oldDefs[7];
        var market_rnd = Math.floor(Math.random() * 256);

        var economy = system.economy;

        var price = (market_base_price + (market_rnd & market_mask_price) + (economy * market_eco_adjust_price)) & 255;
        price *= 0.4;

        var quantity = (market_base_quantity + (market_rnd & market_mask_quantity) - (economy * market_eco_adjust_quantity)) & 255;
        if (quantity > 127) quantity = 0;
        quantity &= 63;

        goodDefinition.price = price * 10;
        goodDefinition.quantity = quantity;
    }
    //no definition found. nullify the goods.
    else {
        goodDefinition.price = 0;
        goodDefinition.quantity = 0;
    }
    return goodDefinition;
}
