"use strict";
this.name        = "Draven_Conditions";
this.author      = "phkb";
this.copyright   = "2024 phkb";
this.description = "Condition script for ships and equipment.";
this.licence     = "CC BY-NC-SA 3.0";

//-------------------------------------------------------------------------------------------------------------
this.allowAwardEquipment = function (equipment, ship, context) {
    if (context === "scripted") return true;
    return false;
}

//-------------------------------------------------------------------------------------------------------------
this.allowOfferShip = function(shipKey) {
    if (system.ID == 25 && galaxyNumber == 5 && player.ship.docked && player.ship.dockedStation.dataKey == "draven_station") return true;
    log(this.name, "shipKey " + shipKey);
    return false;
}

//-------------------------------------------------------------------------------------------------------------
this.allowSpawnShip = function(shipKey) {
    // always allow the player ship
    if (shipKey.indexOf("-player") >= 0) return true;
    switch (shipKey) {
        case "draven_raider":
        case "draven_gunship":
        case "draven_trader":
        case "draven_shuttle":
        case "draven_carrier":
        case "kracken":
            if (galaxyNumber == 5) return true;
    }
    return false;
}