/*
========================================================================
extraThargoids_uber.js

This file is part of the ExtraThargoids expansion pack.
Author: UK_Eliter
License: 2017 Creative Commons: attribution, non-commercial, sharealike.
========================================================================
*/

/*
-------------------
JSLINT: set options
-------------------
*/

/*jshint esversion: 6*/
/*jshint sub:true*/



this.name = "thargoid_uberbuggly";
this.author = "UK_Eliter";
this.copyright = "2014 Creative Commons: attribution, non-commercial, sharealike.";
this.licence = "CC-NC-SA 3";
this.description = "Script for the 'uberbuggly' Thargon ships";


/*
------------------
DEBUGGING SWITCHES
------------------
*/

// this.logging = true;
var consoleDebugMessages = false; // do NOT comment this out. Rather, to disable, set to false.


/*
------
SOUNDS
------
*/

var mysound_Warning = new SoundSource();
mysound_Warning.sound = "warning.ogg"; // this sound built-in to Oolite - and does not need to be declared in the 'customsounds' file.


/*
------------------------
JSHINT: start of wrapper
------------------------
*/

(function() {
	"use strict";


	/*
	--------------
	EVENT HANDLERS
	--------------
	*/

	this.shipTargetCloaked = function() {
		var seconds;

		if (this.decloakTargetTimer && this.decloakTargetTimer.isRunning) {
			return;
		}
		if (this.ship.target.isThargoid) {
			return;
		}
		if (Math.random() < 0.13) {
			return;
		}
		if (Math.random() > 0.4) {
			this.ship.commsMessage(expandDescription("[thargoid_curses]"));
		}
		this.ship.cloakedTarget = this.ship.target;
		seconds = (1 + Math.floor(Math.random() * 6));
		if (this.decloakTargetTimer) {
			delete this.decloakTargetTimer;
		}
		this.decloakTargetTimer = new Timer(this, this.$decloakTargetTimed, seconds);
	};

	this.shipDied = this.entityDestroyed = this.playerWillEnterWitchspace = function() {
		this.$_deleteTimers();
	};


	/*
	------------
	CALLED BY AI
	------------
	*/

	this.$_deleteTimers = function() {
		if (!this.decloakTargetTimer) {
			return;
		}
		if (this.decloakTargetTimer.isRunning) {
			this.decloakTargetTimer.stop();
		}
		delete this.decloakTargetTimer;
	};

	this.$_deleteTimersAndSetMisJump = function() {
		this.ship.scriptedMisjump = true;
		this.$_deleteTimers();
	};

	this.$_curse = function() {
		this.ship.commsMessage(expandDescription("[thargoid_curses]"));
	};

	this.$_possiblyCurse = function() {
		if (Math.random() < 0.35) {
			this.ship.commsMessage(expandDescription("[thargoid_curses]"));
		}
	};

	this.$_fireQuirium = function() {
		this.ship.awardEquipment("EQ_QC_MINE");
		this.ship.fireMissile("EQ_QC_MINE");
		this.$_possiblyCurse();
		this.$_deleteTimers();
	};


	/*
	-----
	OTHER
	-----
	*/

	this.$decloakTargetTimed = function() {
		this.decloakTargetTimer.stop();
		if (!this.ship || !this.ship.isValid) {
			delete this.decloakTargetTimer;
			return;
		}
		if (!this.ship.cloakedTarget || !this.ship.cloakedTarget.isValid) {
			delete this.decloakTargetTimer;
			return;
		}
		if (!this.ship.cloakedTarget.isCloaked) {
			delete this.decloakTargetTimer;
			return;
		}
		this.distanceToTarget = this.ship.position.distanceTo(this.ship.cloakedTarget);
		if (this.distanceToTarget < 10000) {
			mysound_Warning.play();
			this.ship.cloakedTarget.lightsActive = true;
			if (Math.random() > 0.9) {
				this.ship.cloakedTarget.setEquipmentStatus("EQ_CLOAKING_DEVICE", "EQUIPMENT_DAMAGED");
				if (this.ship.cloakedTarget.isPlayer && !player.ship) {
					delete this.decloakTargetTimer;
					return;
				}
				this.ship.commsMessage("CLOAKING DEVICE DAMAGED!", this.ship.cloakedTarget);
				this.ship.target = this.ship.cloakedTarget;
				this.ship.reactToAIMessage("TARGET_REGAINED");
			} else {
				player.consoleMessage("CLOAKING FAILURE!", 10);
				player.ship.isCloaked = false;
				this.ship.target = this.ship.cloakedTarget;
				this.ship.reactToAIMessage("TARGET_REGAINED");
			}
		}
		if (Math.random() < 0.26) {
			this.ship.commsMessage(expandDescription("[thargoid_curses]"));
		}
		delete this.decloakTargetTimer;
	};


	/*
	----------------------
	JSHINT: end of wrapper
	----------------------
	*/

}).call(this);

// EOF