/*
========================================================================
extraThargoids_frigatePoet.js

This file is part of the ExtraThargoids expansion pack.
Author: UK_Eliter
License: 2017 Creative Commons: attribution, non-commercial, sharealike.
========================================================================
*/

/*
-------------------
JSLINT: set options
-------------------
*/

/*jshint esversion: 6*/
/*jshint sub:true*/


this.name = "extraThargoids_frigatePoet";
this.author = "UK_Eliter";
this.copyright = "2014 Creative Commons: attribution, non-commercial, sharealike.";
this.licence = "CC-NC-SA 3";
this.description = "extraThargoids_frigatePoet";

// NB: There is no special AI - but rather an inbuilt one - corresponding to this script.


/*
-------------
VARIABLES etc
-------------
*/

this.displace = new SoundSource();
this.displace.sound = "extraThargoids_displacement.ogg";

this.quietDisplace = new SoundSource();
this.quietDisplace.sound = "[extraThargods_displacementQuiet.ogg]";

this.warning = new SoundSource();
this.warning.sound = "warning.ogg"; // this sound built-in to Oolite - and does not need to be declared in the 'customsounds' file.


/*
------------------------
JSHINT: start of wrapper
------------------------
*/

(function() {
	"use strict";


	/*
	--------------
	EVENT HANDLERS
	--------------
	*/

	this.shipSpawned = function() {
		this.canDisplaceCurrently = true;
		delete this.shipSpawned;
	};

	this.shipDied = this.entityDestroyed = this.playerWillEnterWitchspace = function() {
		this.$cleanUp();
	};

	this.shipAttackedWithMissile = function() // run by oolite core itself {
	{
		if (Math.random() > 0.7) {
			return;
		}
		this.ship.isCloaked = true;
		// but if can't cloak . .
		if (this.ship.isCloaked === false) {
			this.$displace();
		}
	};

	this.shipTargetCloaked = function() {
		if (Math.random() > 0.82) {
			this.$displace();
		}
		if (this.ship.target) {
			this.ship.target = null;
		}
	};

	this.shipEnergyIsLow = function() {
		if (Math.random() > 0.13) {
			this.ship.isCloaked = false;
			this.$displace();
		}
	};


	/*
	-----
	OTHER
	-----
	*/

	// Following code includes parts adapted from Thargoid's armoury_displacerMissile.js script in his Armoury OXP.

	this.$displace = function() {
		if (this.canDisplaceCurrently === false || !this.ship) {
			return;
		}
		if (this.ship.fuel < 4) {
			this.canDisplaceCurrently = false;
			return;
		}
		this.canDisplaceCurrently = false;
		if (this.timerToReenableDisplace) {
			if (this.timerToReenableDisplace.isRunning) {
				this.timerToReenableDisplace.stop(); // should never happen
			}
			delete this.timerToReenableDisplace;
		}
		if (!player.ship.position) {
			return;
		}
		var ps = player.ship; // for speed, but changes won't affect the original variable
		var xDistance = ((Math.random() * 2) - 1) * 8600;
		var yDistance = ((Math.random() * 2) - 1) * 8600;
		var zDistance = ((Math.random() * 2) - 1) * 8600;
		this.ship.position = this.ship.position.add([xDistance, yDistance, zDistance]);
		if (Math.random() < 0.7) {
			this.ship.commsMessage(expandDescription("[thargoid_curses]"), ps);
		}
		var shipDistanceToDisplacedShip = this.ship.position.distanceTo(ps.position); // would be good to alter the following to occur to ANY ship within the specified range . .
		var displacementChance = 0;
		this.ship.position = this.ship.position.add([xDistance, yDistance, zDistance]);
		this.ship.isCloaked = false;
		if (shipDistanceToDisplacedShip < 1200) {
			if (shipDistanceToDisplacedShip < 500) {
				displacementChance = 0.5;
			} else {
				displacementChance = 0.2;
			}
		}
		if (shipDistanceToDisplacedShip < 12000) {
			this.displace.play();
		} else if (shipDistanceToDisplacedShip < 18000) {
			this.quietDisplace.play();
		}
		this.ship.fuel -= (Math.ceil(Math.random() * 5)); // drain off some fuel to simulate the jump
		if (this.ship.target) {
			if (Math.random() < 0.5) {
				this.ship.target = null;
			}
		}
		if (Math.random() <= displacementChance) {
			player.ship.position = player.ship.position.add([xDistance, yDistance, zDistance]);
			this.warning.play();
			player.consoleMessage("EMERGENCY - position changed by nearby displacement device", 6);
			if (Math.random() < 0.1) {
				player.ship.scriptedMisjump = true;
				player.ship.scriptedMisjumpRange = r;
			}
		}
		var t = 8 + Math.ceil(Math.random() * 6);
		this.timerToReenableDisplace = new Timer(this, this.$reenableDisplace, t);
	};

	this.$reenableDisplace = function $reenableDisplace() {
		this.canDisplaceCurrently = true;
	};

	this.$cleanUp = function() {
		this.canDisplaceCurrently = true;
		if (this.timerToReenableDisplace) {
			if (this.timerToReenableDisplace.isRunning) {
				this.timerToReenableDisplace.stop();
			}
			delete this.timerToReenableDisplace;
		}
	};


	/*
	----------------------
	JSLINT: end of wrapper
	----------------------
	*/

}).call(this);

// EOF