/*
========================================================================
extraThargoids_exploding_generic.js

This file is part of the ExtraThargoids expansion pack.
Author: UK_Eliter
License: 2017 Creative Commons: attribution, non-commercial, sharealike.
========================================================================
*/

/*
-------------------
JSLINT: set options
-------------------
*/

/*jshint esversion: 6*/
/*jshint sub:true*/


this.name = "extraThargoids_exploding_generic";
this.author = "UK_Eliter";
this.copyright = "2014 Creative Commons: attribution, non-commercial, sharealike.";
this.licence = "CC-NC-SA 3";
this.description = "Script for exploding 'Gruntbuggly' Thargon ships";



/*
------------------------------------------------------
CORRESPONDING AIs:
  
  	- extraThargoids_exploding_causedByPlayerAI.plist
	- extraThargoids_exploding_notCausedByPlayerAI.plist
------------------------------------------------------


/*
------------------
DEBUGGING SWITCHES
------------------
*/

// this.logging = true; // THIS SHOULD BE COMMENTED OUT WHEN NOT TESTING
// this.ship.reportAIMessages = true; // if set to true, continuously dumps AI stuff to log - and produces vector lines.
// var consoleDebugMessages = false;


/*
------
SOUNDS
------
*/

this.bigBang = new SoundSource();
this.bigBang.sound = "bigbang.ogg";

this.mediumBang = new SoundSource();
this.mediumBang.sound = "extraThargoids_mediumBang.ogg";

this.quietBang = new SoundSource();
this.quietBang.sound = "extraThargoids_quietBang.ogg";


/*
------------------------
JSLINT: start of wrapper
------------------------
*/

(function() {
	"use strict";


	/*
	--------------
	EVENT HANDLERS
	--------------
	*/

	this.shipDied = this.entityDestroyed = function() {
		var frags = this.ship.spawn("explosive_shrapnel", 3);
	};


	/*
	-------------
	CALLED BY AIs
	-------------
	*/

	this.$_bountyHack = function() {
		if (this.ship.isValid && this.ship.newBounty && (this.ship.newBounty > 0)) {
			this.ship.bounty = this.ship.newBounty;
		}
	};

	this.$_explode_core = function() {
		this.ship.dealEnergyDamage(980, 1750);
		// SYNTAX: function dealEnergyDamage(damage : Number, idealRange : Number [, velocityBias : Number])
		this.$bangSoundEffect();
	};

	this.$_explode_notCausedByPlayer = function() {
		this.$_explode_core();
	};

	this.$_explode_causedByPlayer = function() {
		var bounty;
		this.$_explode_core();
		player.score += 1;
		if (!this.ship.isValid || !this.ship || this.ship.bounty == 0) {
			bounty = 200;
		} else {
			bounty = this.ship.bounty;
		}
		var string = "Bounty: " + bounty;
		player.consoleMessage(string, 6);
		player.credits += bounty;
		if (player.ship.isValid && Math.random() < 0.15) {
			string = "The navy has awarded a 500 credit bonus!";
			player.consoleMessage(string, 8);
			player.credits += 500;
		}
	};


	/*
	-----
	OTHER
	-----
	*/

	this.$bangSoundEffect = function() {
		if (!this.ship || !this.ship.position || !player.ship.position) {
			return;
		}
		var ps = player.ship; // for speed, but changes won't affect the original variable
		if (this.ship.position.distanceTo(ps.position) < 2000) {
			this.bigBang.play(); // this one really is VERY loud, so only use for VERY close
			return;
		}
		if (this.ship.position.distanceTo(ps.position) < 15000) {
			this.mediumBang.play();
			return;
		}
		if (this.ship.position.distanceTo(ps.position) < 27000) {
			this.quietBang.play();
		}
	};


	/*
	-----------------------
	JSHINT: end of wrapper
	----------------------
	*/

}).call(this);

// EOF