/*
========================================================================
extraThargoids_buggly.js

This file is part of the ExtraThargoids expansion pack.
Author: UK_Eliter
License: 2017 Creative Commons: attribution, non-commercial, sharealike.
========================================================================

*/

/*
-------------------
JSLINT: set options
-------------------
*/

/*jshint esversion: 6*/
/*jshint sub:true*/


this.name = "extraThargoids_buggly";
this.author = "UK_Eliter";
this.copyright = "2014 Creative Commons: attribution, non-commercial, sharealike.";
this.licence = "CC-NC-SA 3";
this.description = "Script for the 'Gruntbuggly' Thargon ships";


/*
-----------------------------------------------------------------------
Corresponding AIs:

	- extraThargoids_bugglyAI.plist (which sends no messages to script)

	- extraThargoids_kamikazeAI
-----------------------------------------------------------------------
*/



/*
------------------
DEBUGGING SWITCHES
------------------
*/

// this.logging = true;
var consoleDebugMessages = false; // do NOT comment this out. Rather, to disable, set to false.


/*
------
SOUNDS
------
*/

var mysound_Warning = new SoundSource();
mysound_Warning.sound = "warning.ogg";
//	This sound is built-in to Oolite - and does not need to be declared in the 'customsounds' file.


/*
------------------------
JSHINT: start of wrapper
------------------------
*/

(function() {
	"use strict";


	/*
	--------------
	EVENT HANDLERS
	--------------
	*/

	this.shipSpawned = function() {
		// set timer to check for stun bomb from Armoury OXP - and give some buggly models missiles
		if (worldScripts["armoury_machineScript.js"]) {
			this.checkStun = new Timer(this, this.$checkStunTimed, 12, 12);
		}
		delete this.shipSpawned;
	};

	this.shipDied = this.entityDestroyed = this.playerWillEnterWitchspace = function() {
		this.$deleteTimers();
	};

	this.shipTakingDamage = function(amount, whom, type) {
		if ((amount < 50) && (this.ship.energy > 19)) {
			return;
		}
		var chance;
		if (amount > 49) {
			if (this.ship.energy < 20) {
				chance = 0.5;
			} else {
				chance = 0.1;
			}
		} else {
			chance = 0.2; // this will mean both (this.ship.energy < 20) AND NOT (amount > 49)
		}
		if (this.ship.target && this.ship.target.isValid) {
			this.distanceToTarget = this.ship.position.distanceTo(this.ship.target);
			if (this.distanceToTarget < 650) {
				chance += 0.67;
			} else {
				if (this.distanceToTarget < 1000) {
					chance += 0.55;
				} else if (this.distanceToTarget < 3000) {
						chance += 0.3;
				}
			}
		}
		if (Math.random() < chance) {
			this.ship.energy += 100 + amount; // stop it blowing up normally 
			if (whom && whom.isPlayer) {
				this.$explode_causedByPlayer();
			} else {
				this.explode_notCausedByPlayer();
			}
		}
	};

	this.shipTargetCloaked = function() {
		if (this.decloakTargetTimer && this.decloakTargetTimer.isRunning) {
			return;
		}
		if (this.ship.target.isThargoid) {
			return;
		}
		var r = Math.random();
		if (r < 0.16) {
			return;
		}
		if (r > 0.75) {
			this.ship.commsMessage(expandDescription("[thargoid_curses]"));
		}
		this.ship.cloakedTarget = this.ship.target;
		var seconds = 0.5 + ~~(Math.random() * 8);
		if (this.decloakTargetTimer) {
			delete this.decloakTargetTimer;
		}
		this.decloakTargetTimer = new Timer(this, this.$decloakTargetTimed, seconds);
	};


	/*
	---------------------------------------------------
	ROUTINES CALLED BY EVENT HANDLERS
	or called by the routines called by event handlers.
	---------------------------------------------------
	*/

	this.explode_notCausedByPlayer = function() {
		this.$deleteTimers();
		if (!this.ship) {
			return;
		}
		this.explodingShip = this.ship.spawnOne("extraThargoids_exploding_notCausedByPlayer");
		this.explodingShip.newBounty = this.ship.bounty;
		this.explodingShip.bounty = this.ship.bounty;
		this.explodingShip.orientation = this.ship.orientation;
		this.explodingShip.position = this.ship.position;
		if (Math.random() < 0.4) {
			this.ship.commsMessage("We boom your bases!");
		}
		if (!this.ship) {
			return;
		}
		this.ship.remove(true);
	};

	this.$explode_causedByPlayer = function() {
		this.$deleteTimers();
		if (!this.ship) {
			return;
		}
		if (Math.random() < 0.7) {
			this.ship.commsMessage("We boom your bases!");
		}
		this.explodingShip = this.ship.spawnOne("extraThargoids_exploding_causedByPlayer");
		this.explodingShip.newBounty = this.ship.bounty;
		this.explodingShip.bounty = this.ship.bounty;
		this.explodingShip.orientation = this.ship.orientation;
		this.explodingShip.position = this.ship.position;
		if (!this.ship) {
			return;
		}
		this.ship.remove(true);
	};

	this.$decloakTargetTimed = function $decloakTargetTimed() {
		this.decloakTargetTimer.stop();
		if (!this.ship || !this.ship.isValid) {
			delete this.decloakTargetTimer;
			return;
		}
		if (!this.ship.cloakedTarget || !this.ship.cloakedTarget.isValid) {
			delete this.decloakTargetTimer;
			return;
		}
		if (!this.ship.cloakedTarget.isCloaked) {
			delete this.decloakTargetTimer;
			return;
		}
		this.distanceToTarget = this.ship.position.distanceTo(this.ship.cloakedTarget);
		if (this.distanceToTarget < 10000) {
			mysound_Warning.play();
			this.ship.cloakedTarget.lightsActive = true;
			if (Math.random() > 0.91) {
				this.ship.cloakedTarget.setEquipmentStatus("EQ_CLOAKING_DEVICE", "EQUIPMENT_DAMAGED");
				if (this.ship.cloakedTarget.isPlayer && !player.ship) {
					delete this.decloakTargetTimer;
					return;
				}
				this.ship.commsMessage("CLOAKING DEVICE DAMAGED!", this.ship.cloakedTarget);
			} else {
				player.consoleMessage("CLOAKING FAILURE!", 10);
				player.ship.isCloaked = false;
				this.ship.target = this.ship.cloakedTarget;
				this.ship.reactToAIMessage("ATTACK_SHIP");
			}
		}
		if (Math.random() < 0.25) {
			this.ship.commsMessage(expandDescription("[thargoid_curses]"));
		}
		delete this.decloakTargetTimer;
	};


	this.$checkStunTimed = function $checkStunTimed() {
		if (this.ship.AIState == "STUNNED") {
			this.ship.exitAI();
			this.explode_notCausedByPlayer();
		}
	};

	this.$deleteTimers = function() {
		if (this.decloakTargetTimer) {
			if (this.decloakTargetTimer.isRunning) {
				this.decloakTargetTimer.stop();
			}
			delete this.decloakTargetTimer;
		}
		if (this.checkStunTimed) {
			if (this.checkStunTimed.isRunning) {
				this.checkStunTimed.stop();
			}
			delete this.checkStunTimed;
		}
	};


	/*
	--------------------------------------------------------------------------
	CALLED BY AI
	These routines are called by this AI: 
	extraThargoids_kamikazeAI (which itself is invoked, only, by the shipdata)
	--------------------------------------------------------------------------
	*/

	this.$_seekPrimaryTarget = function() {
		if (!this.ship) {
			return;
		}
		var primaryTargetsArray = system.shipsWithRole("behemoth", this.ship, 25600);
		if (primaryTargetsArray.length > 0) {
			this.ship.target = primaryTargetsArray[0];
			this.ship.reactToAIMessage("TARGET_FOUND");
			return;
		}
		primaryTargetsArray = system.shipsWithRole("leviathan", this.ship, 25600);
		if (primaryTargetsArray.length > 0) {
			this.ship.target = primaryTargetsArray[0];
			this.ship.reactToAIMessage("TARGET_FOUND");
			return;
		}
		primaryTargetsArray = system.shipsWithRole("patrol-frigate", this.ship, 25600);
		if (primaryTargetsArray.length > 0) {
			this.ship.target = primaryTargetsArray[0];
			this.ship.reactToAIMessage("TARGET_FOUND");
			return;
		}
		primaryTargetsArray = system.shipsWithRole("navy-frigate", this.ship, 25600);
		if (primaryTargetsArray.length > 0) {
			this.ship.target = primaryTargetsArray[0];
			this.ship.reactToAIMessage("TARGET_FOUND");
		} else {
			this.ship.reactToAIMessage("NO_PRIMARY");
		}
	};

	this.$_rangeAchieved = function() {
		if (!this.ship || !this.ship.isValid) {
			return;
		}
		// else
		this.explode_notCausedByPlayer();
		var explosiveBits = this.ship.spawn("explosive_shrapnel", 5);
	};


	/*
	----------------------
	JSLINT: end of wrapper
	----------------------
	*/

}).call(this);

// EOF