"use strict";
this.name = "ShipConfiguration_F3HUDControl";
this.author = "phkb";
this.copyright = "2018 phkb";
this.description = "Handles the swapping in/out of specialised HUD for F3 screen";
this.licence = "CC BY-NC-SA 3.0";

this._equipSpaceHUD = "shipconfig_hud.plist";

//-------------------------------------------------------------------------------------------------------------
this.startUp = function () {
    if (worldScripts.ShipConfiguration_Core._disabled) {
        delete this.guiScreenChanged;
        delete this.missionScreenEnded;
        delete this.playerBoughtEquipment;
        delete this.startUpComplete;
        return;
    }
    // make sure we're using the appropriate F3 HUD, one that matches the big gui setting of the current HUD.
    if (this._equipSpaceHUD.indexOf("shipconfig") >= 0) {
        this._equipSpaceHUD = "shipconfig_hud.plist";
    }
}

//-------------------------------------------------------------------------------------------------------------
this.guiScreenChanged = function (to, from) {
    var p = player.ship;
    if (!p.docked) return;
    if (worldScripts.ShipConfiguration_Core._disableF3HUD === true) return;
    if (guiScreen === "GUI_SCREEN_EQUIP_SHIP") {
        //swap to special hud
        if (p.hud !== this._equipSpaceHUD) {
            this._restoreHUD = p.hud;
            this._restoreTargetSensitivity = p.reticleTargetSensitive;
            p.hud = this._equipSpaceHUD;
        }
        this.$updateEquipmentSpaceHUD();
    } else {
        if (from === "GUI_SCREEN_EQUIP_SHIP") {
            if (p.hud === this._equipSpaceHUD) {
                if (this._restoreHUD) {
                    p.hud = this._restoreHUD;
                    p.reticleTargetSensitive = this._restoreTargetSensitivity;
                    delete this._restoreHUD;
                }
            }
            p.setCustomHUDDial("equipment_space", "");
            p.setCustomHUDDial("cargo_space", "");
        }
    }
}

//-------------------------------------------------------------------------------------------------------------
this.missionScreenEnded = function () {
    // make sure we're using the appropriate F3 HUD, one that matches the big gui setting of the current HUD.
    if (this._equipSpaceHUD.indexOf("shipconfig") >= 0) {
        if (worldScripts.ShipConfiguration_Core.$isBigGuiActive() === true) {
            this._equipSpaceHUD = "shipconfig_biggui_hud.plist";
        } else {
            this._equipSpaceHUD = "shipconfig_hud.plist";
        }
    }
    this.guiScreenChanged();
}

//-------------------------------------------------------------------------------------------------------------
this.playerBoughtEquipment = function (equipmentKey) {
    var p = player.ship;
    if (!p.docked) return;
    var s = worldScripts.ShipConfiguration_Core;
    if (s._disableF3HUD === true) return;
    if (s._ignoreEquip.indexOf(equipmentKey) >= 0) return;
    this.$updateEquipmentSpaceHUD();
}

//-------------------------------------------------------------------------------------------------------------
this.$updateEquipmentSpaceHUD = function $updateEquipmentSpaceHUD() {
    if (guiScreen === "GUI_SCREEN_EQUIP_SHIP") {
        var pad = 14.5;
        var p = player.ship;
        var s = worldScripts.ShipConfiguration_Core;
        if (s._disableF3HUD === true) return;
        var used = s.$calcEquipmentSpace(p);
        var cargoUsed = s.$cargoEquipmentSpaceAmount(p);
        var maxCargo = s.$cargoSpaceAvailable(p);
        var maxSpace = Math.ceil(s.$equipmentSpaceTotal(p) + maxCargo);
        var text = s.$padTextLeft(expandDescription("[sc-header-equipspace]") + " " + used.toFixed(1) + "t (" + maxSpace.toFixed(0) + "t)", pad);
        p.setCustomHUDDial("equipment_space", text);
        text = s.$padTextLeft(expandDescription("[sc-header-cargo]") + " " + cargoUsed.toFixed(1) + "t (" + maxCargo + "t)", pad);
        p.setCustomHUDDial("cargo_space", text);
    }
}