"use strict";
this.name = "ShipConfiguration_BoosterHeat";
this.author = "phkb";
this.copyright = "2016 phkb";
this.description = "Process of adding cabin heat at certain throttle levels when boosters are installed";
this.licence = "CC BY-NC-SA 3.0";

this._boostHeatDelta = 0.93;
this._fcbBoost = 0;

//-------------------------------------------------------------------------------------------------------------
this.startUpComplete = function () {
	if (worldScripts.ShipConfiguration_Core._disabled) {
		delete this.shipLaunchedFromStation;
		delete this.shipWillDockWithStation;
		delete this.shipDied;
		delete this.startUpComplete;
		return;
	}
	player.ship.script._boosterHeatEnabled = false;
}

//-------------------------------------------------------------------------------------------------------------
this.shipLaunchedFromStation = function (station) {
	var p = player.ship;
	if (p.script._boosterHeatPoint != 0) {
		p.script._boosterHeatEnabled = false;
		p.script._boosterHeatDelta = this._boostHeatDelta;
		if (this._fcbBoost === 0) {
			// set up our frame callback
			this._fcbBoost = addFrameCallback(function (delta) {
				if (delta === 0) return;
				var p = player.ship;
				var ps = p.script;
				if (!ps) return; // probably player has died.
				if (ps._boosterHeatPoint === 0) {
					if (ps._boosterHeatEnabled === true) {
						ps._boosterHeatEnabled = false;
						ps.thirdPartyHeat -= ps._boosterHeatDelta;
						if (ps.thirdPartyHeat < 0) ps.thirdPartyHeat = 0;
					}
					return;
				}
				// only apply the heat element if the ship speed is under the max speed value (ie not while injectors or torus drive are in use)
				var disable = false;
				if (p.speed <= p.maxSpeed) {
					// what is the percentage of speed
					if ((p.speed / p.maxSpeed) > ps._boosterHeatPoint) {
						if (ps._boosterHeatEnabled === true) {
							// just return if booster heat is already on
							return;
						} else {
							// turn on booster heat
							ps._boosterHeatEnabled = true;
							ps.thirdPartyHeat += ps._boosterHeatDelta;
							player.consoleMessage(expandDescription("[sc_booster_heat_warning]"), 2);
							worldScripts.ShipConfiguration_Core.$playSound("booster_warning");
						}
					} else {
						// disable if the ship is going less than the booster heat point
						disable = true;
					}
				} else {
					// disable booster heat if the ship is going faster than their max speed (injectors or torus)
					disable = true;
				}
				if (disable === true) {
					if (ps._boosterHeatEnabled === true) {
						ps._boosterHeatEnabled = false;
						ps.thirdPartyHeat -= ps._boosterHeatDelta;
						if (ps.thirdPartyHeat < 0) ps.thirdPartyHeat = 0;
					}
				}
			});
		}
	} else {
		// in case the booster gets damaged while heat is enabled
		if (p.script._boosterHeatEnabled === true) {
			p.script._boosterHeatEnabled = false;
			p.script.thirdPartyHeat -= p.script._boosterHeatDelta;
		}
	}
}

//-------------------------------------------------------------------------------------------------------------
this.shipWillDockWithStation = function (station) {
	this.$stopTimers();
}

//-------------------------------------------------------------------------------------------------------------
this.shipDied = function (whom, why) {
	this.$stopTimers();
}

//-------------------------------------------------------------------------------------------------------------
this.$stopTimers = function $stopTimers() {
	if (this._fcbBoost != 0) {
		if (isValidFrameCallback(this._fcbBoost)) removeFrameCallback(this._fcbBoost);
		this._fcbBoost = 0;
	}
}