"use strict";

this.name    = "Home_Control";
this.version = "1.0";

/* ====================================================================================
			EVENT LISTENERS
======================================================================================= */

    this.startUpComplete = function () {
        if (player.ship.equipmentStatus("EQ_SMART_HOME_CONTROL") === "EQUIPMENT_OK") {
            this._applyCode(player.ship.dockedStation);
            delete this.playerBoughtEquipment;
        }
        delete this.startUpComplete;
    }

    this.playerBoughtEquipment = function (equipment) {
        if (equipment === "EQ_SMART_HOME_CONTROL") {
            this._applyCode(player.ship.dockedStation);
            delete this.playerBoughtEquipment;
        }
    }

    this.shipDockedWithStation = function (station) {
        if (player.ship.equipmentStatus("EQ_SMART_HOME_CONTROL") === "EQUIPMENT_OK") {
            this._applyCode(station);
        }
    }

    this.shipWillLaunchFromStation = function (station) {
        station.setInterface("smart_home", null);
    }

/* ====================================================================================
			SMART KETTLE CONTROL
======================================================================================= */

    this._applyCode = function (station) {
        if (station) {
            station.setInterface("smart_home", {
                title: "Turn on the kettle",
                category: "A TEST",
                summary: "Requires internet-enabled kettle and Google Home.",
                callback: this._kettleSequence.bind(this)
            });
        }
    }

    this._kettleSequence = function (callback) {
        if (callback === "smart_home") {
            this._kettleControl(true);
            this.$kettleTimer = new Timer(this, function () {this._kettleControl(false);}, 30);
            this.$OoliteTimer = new Timer(this, function () {pauseGame();}, 50);
        }
    }

    this._kettleControl = function (start) {
        if (start) {
            if (oolite.gameSettings.speechOn > 1) {
                player.consoleMessage("Hey Google, turn on the kettle.", 6);
            } else {
                var googleBoss = new SoundSource;
                googleBoss.sound = "dt_turn_on_the_kettle.ogg";
                googleBoss.volume = 1.0; // Full volume
                googleBoss.play();
            }
        } else {
            if (oolite.gameSettings.speechOn > 1) {
                player.consoleMessage("Hey Google, what is the temperature of the kettle?", 6);
            } else {
                var googleBoss = new SoundSource;
                googleBoss.sound = "dt_what_is_the_temperature_of_the_kettle.ogg";
                googleBoss.volume = 1.0; // Full volume
                googleBoss.play();
            }
        }
    }

/* ====================================================================================
			THE END
======================================================================================= */