"use strict";
this.name = "ShipConfiguration_ShieldCyclerFix";
this.author = "phkb";
this.copyright = "2016 phkb";
this.licence = "CC BY-NC-SA 3.0";

//-------------------------------------------------------------------------------------------------------------
this.startUpComplete = function () {
	var sc = worldScripts["Shield Cycler"];
	if (sc && (sc.version == "1.12" || sc.version == "1.12.1")) {
		// there's a really small bug in Shield Cycler 1.12 and 1.12.1
		// patch these versions of shield cycler to fix it
		sc._sc_stop = this.$scFix_sc_stop;
	}
}

//-------------------------------------------------------------------------------------------------------------
this.$scFix_sc_stop = function $scFix_sc_stop(device) {
	/*	device is a string to indicate which devices handled by SC oxp need to be stopped
		currently has 2 possible values : 
		"ALL" : disable all devices
		"SC" : disables just the shieldcycler
		In future versions there will be more options

		returns
		-3 if SC was disabled
		-2 if device was stopped already
		-1 device string invalid
		0 if stopping was succesfull
		NOTE : no messages to player or logfile, imo this is the responsibility of the calling oxp
		NOTE : calling worldScripts["Shield Cycler"]._sc_stop("SC") DOES NOT disable the entire oxp.
	*/
	var success = -3;
	if (this._sc_error == 0) {
		switch (device) {
			case "ALL":
				if (this._sc_settings.general.disabled) {
					success = -2;
				} else {
					this._sc_settings.general.disabled = true;
					this._sc_update_oxpconfig_vars();
					success = 0;
				};
				break;
			case "SC":
				if (this._sc_settings.general.sc_disabled) {
					success = -2;
				} else {
					this._sc_settings.general.sc_disabled = true;
					this._sc_update_oxpconfig_vars;
					success = 0;
				};
				break;
			default:
				success = -1; // bug was here. this originally read "succes = -1;"
				break;
		};
	};
	return success;
};