"use strict";
this.name = "ShipConfiguration_WitchdriveHeat";
this.author = "phkb";
this.copyright = "2016 phkb";
this.description = "Process of adding cabin heat when building up to a witchspace jump";
this.licence = "CC BY-NC-SA 3.0";

this._disabled = false; // set to true to disable witchdrive heat buildup
this._heatDelta = 0.0; // amount of heat to add - set when turning on heat
this._heatMonitor = null;
this._misJumpSet = false;

//-------------------------------------------------------------------------------------------------------------
this.startUpComplete = function () {
	if (this._disabled === true) {
		delete this.playerStartedJumpCountdown;
		delete this.playerCancelledJumpCountdown;
		delete this.playerJumpFailed;
		delete this.playerStartedAutoPilot;
		delete this.shipWillExitWitchspace;
		delete this.startUpComplete;
		return;
	}
}

//-------------------------------------------------------------------------------------------------------------
this.playerStartedJumpCountdown = function (type, seconds) {
	this.$turnOnHeat();
}

//-------------------------------------------------------------------------------------------------------------
this.playerCancelledJumpCountdown = function () {
	this.$turnOffHeat();
}

//-------------------------------------------------------------------------------------------------------------
this.playerStartedAutoPilot = function() {
	this.$turnOffHeat();
}

//-------------------------------------------------------------------------------------------------------------
this.playerJumpFailed = function (reason) {
	this.$turnOffHeat();
}

//-------------------------------------------------------------------------------------------------------------
this.shipWillExitWitchspace = function () {
	this.$turnOffHeat();
}

//-------------------------------------------------------------------------------------------------------------
this.shipDied = function (whom, why) {
	if (this._heatMonitor && this._heatMonitor.isRunning) this._heatMonitor.stop();
}

//-------------------------------------------------------------------------------------------------------------
this.$turnOffHeat = function $turnOffHeat() {
	var ps = player.ship.script;
	ps.thirdPartyHeat -= this._heatDelta;
	this._heatDelta = 0;
	if (ps.thirdPartyHeat < 0) ps.thirdPartyHeat = 0;
	if (this._heatMonitor && this._heatMonitor.isRunning === true) this._heatMonitor.stop();
	if (this._misJumpSet) {
		player.ship.scriptedMisjump = false;
		this._misJumpSet = false;
	}
}

//-------------------------------------------------------------------------------------------------------------
this.$turnOnHeat = function $turnOnHeat() {
	if (system.sun && system.sun.hasGonaNova) {
		this._heatDelta = 0.2;
	} else {
		switch (player.ship.hyperspaceSpinType) {
			case 30:
				this._heatDelta = 0.87;
				break;
			case 10:
				this._heatDelta = 0.91;
				break;
			case 5:
				this._heatDelta = 0.92;
				break;
			default:
				this._heatDelta = 0.9;
				break;
		}
	}
	player.ship.script.thirdPartyHeat += this._heatDelta;
	if (this._heatMonitor && this._heatMonitor.isRunning === true) this._heatMonitor.stop();
	this._heatMonitor = new Timer(this, this.$checkHeat.bind(this), 1, 1);
}

//-------------------------------------------------------------------------------------------------------------
this.$checkHeat = function $checkHeat() {
	var p = player.ship;
	var ps = p.script;
	if (system.sun && system.sun.hasGoneNova && this._heatDelta != 0.2) {
		ps.thirdPartyHeat -= this._heatDelta;
		if (ps.thirdPartyHeat < 0) ps.thirdPartyHeat = 0;
		this._heatDelta = 0.2;
		ps.thirdPartyHeat += this._heatDelta;
	}
	var heat = p.temperature;
	if (heat > 0.65) {
		// increase the chance of a misjump the higher the temp
		if (Math.random() < (0.35 - (1 - heat)) && p.scriptedMisjump === false) {
			p.scriptedMisjump = true;
			this._misJumpSet = true;
		}
	}
}