"use strict";
this.name = "ShipConfiguration_Conditions";
this.author = "phkb";
this.copyright = "2016 phkb";
this.description = "Condition script for equipment.";
this.license = "CC BY-NC-SA 3.0";

//-------------------------------------------------------------------------------------------------------------
this.allowAwardEquipment = function (equipment, ship, context) {

	if (context === "scripted") return true;
	if (context === "npc") return true;
	if (equipment.indexOf("EQ_EQUIPSPACE") >= 0) return false;

	// is this item damaged?
	var p = player.ship;
	if (p.equipmentStatus(equipment) === "EQUIPMENT_DAMAGED") {
		// return true so that the "Repair" item is displayed.
		return true;
	}

	if (equipment === "EQ_HEAT_SINK_CONTROL" || equipment === "EQ_HEAT_SINK_CONTROL_PASSIVE") return false;

	var sc = worldScripts.ShipConfiguration_Core;

	if (sc._disabled) return false;

	if (equipment === "EQ_HEAT_SINK") {
		if (sc._heatControl === false) {
			return false;
		} else {
			return true;
		}
	}

	if (equipment === "EQ_SHIPCONFIG" && sc._disabled === false) return true;

	// check for damaged equipment items
	if (equipment.indexOf("EQ_ARMOUR_FORWARD") >= 0 && equipment.indexOf("_REPAIR") >= 0) {
		var result = false;
		if (p.script._armourFront < 100) {
			if (equipment === sc.$equipmentItemInUse("frontarmour", p) + "_REPAIR") result = true;
		}
		return result;
	}
	if (equipment.indexOf("EQ_ARMOUR_AFT") >= 0 && equipment.indexOf("_REPAIR") >= 0) {
		var result = false;
		if (p.script._armourAft < 100) {
			if (equipment === sc.$equipmentItemInUse("aftarmour", p) + "_REPAIR") result = true;
		}
		return result;
	}

	if (equipment.indexOf("EQ_EXTENSION") >= 0) {
		// small ships can't get 5t extension
		var mss = sc.$getShipMass(ship);
		if (EquipmentInfo.infoForKey(equipment).scriptInfo.equipment_extension >= 5 && mss < 50000) return false
		// large ships can't get any
		if (mss > 400000) return false
		// maximum of 2 extensions can be installed at the same time
		var count = this.$countExtensionsInShip(ship);
		if (count === 2) return false;
		return true;
	}

	if (context === "purchase") return false;

	return true;
}

//-------------------------------------------------------------------------------------------------------------
this.updateEquipmentPrice = function (equipment, price) {
	var sc = worldScripts.ShipConfiguration_Core;
	var p = player.ship;
	var newprice = price;
	if (equipment.indexOf("EQ_ARMOUR_FORWARD") >= 0 && equipment.indexOf("_REPAIR") >= 0) {
		var amt = p.script._armourFront;
		// calculate percentage of damage
		var cur = Math.floor((100 - amt) / 10);
		// get the pricing factor for our ship
		var priceFactor = sc.$equipmentPriceFactor(p.shipClassName, sc.$getShipMass(p));
		// apply the price factor to the percentage of repair, to get a more realistic price
		// otherwise, a repair bill could be way more expensive than a new installation.
		cur = parseInt(cur * priceFactor);
		if (cur > 9) cur = 9;
		if (p.script._armourFront < 100 && cur === 0) cur = 1;
		newprice = price * cur;
	}
	if (equipment.indexOf("EQ_ARMOUR_AFT") >= 0 && equipment.indexOf("_REPAIR") >= 0) {
		var amt = p.script._armourAft;
		// calculate percentage of damage
		var cur = Math.floor((100 - amt) / 10);
		// get the pricing factor for our ship
		var priceFactor = sc.$equipmentPriceFactor(p.shipClassName, sc.$getShipMass(p));
		// apply the price factor to the percentage of repair, to get a more realistic price
		// otherwise, a repair bill could be way more expensive than a new installation.
		cur = parseInt(cur * priceFactor);
		if (cur > 9) cur = 9;
		if (p.script._armourAft < 100 && cur === 0) cur = 1;
		newprice = price * cur;
	}
	return newprice;
}

//-------------------------------------------------------------------------------------------------------------
// counts the number of equipment extensions current installed
this.$countExtensionsInShip = function $countExtensionsInShip(ship) {
	var eq = ship.equipment;
	var count = 0;
	for (var i = 0; i < eq.length; i++) {
		if (eq[i].equipmentKey.indexOf("EQ_EXTENSION") >= 0) count += 1;
	}
	return count;
}