this.name					= "FuelStation-Setup";
this.author					= "Thargoid";
this.copyright				= "Creative Commons: attribution, non-commercial, sharealike with clauses - see readme.txt";
this.description			= "Script to add fuel station to certain systems";
this.version				= "2.02";

this.extraA = true;	// for use with turretted ships - set to false to only get fuel satellites
this.extraB = true;	// if set to false, no NPCs will use the stations (if extraA is false, has no effect)
	
this.oxpcSettings = {
	Info: {Name:this.name,Display:this.name,InfoB:"1 - If false only fuel satellites will appear.\n2 - If false NPCs will not use fuel stations (ignored if extraA is false)."},
	Bool0: {Name:"extraA",Def:true,Desc:"Suppress fuel stations."},
	Bool1: {Name:"extraB",Def:false,Desc:"Allow NPCs to use fuel stations."}
};	

this.startUp = function()
	{
	this.positionOverride = false; // set this to true to use alternative station positioning at far side of witchpoint only.
	}

this.shipWillLaunchFromStation = function()
	{
	this.shipExitedWitchspace();
	delete this.shipWillLaunchFromStation;
	}
	
this.shipExitedWitchspace = function()
	{
	if(this.positionOverride === false)
		{ this.originalStationSetup(); }
	else
		{ this.witchpointStationSetup(); }
	}
	
this.witchpointStationSetup = function() // fixed station position on far side of witchpoint area.
	{
	if(system.isInterstellarSpace || system.sun.isGoingNova || system.sun.hasGoneNova || missionVariables.longwayround === "STAGE1" || missionVariables.longwayround === "STAGE2") 
	// stop the script if interstellar space, or system is going Nova(to allow Nova mission unhindered) or indeed if it has gone nova already.
		{ return; }

	if(system.government > 1 && system.techLevel > 3 && system.countShipsWithRole("fuelStation_location") === 0)
		{
		if(this.extraA && system.scrambledPseudoRandomNumber(19.7) > 0.33)
			{ system.legacy_addShipsAt("fuelStation_station", 1, "wpm", [0, 0, -24000]); }
		else
			{ system.legacy_addShipsAt("fuelStation_satellite", 1, "wpm", [0, 0, -24000]); }
		}
	}	
	
this.originalStationSetup = function() // original locations, near witchpoint and on route 1.
	{
	if(system.isInterstellarSpace || system.sun.isGoingNova || system.sun.hasGoneNova) 
		{ // stop the script if interstellar space, or system is going Nova(to allow Nova mission unhindered) or indeed if it has gone nova already.
		return;
		}

	this.halfwayChance = 0.25; // 3 in 4 chance to add a station at the half-way point of route 1.
	this.witchpointChance = 0.33; // 2 in 3 chance to add a station near the witchpoint.

	if(missionVariables.longwayround === "STAGE1" || missionVariables.longwayround === "STAGE2")
		{ // drastically reduce the chances if you're in the middle of Long Way Round mission
		this.halfwayChance = 0.9; // 1 in 10 chance to add a station at the half-way point of route 1.
		this.witchpointChance = 0.95; // 1 in 20 chance to add a station near the witchpoint.
		}

	if(system.government > 1 && system.techLevel > 3 && system.countShipsWithRole("fuelStation_location") === 0)
		{
		if(system.scrambledPseudoRandomNumber(13.7) > this.witchpointChance)
			{
			if(this.extraA && system.scrambledPseudoRandomNumber(17.4) > 0.33)
				{
	 			system.legacy_addShipsAt("fuelStation_station", 1, "pwu", [0.02, 0, 1]);
				}
			else
				{
	 			system.legacy_addShipsAt("fuelStation_satellite", 1, "pwu", [0.02, 0, 1]);
				}
			}

		if(system.scrambledPseudoRandomNumber(25.3) > this.halfwayChance)
			{
			if(this.extraA && system.scrambledPseudoRandomNumber(24.1) > 0.33)
				{
	 			system.legacy_addShipsAt("fuelStation_station", 1, "pwu", [0.02, 0, 0.5]);
				}
			else
				{
	 			system.legacy_addShipsAt("fuelStation_satellite", 1, "pwu", [0.02, 0, 0.5]);
				}
			}

		}
	}