this.name					= "FuelStation";
this.author					= "Thargoid";
this.copyright				= "Creative Commons: attribution, non-commercial, sharealike with clauses - see readme.txt";
this.description			= "Script for fuel station";
this.version				= "2.02";

this.shipSpawned = function()
	{ 
	this.ship.scannerDisplayColor1 = "greenColor";
	this.ship.scannerDisplayColor2 = "lightGrayColor";

	var traders = system.shipsWithPrimaryRole("trader", this.ship, 50E3)	
	if(traders.length > 0 && worldScripts["FuelStation-Setup"].extraB && traders[0].AIState == "HEAD_FOR_PLANET") 
		{
		traders[0].script.checkFuelStationDistance = this.checkFuelStationDistance; // attach function to script.
		traders[0].script.checkUsage = this.checkUsage; // attach function to script.
		traders[0].setAI("fuelStation_gotoFuelStationAI.plist");
		}
		
	//  line the station up with the route one. Code borrowed from Anarchies for convenience.
	if(system.isInterstellarSpace || !system.mainPlanet) {return;}
	var targetVector = system.mainPlanet.position.subtract(this.ship.position).direction();
	var angle = this.ship.heading.angleTo(targetVector);
	var cross = this.ship.heading.cross(targetVector).direction();
	this.ship.orientation = this.ship.orientation.rotate(cross, -angle);	
//	this.setColour();
	this.setPrice();
	}

//this.setColour = function()
//	{
//	this.colRand = system.scrambledPseudoRandomNumber(45.32)
//	colName = "yellowColor";
//	if(this.colRand < 0.25) { colName = "blueColor"; }
//	if(this.colRand < 0.75) { colName = "redColor"; }
//	if(this.colRand > 0.25 && this.colRand < 0.5) { colName = "magentaColor"; }
//	this.ship.setMaterials({"fuelStation_station.png": { diffuse: colName }});
//	}
	
this.setPrice = function()	
	{
	this.fuelPrice = 0.15 * EquipmentInfo.infoForKey("EQ_FUEL").price * player.ship.fuelChargeRate; // price per 0.1LY of fuel
	if(system.economy === 0 || system.economy === 5) { this.fuelPrice *= 1.2; } //  rich industrial or agricultural
	if(system.techLevel > 4 && system.techLevel < 11) { this.fuelPrice *= 1.1; } //  mid-tech level
	this.fuelPrice = this.decPlaces(this.fuelPrice,2);
	}	

this.decPlaces = function(number, places)
	{
	if(!places || places < 0) {places = 0;}
	if(!number) {return 0;}
	return ((Math.round(number * Math.pow(10,places))) / Math.pow(10,places));
	}
	
this.playerDetected = function()
	{
	this.firstMessage = true;
	this.fuelTransferred = 0; // how many 0.1LY units are transferred
	this.fuelBill = 0;
	this.ship.commsMessage("Greetings Commander " + player.name + ". Refuel here for only " + this.decPlaces((10 * this.fuelPrice),1) + " credits per ly");
	if(this.scanTimer)
		{
		this.scanTimer.start();
		}
	else
		{
		this.scanTimer = new Timer(this, this.locatePlayer, 0, 0.50);
		}
	}

this.locatePlayer = function()
	{
	if(!this.ship ||!this.ship.isValid || !this.ship.position || !player.ship.isValid) // if the ship no longer exists but timer is running, e.g. if player has jumped whilst near a satellite into a system without one
		{
		this.playerGone();
		return;
		}

	if(this.ship.position.distanceTo(player.ship.position) < 150) // player ship within 150m of the centre of the fuel station
		{
		if(player.ship.fuel < 7)
			{
			if(player.credits > this.fuelBill)
				{ // player in place, fuel tank not full and credit balance not empty
				player.ship.fuel += 0.1;
				this.fuelBill += this.fuelPrice;
				this.fuelTransferred++;

				if(this.firstMessage)
					{
					player.consoleMessage("Fuel transfer is underway, please come to a halt.", 6);
					this.firstMessage = false;
					}
				return;
				}
			else
				{ // not enough funds left
				player.consoleMessage("Insufficient credits remaining, transfer terminated.", 6);
				this.scanTimer.stop();
				return;
				}
			}
		else
			{ // Fuel tank full
			player.consoleMessage("Fuel tanks are full.", 6);
			this.scanTimer.stop();
			return;
			
			}
		}
	}

this.shipTraversePositiveZ = this.shipTraverseNegativeZ = function(ship)
	{
	if(ship.isPlayer) this.playerLeaving()
	}

this.playerLeaving = function()
	{
	this.fuelBill = this.decPlaces(this.fuelPrice * this.fuelTransferred,1);
	player.consoleMessage("Summary - " + (this.fuelTransferred / 10) + " ly transferred, " + this.fuelBill + " credits charged.", 6);
	player.credits -= this.fuelBill;
	this.fuelTransferred = 0;
	this.fuelBill = 0;
	this.firstMessage = true;
	}
    
this.playerWillEnterWitchspace = this.playerGone = function()
	{
	if(this.scanTimer)
		{
		this.scanTimer.stop();
		delete this.scanTimer;
		}
	}

this.shipDied = function(whom, why) 
	{
	this.playerGone();
	this.fuelCount = (Math.ceil(Math.random() * 30) + 30);
	this.ship.spawn("fuelStation_burningFuel", this.fuelCount); // lets make this go with a bang!

	if(whom && whom.isPlayer)
		{
		player.consoleMessage("CCTV beam towards the main station detected.", 6);
		player.score -=1; // don't condone vandalism!
		player.bounty += 20;
		}
	}
    

// below not used by stationscript but is attached to traderscript.
this.checkFuelStationDistance = function()
	{	
	if(this.ship.position.distanceTo(this.ship.target.position) > 50E3)
		{
		this.ship.reactToAIMessage("NEXT_FUELSTATION")
		}
	}

this.checkUsage = function()
	{
	 if(this.ship.target.position.distanceTo(player.ship.position) < 1000)
		{
		this.ship.reactToAIMessage("NEXT_FUELSTATION")
		}
	else
		{
		this.ship.reactToAIMessage("STATION_CLEAR")
		}
	}
	
this.attackedMessage = function()
	{
	this.ship.commsMessage("ALERT - fuel station under attack, explosion danger!");
	}	
	
this.collisionMessage = function()
	{
	this.ship.commsMessage("ALERT - proximity detection, please take evasive action");
	}
