/*
========================================================================
IST_thargoidRebel.js
This file is part of the Interstellar Tweaks expansion pack.
Author: UK_Eliter
License: 2017 Creative Commons: attribution, non-commercial, sharealike.
========================================================================
*/


/*
--------------------
JSHINT: set options
--------------------
*/

/*jshint esversion: 6*/
/*jshint sub:true*/



this.name = "IST_thargoidRebel.js";
this.author = "UK_Eliter";
this.copyright = "2014 Creative Commons: attribution, non-commercial, sharealike.";
this.licence = "CC-NC-SA 3";
this.description = "A script for InterstellarTweaks OXP";


/*
------------------
DEBUGGING SWITCHES
------------------
*/

// this.logging = true;
var consoleDebugMessages = false;
// do NOT comment out the above line. Rather, to disable, set to false.


/*
------------------------
JSHINT: start of wrapper
------------------------
*/

(function() {
	"use strict";


	/*
	---------
	MAIN CODE
	---------
	*/

	// The AI ensures that a rebel ship can never use its own drive to enter normal space.
	// But rebels can enter each others' wormwholes and thereby (despite the above) enter normal space. Hence this function.
	this.shipSpawned = function() {
		// Fix witchspace.
		this.ship.scriptedMisjump = true;
		delete this.shipSpawned;
	};


	this.$targetShips = function(e) {
		return e.isShip && e.isThargoid && !e.isCloaked && e.primaryRole !== "thargoidRebel";
	};

	this.$thargoidAIfindEnemy = function() {
		var nearArray = system.filteredEntities(this, this.$targetShips, this.ship, 25600);
		if (nearArray.length > 0) {
			var targetNumber = ~~(Math.random() * nearArray.length);
			this.ship.target = nearArray[targetNumber];
			this.ship.reactToAIMessage("TARGET_FOUND");
			return;
		}
		var farArray = system.filteredEntities(this, $targetShips, this.ship, 60000);
		if (farArray.length > 0) {
			this.ship.target = farArray[0]; // set to the closest target off-scanner but in range.
			this.ship.reactToAIMessage("INTERCEPT_TARGET");
		} else {
			this.ship.reactToAIMessage("NO_TARGET_FOUND");
		}
	};

	this.$validateTarget = function() {
		if (!this.ship.target || !this.ship.target.isValid || this.ship.target.isCloaked) {
			this.ship.reactToAIMessage("TARGET_INVALID");
			return;
		}
		if (this.ship.target.isThargoid && this.ship.target.primaryRole != "thargoidRebel") {
			this.ship.reactToAIMessage("TARGET_VALID");
			return;
		}
		if (this.ship.target.isPolice || this.ship.target.scanClass == "CLASS_MILITARY") {
			this.ship.reactToAIMessage("TARGET_GALCOP");
			return;
		}
		this.ship.reactToAIMessage("TARGET_INVALID");
	};


	/*
	----------------------
	JSLINT: end of wrapper
	----------------------
	*/

}).call(this);


// EOF