/*
========================================================================
IST_liveOneScript.js
This file is part of the Interstellar Tweaks expansion pack.
Author: UK_Eliter
License: 2017 Creative Commons: attribution, non-commercial, sharealike.
========================================================================
*/

/*
---------------
JSHINT: Options
---------------
*/

/*jshint esversion: 6*/
/*jshint sub:true*/


this.name = "IST_liveOneScript.js";
this.author = "UK_Eliter";
this.copyright = "2014 Creative Commons: attribution, non-commercial, sharealike.";
this.licence = "CC-NC-SA 3";
this.description = "A ship script for the Interstellar Tweaks OXP";


/*
--------------
DEBUG SWITCHES
--------------
*/

// this.logging = true;
var consoleDebugMessages = false; // do NOT comment this out. Rather, to disable, set to false.



/*
------------------------
JSHINT: start of wrapper
------------------------
*/

(function() {
	"use strict";


	/*
	-------------------------------------------------------------
	EVENT HANDLERS
	// Don't need the 'this.shipSpawned' from the 'dead derelict',
	because all live derelicts start off dead.
	--------------------------------------------------------------
	*/

	this.shipTakingDamage = function(amount, whom, type) {
		if (this.isInFactDead || this.ship.podded) {
			return;
		}
		if (this.ship.energy < 20) {
			if (Math.random() < 0.8) {
				this.$_pod();
			}
			return;
		}
		// Else ..
		if (Math.random() < 0.25) {
			this.$_pod();
		}
		// Don't need anything re cargo here, 'cos when the pod jettisoned the new script takes care of that (but have the podded check above just in case).
		// EDIT: 'this.isInFactDead' messes with this a bit. Hey ho.
	};

	this.shipDied = this.entityDestroyed = this.playerWillEnterWitchspace = function() {
		if (this.SOS_Timer) {
			if (this.SOS_Timer.isRunning) {
				this.SOS_Timer.stop();
			}
			delete this.SOS_Timer;
		}
	};

	this.shipAttackedWithMissile = function() {
		if (this.isInFactDead || this.ship.podded) {
			return;
		}
		if (Math.random() < 0.9) {
			this.$_pod();
		}
	};


	/*
	---------------------
	ROUTINES CALLED BY AI
	---------------------
	*/

	this.$_setFuelAndConsiderRegularSOS = function() {
		this.isInFactDead = false;
		if (this.ship.fuel > 0) {
			var r = Math.random();
			if ((this.ship.fuel > 3) || (r < 0.9)) {
				this.ship.fuel = r; // can't do this on a shipSpawned, 'cos this ship doesn't get one of those. Fuel set before this by dead_derelict script.
			}
		}
		if (Math.random() < 0.6) {
			var t = 1 + Math.ceil(Math.random() * 8);
			this.SOS_Timer = new Timer(this, this.$SOS, t);
			// Following is to simulate dead ships that nonetheless broadcast SOS.
			if (Math.random() < 0.1) {
				this.isInFactDead = true;
			}
		}
	};

	this.$_pod = function() {
		if (!this.ship || !this.ship.position || !player.ship || this.ship.podded || this.isInFactDead) {
			return;
		}
		if (this.SOS_Timer && Math.random < 0.3) {
			if (this.SOS_Timer.isRunning) {
				this.SOS_Timer.stop();
			}
			delete this.SOS_Timer; // Timer likely to have been stopped before now, anyway.
		}
		this.ship.podded = true;
		if (Math.random() > 0.04) {
			var pod = this.ship.spawnOne("IST_pod");
			this.ship.switchAI("nullAI.plist");
			this.ship.setScript("IST_derelict.js");
		} else {
			if (this.SOS_Timer) {
				if (this.SOS_Timer.isRunning) {
					this.SOS_Timer.stop();
				}
				delete this.SOS_Timer;
			}
			if (Math.random() > 0.15) {
				this.ship.commsMessage("Oh dear . . ");
			}
			this.ship.switchAI("nullAI.plist");
			this.ship.explode();
		}
	};

	this.$_plea = function() {
		if (this.isInFactDead || this.ship.podded || !this.ship || !this.ship.position || !player.ship) {
			return;
		}
		if (this.SOS_Timer && Math.random < 0.8) {
			if (this.SOS_Timer.isRunning) {
				this.SOS_Timer.stop();
			}
			delete this.SOS_Timer;
		}
		var txt;
		switch (Math.ceil(Math.random() * 35)) {
			case 1:
				txt = "Please pick up my capsule! I am completely stranded!";
				break;
			case 2:
				txt = "Help me out, please!";
				break;
			case 3:
				txt = "I am stuck out here!";
				break;
			case 4:
				txt = "Take me back to normal space! I will pay you!";
				break;
			case 6:
				txt = "Pick me up! I'll pay!";
				break;
			case 7:
				txt = "Pick me up, and I will make you rich!";
				break;
			case 8:
				txt = "My ship is broken!";
				break;
			case 9:
				txt = "My ship is completely broken!";
				break;
			case 10:
				txt = "Help! Broken ship!";
				break;
			case 11:
				txt = "Help! No engines!";
				break;
			case 12:
				txt = "Pick up my escape pod! Please!";
				break;
			case 13:
				txt = "Help at last! Amazing! Please scoop me (carefully!).";
				break;
			case 14:
				txt = "Any chance of a lift?";
				break;
			case 15:
				txt = "Help!";
				break;
			case 16:
				txt = "Please help!";
				break;
			case 17:
				txt = "Help!";
				break;
			case 18:
				txt = "Help!";
				break;
			case 19:
				txt = "Help!";
				break;
			case 20:
				txt = "I need help!";
				break;
			case 21:
				txt = "Please pick up my capsule!";
				break;
			case 22:
				txt = "<Static>";
				break;
			default:
				txt = "S O S";
				break;
		}
		this.ship.commsMessage(txt);
		// always followed by 'podding'.
	};


	/*
	---------------
	OTHER FUNCTIONS
	---------------
	*/

	this.$SOS = function $SOS() {
		if (!this.ship) {
			return;
		}
		if (!this.ship.position) {
			return;
		}
		this.ship.commsMessage("S O S"); // this.ship.broadcastDistressMessage() is (1) only available in += 1.79, (2) perhaps applicable only to combat.
	};



	/*
	---------------------------------
	JSHINT: end of wrapper
	---------------------------------
	*/

}).call(this);


// EOF