/*
========================================================================
IST_thargoid.js
This file is part of the Interstellar Tweaks expansion pack.
Author: UK_Eliter
License: 2017 Creative Commons: attribution, non-commercial, sharealike.
========================================================================
*/



/*
====================
JSLINT: set options
====================
*/

/*jshint esversion: 6*/
/*jshint sub:true*/


this.name = "IST_thargoid.js";
this.author = "UK_Eliter";
this.copyright = "2014 Creative Commons: attribution, non-commercial, sharealike.";
this.licence = "CC-NC-SA 3";
this.description = "A script for InterstellarTweaks OXP";


/*
------------------
DEBUGGING SWITCHES
------------------
*/

this.logging = false; // Corresponds to, or needs, settings in logcontrol.plist?
this.debug = false; // false
var consoleDebugMessages = false; // do NOT comment this out. Rather, to disable, set to false.


/*
------------------------
JSLINT: start of wrapper
-----------------------
*/

(function() {
	"use strict";


	/*
	--------------
	EVENT HANDLERS
	--------------
	*/

	// Toggle out the following when not debugging.

	// this.shipSpawned = function() {
	// 	this.ship.reportAIMessages = true;
	// 	delete this.shipSpawned;
	// }


	/*
	---------------------
	ROUTINES CALLED BY AI
	---------------------
	*/

	this.$_findTarget = function() {
		var nearArray = system.filteredEntities(this, this.$isEligibleTarget, this.ship, 25600);
		// The above will exclude escorts marked as CLASS_ROCK. But if those attack the ship, it will respond.
		var l = nearArray.length;
		if (l > 0) {
			if (l > 1) {
				var targetNumber = ~~(Math.random() * l);
				// if ( targetNumber > l ) {
				// 	log( this.name + " script ERROR, target number too high - please report." );
				// 	targetNumber = 0;
				// }
				this.ship.target = nearArray[targetNumber];
			} else {
				this.ship.target = nearArray[0];
			}
			if (Math.random() < 0.2) {
				this.$cursePlayer();
			}
			this.ship.reactToAIMessage("TARGET_FOUND");
			return;
		}
		// Otherwise
		var farArray = system.filteredEntities(this, $isEligibleTarget, this.ship, 75000);
		if (farArray.length > 0) {
			if (Math.random() < 0.1) {
				this.$cursePlayer();
			}
			this.ship.target = farArray[0]; // set to the closest target off-scanner but in range
			this.ship.reactToAIMessage("INTERCEPT");
		} else {
			this.ship.reactToAIMessage("NOTHING_FOUND");
		}
	};

	this.$_validateAttackerAsTarget = function() {
		if (this.ship.target && this.ship.target.isValid && this.$isEligibleTarget(this.ship.target)) {
			this.ship.reactToAIMessage("TARGET_VALID");
		} else {
			this.ship.reactToAIMessage("TARGET_INVALID");
		}
	};


	/*
	---------------
	OTHER FUNCTIONS
	---------------
	*/

	this.$isEligibleTarget = function(e) {
		return !e.isCloaked && ((e.isPlayer && !e.docked) || (e.isShip && e.ispiloted && (!e.isThargoid || e.primaryRole === "thargoidRebel")));
	};

	this.$cursePlayer = function() {
		this.ship.commsMessage(expandDescription("[thargoid_curses]", player.ship));
	};


	/*
	---------
	DEBUGGING
	---------
	*/

	// this.$debugMessage = function( debugTxt )
	// {
	// 	if (!this.debug) { return; } // NB. THIS ROUTINE DOES NOTHING IF this.debug IS NOT TRUE
	// 	// else
	// 	if ( !debugTxt ) {
	// 		player.consoleMessage( "Problem with debug message text!", 30 );
	// 		return;
	// 	}
	// 	player.consoleMessage( "Interstellar Tweaks - "+debugTxt, 12 );
	// 	log( "InterstellarTweaks - debugging", debugTxt );
	// };


	/*
	----------------------
	JSHINT: end of wrapper
	----------------------
	*/

}).call(this);


// EOF