/*
========================================================================
IST_pirate.js
This file is part of the Interstellar Tweaks expansion pack.
Author: UK_Eliter
License: 2017 Creative Commons: attribution, non-commercial, sharealike.
========================================================================
*/


/*
====================
JSLINT: set options
====================
*/

/*jshint esversion: 6*/
/*jshint sub:true*/


this.name = "IST_pirate.js";
this.author = "UK_Eliter";
this.copyright = "2014 Creative Commons: attribution, non-commercial, sharealike.";
this.licence = "CC-NC-SA 3";
this.description = "A ship script for the Interstellar Tweaks OXP";


/*
------------------
DEBUGGING SWITCHES
------------------
*/

// this.logging = true;

var consoleDebugMessages = false;
// Do NOT comment this out. Rather, to disable, set to false.

this.debug = false;
// false


/*
------------------------
JSLINT: start of wrapper
------------------------
*/

(function() {
	"use strict";


	/*
	--------------
	EVENT HANDLERS
	--------------
	*/

	this.shipSpawned = function() {
		var r = Math.random();
		if (r < 0.6) {
			// Try to replace a normal missile with a more interesting type.
			this.ship.removeEquipment("EQ_MISSILE");
			var missileDeficit = this.ship.missileCapacity - this.ship.missiles.length;
			if (worldScripts["CT_masterScript"] !== undefined) {
				this.ship.awardEquipment("EQ_ARMOURY_CUTPURSE_MISSILE");
			} else {
				this.ship.awardEquipment("EQ_HARDENED_MISSILE");
			}
		}
		// Bounty
		if (r > 0.2) {
			if (r > 0.94) {
				this.ship.bounty = 50 + (r * Math.ceil(200));
			} else {
				this.ship.bounty = 7 + (r * Math.ceil(90));
			}
		}
		this.ship.script.$playerHasAttackedPirates = false;
		// this.$debugMessage("Set variable to "+this.ship.script.$playerHasAttackedPirates);
		delete this.shipSpawned;
	};

	this.shipDied = this.entityDestroyed = this.playerWillEnterWitchspace = function() {
		this.$_deleteDetectDecloakTimer();
	};

	this.shipTakingDamage = function(amount, whom, type) {
		if (whom !== player.ship) {
			return;
		}
		// Else
		if (this.ship.script.$playerHasAttackedPirates === false) {
			this.ship.script.$playerHasAttackedPirates = true;
			// this.$debugMessage("Set variable to "+this.ship.script.$playerHasAttackedPirates);
		}
	};

	this.shipBeingAttackedByCloaked = function() {
		// From the wiki: 'There is no parameter provided to identify the cloaked ship.'
		if (!this.cloakedTarget) {
			this.cloakedTarget = system.filteredEntities(this, this.$isCloaked, this.ship, 25600)[0];
		}
		if (this.cloakedTarget && this.cloakedTarget.isCloaked) {
			if (this.detectDecloakTimer) {
				if (!this.detectDecloakTimer.isRunning) {
					this.detectDecloakTimer.start();
				}
				// This shouldn't happen - because deleted after each use.
			} else {
				var num = 0.2 + Math.random();
				this.detectDecloakTimer = new Timer(this, $detectDecloakTimed, num, 2.65);
			}
		}
	};

	/*
	---------------------
	ROUTINES CALLED BY AI
	---------------------
	*/

	this.$_deleteDetectDecloakTimer = function $_deleteDetectDecloakTimer() {
		if (this.detectDecloakTimer) {
			if (this.detectDecloakTimer.isRunning) {
				this.detectDecloakTimer.stop();
			}
			delete this.detectDecloakTimer;
		}
	};

	// This function called by AI
	this.$_seekVictim = function() {
		if (!this.ship || !this.ship.isPiloted) {
			return;
		}
		var potentialTargets = system.filteredEntities(this, this.$isPotentialTarget, this.ship, 25600);
		var numPotentialTargets = potentialTargets.length;
		if (numPotentialTargets < 1) {
			this.ship.reactToAIMessage("NOTHING_FOUND");
			return;
			// No need to scan for dead tharglets, 'cos they'll be got via AI's SCAN_FOR_LOOT.
		}
		// Else
		var r = Math.random();
		if ((numPotentialTargets === 1) || (r < 0.5)) {
			this.ship.target = potentialTargets[0];
		} else {
			if ((numPotentialTargets === 2) || (r > 0.6)) {
				this.ship.target = potentialTargets[1];
			} else {
				this.ship.target = potentialTargets[2];
			}
		}
		this.ship.reactToAIMessage("TARGET_FOUND");
	};

	this.$_haveEngaged = function() {
		// Rationale: if this ship is attacking the player, then either this ship or a group-mate OKed it; since it might have been a group mate, tell THIS ship that the player is henceforth a target.
		if (this.ship.target !== player.ship) {
			return;
		}
		// Otherwise
		if (this.ship.script.$playerHasAttackedPirates === false) {
			this.ship.script.$playerHasAttackedPirates = true;
			// this.$debugMessage("Set variable to "+this.ship.script.$playerHasAttackedPirates);
		}
	};


	/*
	--------------
	OTHER ROUTINES
	--------------
	*/

	this.$isCloaked = function(e) {
		return e.isShip && e.isCloaked;
	};

	this.$isPotentialTarget = function(e) {
		return e.isShip && !e.isCloaked && e.isPiloted && (((e.isPirateVictim || e.hasRole("hiredGuns_escort") || e.isPlayer || e.primaryRole === "IST_lobster") && (e.bounty < 50 || e.primaryRole === "IST_lobster")) || (e.isPlayer && this.ship.script.$playerHasAttackedPirates));
	};
	// Cf. this.shipSpawned and this.shipTakingDamage

	this.$detectDecloakTimed = function() {
		if (!this.ship || !this.ship.isPiloted) {
			this.$_deleteDetectDecloakTimer();
			return;
		}
		if (!this.cloakedTarget || !this.cloakedTarget.isValid) {
			this.$_deleteDetectDecloakTimer();
			this.ship.reactToAIMessage("TARGET_LOST");
			return;
		}
		if (this.ship.position.distanceTo(this.cloakedTarget) > 25600) {
			this.$_deleteDetectDecloakTimer();
			this.ship.reactToAIMessage("TARGET_LOST");
			return;
		}
		if (this.cloakedTarget.isCloaked) {
			return;
		} // keep checking
		this.$_deleteDetectDecloakTimer();
		this.ship.target = this.cloakedTarget;
		this.ship.reactToAIMessage("TARGET_DECLOAKED");
	};


	/*
	--------------
	DEBUGGING CODE
	--------------
	*/

	// this.$debugMessage = function(debugTxt)
	// {
	// 	if ( !this.debug ) { return; } // NB. THIS ROUTINE DOES NOTHING IF this.debug IS NOT TRUE
	// 	// else
	// 	if ( !debugTxt ) {
	// 		player.consoleMessage( "Problem with debug message text!", 30 );
	// 		return;
	// 	}
	// 	player.consoleMessage( "Interstellar Tweaks, PIRATES - "+debugTxt, 12 );
	// 	log( "InterstellarTweaks, PIRATES - debugging", debugTxt );
	// };


	/*
	----------------------
	JSHINT: end of wrapper
	----------------------
	*/

}).call(this);


// EOF