/* jshint esversion: 6 */

/*
---------------------------------
HEADER
---------------------------------
*/


this.name = "IST_genship.js";
this.author = "UK_Eliter";
this.copyright = "2014 Creative Commons: attribution, non-commercial, sharealike.";
this.licence = "CC-NC-SA 3";
this.description = "A ship script for the Interstellar Tweaks OXP";

/*
---------------------------------
DEBUGGING SWITCHES
---------------------------------
*/

this.logging = false;
//	Corresponds to, or needs, settings in logcontrol.plist?

this.debug = false;
//	false

var consoleDebugMessages = false;
//	Do NOT comment this out. Rather, to disable, set to false.


/*
---------------------------------
SOUNDS
---------------------------------
*/

var mysound_Warning = new SoundSource();
mysound_Warning.sound = "warning.ogg";
//	This sound built-in to Oolite - and does not need to be declared in the 'customsounds' file.

/*
---------------------------------
JSLINT: start of wrapper
---------------------------------
*/

(function() {
	"use strict";

	/*
	---------------------------------
	DEBUGGING
	---------------------------------
	*/

	this.$debugMessage = function(debugTxt) {
		if (!this.debug) {
			return;
		} // NB. THIS ROUTINE DOES NOTHING IF this.debug IS NOT TRUE
		// else
		if (!debugTxt) {
			player.consoleMessage("Problem with debug message text!", 30);
			return;
		}
		player.consoleMessage("Interstellar Tweaks - " + debugTxt, 12);
		log("InterstellarTweaks - debugging", debugTxt);
	};


	/*
	---------------------------------
	MISC
	---------------------------------
	*/

	this.$isEligibleTarget = function(e) {
		return !e.isCloaked && ((e.isPlayer && !e.docked) || (e.isShip && e.ispiloted && (!e.isThargoid || e.primaryRole === "thargoidRebel")));
	};


	/*
	---------------------------------
	ROUTINES CALLED BY AI
	---------------------------------
	*/

	this.$_findNearTargets = function() {
		var nearArray = system.filteredEntities(this, this.$isEligibleTarget, this.ship, 25600);
		if (nearArray.length == 0) {
			this.ship.reactToAIMessage("NOTHING_FOUND");
			return;
		}
		// Else ..
		this.targetNumber = ~~(Math.random() * nearArray.length); // NB: ~~ (a.k.a.) math.floor (as Vs .ceil) is correct
		if (this.targetNumber > nearArray.length) {
			log(this.name + " script error, target number too high - please report");
			this.targetNumber = 0;
		}
		this.ship.target = nearArray[this.targetNumber];
		this.ship.reactToAIMessage("TARGET_FOUND");
		if (this.debug) {
			this.$debugMessage("Near target");
		}
	};

	this.$_findFarTargets = function() {
		var farArray = system.filteredEntities(this, this.$isEligibleTarget, this.ship, 70000);
		if (farArray.length == 0) {
			this.ship.reactToAIMessage("NOTHING_FOUND");
			// this.$debugMessage("NO far target");
			return;
		}
		// Else ..
		this.ship.target = farArray[0]; // set to the closest target off-scanner but in range
		this.ship.reactToAIMessage("TARGET_FOUND");
		if (this.debug) {
			this.$debugMessage("Far target");
		}
	};

	this.$_validateTarget = function() {
		if (this.ship.target && this.ship.target.isValid && this.$isEligibleTarget(this.ship.target)) {
			this.ship.reactToAIMessage("TARGET_VALID");
		} else {
			this.ship.reactToAIMessage("TARGET_INVALID");
		}
	};

	this.$_curse = function() {
		this.ship.commsMessage(expandDescription("[thargoid_curses]"), player.ship);
	};


	/*
	---------------------------------
	JSLINT: end of wrapper
	---------------------------------
	*/

}).call(this);


// EOF