/*
========================================================================
IST_derelict.js
This file is part of the Interstellar Tweaks expansion pack.
Author: UK_Eliter
License: 2017 Creative Commons: attribution, non-commercial, sharealike.
========================================================================
*/


this.name = "IST_derelict.js";
this.author = "UK_Eliter";
this.copyright = "2014 Creative Commons: attribution, non-commercial, sharealike.";
this.licence = "CC-NC-SA 3";
this.description = "A script for InterstellarTweaks OXP";

/*
--------------------------------------------
Start of wrapper for JSHINT 
See also Jshint options above.
The following should be: 'function(){' (sic)
--------------------------------------------
*/
(
	function() {

		"use strict";

		/*
		------------------
		DEBUGGING SWITCHES
		------------------
		*/

		// this.logging = true;
		var consoleDebugMessages = false; // do NOT comment this out. Rather, to disable, set to false.


		/*
		--------------
		EVENT HANDLERS
		--------------
		*/

		this.shipSpawned = function() {
			var r = Math.random();
			if (this.ship.hasRole("IST_derelictthargoid")) {
				r += 0.1;
			}
			if (r < 0.2) {
				var fuel = Math.random() * 2.4; // this is in lightyears
				if (r < 0.12) {
					fuel *= (1 + r);
				}
				this.ship.fuel = fuel;
			}
			r = Math.random();
			if (r < 0.9) {
				// energy *recharge* inaccessible via script. (But can use a script for isTakingDamage, or - as in fact I've done - set the rate in shipdata.)
				if (r < 0.5) {
					this.ship.energy *= 0.2;
				} else {
					this.ship.energy *= r;
				}
			}
			delete this.shipSpawned;
		};

		this.shipTakingDamage = function(amount) {
			if (this.ship.energy > amount) {
				return;
			}
			if (this.ship.AI === "IST_bombAI.plist") {
				return;
			}
			if (Math.random() <= 0.015) // 0.015
			{
				this.ship.energy = 50; // ship is about to explode, keep it alive for a moment.
				this.ship.switchAI("IST_bombAI.plist");
				return;
			}
			if (this.ship.cargoSpaceCapacity > 0 && Math.random() < 0.15) // 0.15
			{
				this.ship.energy = 50; // ship is about to explode, keep it alive for a moment.
				var numOfPodsToEject;
				if (this.ship.cargoSpaceCapacity < 8) // this number relates to one below, marked '*'
				{
					numOfPodsToEject = Math.ceil(Math.random() * (this.ship.cargoSpaceCapacity / 4));
				} else {
					numOfPodsToEject = Math.ceil(Math.random() * (this.ship.cargoSpaceCapacity / 7));
					if (numOfPodsToEject > 30) {
						numOfPodsToEject -= 10;
					} else if (numOfPodsToEject > 15) {
						numOfPodsToEject -= (Math.ceil(Math.random() * 12));
					} else if ((numOfPodsToEject > 7) && (Math.random() < 0.5)) {
						numOfPodsToEject = Math.ceil(Math.random() * (numOfPodsToEject / 2));
					}
				}
				this.ship.spawn("cargopod", numOfPodsToEject);
				this.ship.explode(true);
			}
		};

		/*
		------------------------------
		End of wrapper for JSHINT.
		See also Jshint options above.
		------------------------------
		*/

	}).call(this);

// EOF
