"use strict";

this.name    = "eq_dynooversal_randomizer";
this.version = "1.0";

/* ========================================================
        DYNOOVERSAL RANDOMIZER

  Updates biases in the Dynooverse worldScript.
=========================================================== */

// Helper function to generate a random bias value between 0.33 and 0.66
this._getRandomBias = function () {
    return 0.33 + Math.random() * 0.33; // Random value in range [0.33, 0.66]
};

this._updateBiases = function (mood) {
    var ws = worldScripts.dynooverse;
    if (ws && ws.biases) {
        var biases;
        if (mood === "random") {
            biases = {
                agriculture: this._getRandomBias(),
                industry: this._getRandomBias(),
                government: this._getRandomBias(),
                techlevel: this._getRandomBias(),
                population: this._getRandomBias()
            };
            log(this.name, "Biases updated randomly.");
            player.consoleMessage("Dynooversal biases updated randomly.", 6);
        } else if (mood === "neutral") {
            biases = {
                agriculture: 0.5,
                industry: 0.5,
                government: 0.5,
                techlevel: 0.5,
                population: 0.5
            };
            log(this.name, "Biases returned to neutral settings.");
            player.consoleMessage("Dynooversal biases returned to neutral settings.", 6);
        }
        ws.biases = biases;
    } else {
        player.ship.removeEquipment("EQ_WA_DYNOOVERSAL_RANDOM");
        log(this.name, "Removed EQ_WA_DYNOOVERSAL_RANDOM due to missing dynooverse.");
        log(this.name, "Error: dynooverse or its biases property is not available.");
        player.consoleMessage("Error: Dynooverse is required for this equipment.", 10);
    }
};

/* ========================================================
        RANDOM MODE

    Set all biases randomly.
    This function is triggered by a player pressing [b].
=========================================================== */

this.mode = function () {
    this._updateBiases("random");
};

/* ========================================================
        NEUTRAL MODE

    Set all biases to 0.5.
    This function is triggered by a player pressing [n].
=========================================================== */

this.activated = function () {
    this._updateBiases("neutral");
};

/* ========================================================
            THE END
=========================================================== */