"use strict";

this.name    = "eq_dynooversal_moodifier";
this.version = "1.0";

/* ========================================================
        DYNOOVERSAL MOODIFIER

  Updates biases based on player mood ("bloom" or "gloom").
=========================================================== */

this._updateBiases = function (mood) {
    var ws = worldScripts.dynooverse;
    if (ws && ws.biases) {
        var biases;
        if (mood === "bloom") {
            biases = {
                agriculture: 0.6,
                industry: 0.6,
                government: 0.6,
                techlevel: 0.6,
                population: 0.6
            };
            log(this.name, "Biases updated to 'Bloom' mode.");
            player.consoleMessage("Dynooversal biases updated to 'Bloom' mode.", 6);
        } else if (mood === "gloom") {
            biases = {
                agriculture: 0.4,
                industry: 0.4,
                government: 0.4,
                techlevel: 0.4,
                population: 0.4
            };
            log(this.name, "Biases updated to 'Gloom' mode.");
            player.consoleMessage("Dynooversal biases updated to 'Gloom' mode.", 6);
        }
        ws.biases = biases;
    } else {
        player.ship.removeEquipment("EQ_WA_DYNOOVERSAL_MOOD");
        log(this.name, "Removed EQ_WA_DYNOOVERSAL_MOOD due to missing dynooverse.");
        log(this.name, "Error: dynooverse or its biases property is not available.");
        player.consoleMessage("Error: Dynooverse is required for this equipment.", 10);
    }
};

/* ========================================================
        BLOOM MODE

    Set all biases to 0.6, favouring increment.
    This function is triggered by a player pressing [b].
=========================================================== */

this.mode = function () {
    this._updateBiases("bloom");
};

/* ========================================================
        GLOOM MODE

    Set all biases to 0.4, favouring decrement.
    This function is triggered by a player pressing [n].
=========================================================== */

this.activated = function () {
    this._updateBiases("gloom");
};

/* ========================================================
            THE END
=========================================================== */