// I want to create a second script, to be included in the Dynooverse mod, but seperate from the main dynooverse script.
// It should gather relevant statistics for the 256 systems of the present galaxyNumber.

     // TODO: Gather useful statistics, such as the extreme values, or frequency of values,
     // for the system properties dynooverse could change, before dynooverse changes anything.
     // Format statistics and send to log.

// JavaScript. Specifically oolite.jsVersion 185, an Oolite specific variant of ECMAv5.
// N.B. We can use "const" and "let" where appropriate, but avoid all other ES6 features.
// N.B. Do not use template literals to compose log message texts. 

"use strict";

// worldScripts.dynooverse_stats

this.name = "dynooverse_stats";

// playerEnteredNewGalaxy
// The playerEnteredNewGalaxy handler is called immediately whenever the value of the galaxyNumber changes.
this.playerEnteredNewGalaxy = function (galaxyNumber) {
    // Initialize statistics objects
    var stats = {
        techlevel: { min: Infinity, max: -Infinity, frequency: {} },
        economy: { min: Infinity, max: -Infinity, frequency: {} },
        government: { min: Infinity, max: -Infinity, frequency: {} },
        population: { min: Infinity, max: -Infinity, total: 0, count: 0 },
        productivity: { min: Infinity, max: -Infinity, total: 0, count: 0 },
        descriptionLength: { min: Infinity, max: -Infinity, total: 0, count: 0 }
    };

    // Iterate over all 256 systems in the current galaxy
    for (var sysID = 0; sysID < 256; sysID++) {
        var sys = System.infoForSystem(galaxyNumber, sysID);
        if (sys) {
            // Update techlevel statistics
            if (sys.techlevel !== undefined) {
                stats.techlevel.min = Math.min(stats.techlevel.min, sys.techlevel);
                stats.techlevel.max = Math.max(stats.techlevel.max, sys.techlevel);
                stats.techlevel.frequency[sys.techlevel] = (stats.techlevel.frequency[sys.techlevel] || 0) + 1;
            }

            // Update economy statistics
            if (sys.economy !== undefined) {
                stats.economy.min = Math.min(stats.economy.min, sys.economy);
                stats.economy.max = Math.max(stats.economy.max, sys.economy);
                stats.economy.frequency[sys.economy] = (stats.economy.frequency[sys.economy] || 0) + 1;
            }

            // Update government statistics
            if (sys.government !== undefined) {
                stats.government.min = Math.min(stats.government.min, sys.government);
                stats.government.max = Math.max(stats.government.max, sys.government);
                stats.government.frequency[sys.government] = (stats.government.frequency[sys.government] || 0) + 1;
            }

            // Update population statistics
            if (sys.population !== undefined) {
                stats.population.min = Math.min(stats.population.min, sys.population);
                stats.population.max = Math.max(stats.population.max, sys.population);
                stats.population.total += sys.population;
                stats.population.count++;
            }

            // Update productivity statistics
            if (sys.productivity !== undefined) {
                stats.productivity.min = Math.min(stats.productivity.min, sys.productivity);
                stats.productivity.max = Math.max(stats.productivity.max, sys.productivity);
                stats.productivity.total += sys.productivity;
                stats.productivity.count++;
            }

            // Update description length statistics
            if (sys.description !== undefined) {
                var descLength = sys.description.length;
                stats.descriptionLength.min = Math.min(stats.descriptionLength.min, descLength);
                stats.descriptionLength.max = Math.max(stats.descriptionLength.max, descLength);
                stats.descriptionLength.total += descLength;
                stats.descriptionLength.count++;
            }
        }
    }

    // Calculate averages
    var avgPopulation = stats.population.count > 0 ? Math.round(stats.population.total / stats.population.count) : 0;
    var avgProductivity = stats.productivity.count > 0 ? Math.round(stats.productivity.total / stats.productivity.count) : 0;
    var avgDescriptionLength = stats.descriptionLength.count > 0 ? Math.round(stats.descriptionLength.total / stats.descriptionLength.count) : 0;

    // Format and log the results
    var logMessage = "Statistics for Galaxy " + galaxyNumber + ":\n";

    // Techlevel stats
    logMessage += "Techlevel:\n";
    logMessage += "  Min: " + stats.techlevel.min + "\n";
    logMessage += "  Max: " + stats.techlevel.max + "\n";
    logMessage += "  Frequency: ";
    for (var tl in stats.techlevel.frequency) {
        logMessage += "TL" + tl + "=" + stats.techlevel.frequency[tl] + " ";
    }
    logMessage += "\n";

    // Economy stats
    logMessage += "Economy:\n";
    logMessage += "  Min: " + stats.economy.min + "\n";
    logMessage += "  Max: " + stats.economy.max + "\n";
    logMessage += "  Frequency: ";
    for (var econ in stats.economy.frequency) {
        logMessage += "Econ" + econ + "=" + stats.economy.frequency[econ] + " ";
    }
    logMessage += "\n";

    // Government stats
    logMessage += "Government:\n";
    logMessage += "  Min: " + stats.government.min + "\n";
    logMessage += "  Max: " + stats.government.max + "\n";
    logMessage += "  Frequency: ";
    for (var gov in stats.government.frequency) {
        logMessage += "Gov" + gov + "=" + stats.government.frequency[gov] + " ";
    }
    logMessage += "\n";

    // Population stats
    logMessage += "Population:\n";
    logMessage += "  Min: " + stats.population.min + "\n";
    logMessage += "  Max: " + stats.population.max + "\n";
    logMessage += "  Average: " + avgPopulation + "\n";

    // Productivity stats
    logMessage += "Productivity:\n";
    logMessage += "  Min: " + stats.productivity.min + "\n";
    logMessage += "  Max: " + stats.productivity.max + "\n";
    logMessage += "  Average: " + avgProductivity + "\n";

    // Description Length stats
    logMessage += "Description Length:\n";
    logMessage += "  Min: " + stats.descriptionLength.min + "\n";
    logMessage += "  Max: " + stats.descriptionLength.max + "\n";
    logMessage += "  Average: " + avgDescriptionLength + "\n";

    // Log the final message
    log(this.name, logMessage);

    // Store the log message in missionVariables
    missionVariables.dynooverse_stats = logMessage;

    // Store the raw stats object in a galaxy-specific missionVariable
    missionVariables["dynooverse_stats_" + galaxyNumber] = JSON.stringify(stats);
};

